
import qualified Data.Map.Strict as Map
import Control.Monad.State -- imports runstate
import System.Environment (getArgs, getProgName)

import Bestmove
import Bitboard
import Fen

main :: IO ()
main = do
  args <- getArgs
  case args of 
    [algo, depthStr] -> do
      let depth = read depthStr :: Int  
          board = startpos              
          color = 1                     

      case algo of 
        "base" -> do
          let bestMove = chooseBestMove (-1) board depth
          putStrLn
            ("Best move found minimax only d="
              ++ show depth
              ++ ": "
              ++ showMove bestMove (-1)
            )
        "cache" -> do
          let (bestMove, _) = runState (chooseBestMoveCache (-1) board depth) Map.empty
          putStrLn
            ("Best move found minimax and cache d="
              ++ show depth
              ++ ": "
              ++ showMove (extractMove bestMove) (-1)
            ) 
        "ab" -> do
          let (bestMove, _) = runState (chooseBestMovePar (-1) board depth) Map.empty
          putStrLn
            ("Best move found minimax and cache and ab d="
              ++ show depth
              ++ ": "
              ++ showMove (extractMove bestMove) (-1)
            ) 
        _ -> error "Unknown algorithm. Choose 'base', 'caching', or 'ab'."
    _ -> putStrLn "Usage: program <algo> <depth>"