module Fen where

-- #################################################################
data FEN = FEN
  { board_fen :: String
  , activeColor :: Char
  , castling :: String
  , enPassant :: String
  , halfMoveClock :: Int
  , fullMoveNumber :: Int
  }

instance Show FEN where
  show fen =
    board_fen fen
      ++ " "
      ++ [activeColor fen]
      ++ " "
      ++ castling fen
      ++ " "
      ++ enPassant fen
      ++ " "
      ++ show (halfMoveClock fen)
      ++ " "
      ++ show (fullMoveNumber fen)

-- call to set the default setting of the fen notation of the engine 
setDefaultFen :: FEN
setDefaultFen =
  FEN
    { board_fen = "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR" -- Standard starting position
    , activeColor = 'w' -- White to move
    , castling = "KQkq" -- Both sides can castle
    , enPassant = "-" -- No en passant square
    , halfMoveClock = 0 -- No halfmoves yet
    , fullMoveNumber = 1 -- First move
    }
