module Main where

import Test.HUnit
import Game2048 (initialBoard, isFull, hasReachedTarget)

-- Test cases
testInitialBoard :: Test
testInitialBoard = TestCase $ do
    board <- initialBoard
    let nonEmptyTiles = length $ filter (/= 0) $ concat board
    assertEqual "Initial board should have 2 non-empty tiles" 2 nonEmptyTiles

testIsFull :: Test
testIsFull = TestCase $ do
    let board = [[1, 2, 3, 4], [5, 6, 7, 8], [9, 10, 11, 12], [13, 14, 15, 16]]
    assertBool "isFull should return True for a full board" (isFull board)

-- Combine tests
tests :: Test
tests = TestList [TestLabel "Initial Board Test" testInitialBoard, TestLabel "Is Full Test" testIsFull]

-- Main function to run tests
main :: IO ()
main = do
    counts <- runTestTT tests
    print counts
