module Main where

import System.Environment (getArgs)
import Game2048 (runGame, running10Games)

-- Main function to handle command-line arguments
main :: IO ()
main = do
    args <- getArgs
    case args of
        ["run", "1", depthStr] -> do
            let depth = read depthStr :: Int
            putStrLn "Running 1 game..."
            _ <- runGame True depth  -- Enable board printing for a single game
            return ()
        ["run", "10", depthStr] -> do
            let depth = read depthStr :: Int
            putStrLn "Running 10 games..."
            running10Games depth
        _ -> do
            putStrLn "Usage:"
            putStrLn "  ./2048solver run 1 <depth>   -- Run 1 game and print the board"
            putStrLn "  ./2048solver run 10 <depth>  -- Run 10 games and show summary"
