#ifndef _VGA_BALL_H
#define _VGA_BALL_H

#include <linux/ioctl.h>
//#include <stdint.h>

typedef struct {
  char tile_row0, tile_row1, tile_row2, tile_row3;
} vga_ball_tile_array_data_t;

typedef struct {
  unsigned int address;
} vga_ball_tile_array_address_t;

typedef struct {
    char data;
    short address;
    char blank;
} vga_ball_tile_map_t;

//arg structs for ioctl

typedef struct {
    short x_coor;
    short y_coor;
} vga_ball_xy_t;

typedef struct {
    short bx0;
    short by0;
} vga_ball_barrel0_xy_t;

typedef struct {
    short bx1;
    short by1;
} vga_ball_barrel1_xy_t;

typedef struct {
    short bx2;
    short by2;
} vga_ball_barrel2_xy_t;

typedef struct {
    short bx3;
    short by3;
} vga_ball_barrel3_xy_t;

typedef struct {
    short bx4;
    short by4;
} vga_ball_barrel4_xy_t;

typedef struct {
    unsigned int state;
} vga_ball_sprite_state_t;

typedef struct {
    unsigned int hhstate;
} vga_ball_hh_state_t;

typedef struct {
  vga_ball_tile_array_data_t data;
  vga_ball_tile_array_address_t address;
} vga_ball_arg_t;

typedef struct {
  vga_ball_tile_map_t tile_map;
} vga_ball_arg2_t;

typedef struct {
  vga_ball_xy_t coor;
} vga_ball_arg3_t;

typedef struct {
  vga_ball_sprite_state_t m_state;
} vga_ball_arg4_t;

typedef struct {
  vga_ball_barrel0_xy_t coor;
} vga_ball_arg5_t;

typedef struct {
  vga_ball_barrel1_xy_t coor;
} vga_ball_arg6_t;

typedef struct {
  vga_ball_barrel2_xy_t coor;
} vga_ball_arg7_t;

typedef struct {
  vga_ball_barrel3_xy_t coor;
} vga_ball_arg8_t;

typedef struct {
  vga_ball_barrel4_xy_t coor;
} vga_ball_arg9_t;

typedef struct {
  vga_ball_hh_state_t m_state;
} vga_ball_arg10_t;


#define VGA_BALL_MAGIC 'q'

/* ioctls and their arguments */

#define VGA_BALL_TILE_ARRAY _IOW(VGA_BALL_MAGIC, 1, vga_ball_arg_t *)
#define VGA_BALL_TILE_MAP  _IOW(VGA_BALL_MAGIC, 2, vga_ball_arg2_t *)
#define VGA_BALL_MARIO_COORDINATES _IOW(VGA_BALL_MAGIC, 3, vga_ball_arg3_t *)
#define VGA_BALL_SPRITE_STATE  _IOW(VGA_BALL_MAGIC, 4, vga_ball_arg4_t *)
#define VGA_BALL_BARREL0_COORDINATES  _IOW(VGA_BALL_MAGIC, 5, vga_ball_arg5_t *)
#define VGA_BALL_BARREL1_COORDINATES  _IOW(VGA_BALL_MAGIC, 6, vga_ball_arg6_t *)
#define VGA_BALL_BARREL2_COORDINATES  _IOW(VGA_BALL_MAGIC, 7, vga_ball_arg7_t *)
#define VGA_BALL_BARREL3_COORDINATES  _IOW(VGA_BALL_MAGIC, 8, vga_ball_arg8_t *)
#define VGA_BALL_BARREL4_COORDINATES  _IOW(VGA_BALL_MAGIC, 9, vga_ball_arg9_t *)

#define VGA_BALL_HH_STATE  _IOW(VGA_BALL_MAGIC, 10, vga_ball_arg10_t *)


#endif
