/*
 * Avalon memory-mapped peripheral that generates VGA
 *
 * Stephen A. Edwards
 * Columbia University
 */

module music(input logic clk, 
            output logic speaker);
    input clk;
    output speaker;

    // first create a 16bit binary counter
    reg [15:0] counter;
    always @(posedge clk) counter <= counter+1;

    // and use the most significant bit (MSB) of the counter to drive the speaker
    assign speaker = counter[15];
endmodule

