module LoadData where
import Apriori ( Itemset(..) )
import qualified Data.Set as Set
import Text.CSV (parseCSVFromFile)
import System.Exit (die)


-- read the csv file to get a list of transactions
readTableToLst :: FilePath -> IO [Itemset]
readTableToLst filename = do
    csv_file <- parseCSVFromFile filename
    case csv_file of
        Right csv -> return $ getTransactions csv
        Left err -> die $ show err
    where
        getItemset record = Itemset $ Set.fromList $ filter (/= "") record
        getTransactions csv = map getItemset csv