module Main where
import Apriori ( getAssocRules, getFreqItemsets, getInitFreqItemset, 
                aprioriChunk, aprioriByChunkSize, 
                getInitFreqItemsetS, getFreqItemsetsS )

import LoadData ( readTableToLst )

import qualified Data.List as List
import System.Exit (die)
import System.Environment (getArgs, getProgName)


main :: IO ()
main = do
    args <- getArgs
    case args of
        -- sequential
        [fn, sp, cf, "seq"] -> do
            let filename = fn
                support = read sp :: Double
                confidence = read cf :: Double
            -- get all transactions
            transactions <- readTableToLst filename
            let initFreqItemset = getInitFreqItemsetS support transactions
                freqItemsets = concat $ List.unfoldr (getFreqItemsetsS support transactions) initFreqItemset
            print $ getAssocRules confidence transactions freqItemsets
        -- parMap
        [fn, sp, cf] -> do
            let filename = fn
                support = read sp :: Double
                confidence = read cf :: Double
            -- get all transactions
            transactions <- readTableToLst filename
            let initFreqItemset = getInitFreqItemset support transactions
                freqItemsets = concat $ List.unfoldr (getFreqItemsets support transactions) initFreqItemset
            print $ getAssocRules confidence transactions freqItemsets
        -- mapReduce
        [fn, sp, cf, "chunk"] -> do
            let filename = fn
                support = read sp :: Double
                confidence = read cf :: Double
            -- get all transactions
            transactions <- readTableToLst filename
            print $ aprioriChunk transactions support confidence
        -- mapReduce with chunk size
        [fn, sp, cf, "chunk", cs] -> do
            let filename = fn
                support = read sp :: Double
                confidence = read cf :: Double
                chunkSize = read cs :: Int
            -- get all transactions
            transactions <- readTableToLst filename
            print $ aprioriByChunkSize chunkSize transactions support confidence
        _ -> do
            pn <- getProgName
            die $ "Usage: stack exec "++pn++" <csv_filename> <min_support> <min_confidence> [seq] | [chunk] | [chunk <chunk_size>]"
    
    
    
