# apriori-parallel

Author: Hongfei Chen (hc3222@columbia.edu)

## Usage

- To build the program, please first run `stack setup` and `stack build`.

- The basic usage of the program is 

    `stack exec apriori-parallel-exe <csv_filename> <min_support> <min_confidence>`

    This will parallelize the steps of Apriori Algorithm using `parMap` from `Control.Monad.Par`.

- To execute the sequential implementation, add the keyword **seq** to the command:

    `stack exec apriori-parallel-exe <csv_filename> <min_support> <min_confidence> seq`

- To apply MapReduce, use the keyword **chunk**:

    `stack exec apriori-parallel-exe <csv_filename> <min_support> <min_confidence> chunk`

- You may also specify the size of chunk by **chunk <chunk_size>**:

    `stack exec apriori-parallel-exe <csv_filename> <min_support> <min_confidence> chunk <chunk_size>`


## Tests

- There are some sample input csv files in the "test" folder.

- Recommended tests:
    
    The folloing tests all produce eventlogs.

    `stack exec apriori-parallel-exe "test/trans2000.csv" 0.001 0.5 -- +RTS -N2 -ls`

    `stack exec apriori-parallel-exe "test/trans4000.csv" 0.001 0.5 -- +RTS -N4 -ls`

    `stack exec apriori-parallel-exe "test/trans2000.csv" 0.001 0.5 seq -- +RTS -N1 -ls`

    `stack exec apriori-parallel-exe "test/trans2000.csv" 0.001 0.5 chunk -- +RTS -N2 -ls`

    `stack exec apriori-parallel-exe "test/trans2000.csv" 0.001 0.5 chunk 5 -- +RTS -N2 -ls`

    