(* Andy Hunter
PLT Summer 15
Trix *)

open Printf

let filename = ref "output"

let writefile name line =
    let outputfile = open_out name in
      fprintf outputfile "%s\n" line;
      close_out outputfile

let getfile path =
    let dir = (String.rindex path '/') in
		let len = (String.length path) - (dir + (String.length ".trx" +1)) in
    		String.sub path (dir + 1) (len)

let main () =
    let lexbuf = ignore(filename := getfile Sys.argv.(2)); 
                 Lexing.from_channel (open_in Sys.argv.(2)) in
    let program = Parser.program Scanner.token lexbuf in
   			let test1 = Target.trix_target program !filename in
               writefile (!filename ^ ".cpp") test1
