(* Andy Hunter
PLT Summer 15
Trix *)

open Ast

let vartype_str = function
  | Int -> "int"

let rec expr_str = function
  | Id(i) -> i
  | IntLiteral(j) -> string_of_int j  
  | Binop(k1, d, k2) -> expr_str k1 ^ " " ^ (match d with Add -> "+" | Sub -> "-" | Mult -> "*" | Div -> "/") ^ " " ^ expr_str k2
  | ApplyFunct(m, n) -> m ^ "(" ^ String.concat ", " (List.map expr_str n) ^ ")"  
  | Assign(a, b) -> a ^ " = " ^ expr_str b

let rec stmt_str = function
  | Expr(expr) -> expr_str expr ^ ";"
  | Return(expr) -> "return " ^ expr_str expr ^ ";";
  | If(a, b1, b2) ->  "if (" ^ expr_str a ^ ") {" ^ stmt_str b1 ^ "} else {" ^ stmt_str b2 ^ "}"
  | While(i, j) -> "while (" ^ expr_str i ^ ") {" ^ stmt_str j ^ "}"
  | Block(stmt) -> "{" ^ String.concat "" (List.map stmt_str stmt) ^ "}"

let vardecl_str id = (vartype_str id.vartype) ^ " " ^ id.varname

let varinit_str = function
 | Vinit(a, b) -> vardecl_str a ^ " = " ^ expr_str b

let vardef_str = function
 | VarDecl(a) -> vardecl_str a ^ ";"
 | Varinit(b) -> varinit_str b ^ ";"

let functdecl_str functdecl =
  functdecl.name ^ " (" ^ String.concat ", " (List.map vardecl_str functdecl.args) ^ ") {" ^ 
  (String.concat " " (List.map vardef_str functdecl.locvars)) ^
  String.concat " " (List.map stmt_str functdecl.body) ^ "}"

let prog_str (a, b) =
  String.concat " " (List.map vardef_str a) ^ " " ^ String.concat " " (List.map functdecl_str b)

module StringMap = Map.Make(String)

type scope = { functsig: string StringMap.t; globals:  dtype StringMap.t; locals:  dtype StringMap.t;}

let funct_string functdecl = 
    functdecl.name ^ "_" ^ String.concat "_" (List.map vardecl_str functdecl.args)

let vinitial = function
    | Vinit(c, _) -> (c.vartype, c.varname)

let getvnamedef = function
    | VarDecl (a) -> (a.vartype, a.varname)
    | Varinit(b) -> vinitial b

let rec svardef = function
    | [] -> []
    | hd::tl -> ( getvnamedef hd) :: svardef tl

let rec getvardef = function
    | [] -> []
    | hd::tl -> (hd.vartype, hd.varname) :: getvardef tl

let rec sfunct = function
    | [] -> []
    | hd::tl -> (funct_string hd, hd.name) ::  sfunct tl

let mapnew x y =
  List.fold_left (fun a (b, c) -> StringMap.add c b a) x y

let trix_target (globals, functions) out = 

  let global_Vars = mapnew StringMap.empty (svardef globals) in
  let functsigs = mapnew StringMap.empty (sfunct functions) in

  let targetnew scope functdecl = 
    let locals = svardef functdecl.locvars 
    and argvars = getvardef functdecl.args in
    let scope = mapnew StringMap.empty (locals @ argvars) in 
	
    let rec expr a = 
    (match a with
      | IntLiteral(b) ->  string_of_int b
      | Id(c) -> if ((StringMap.mem c scope.locals) || (StringMap.mem c scope.globals)) then c
     	 else raise (Failure ("no id:  " ^ c ))
      | Binop(d1,f,d2) ->  expr d1 ^ " " ^ (match f with Add -> "+" | Sub -> "-" | Mult -> "*" | Div -> "/") ^ " " ^ expr d2
      | Assign(v, a) ->  if ((StringMap.mem v scope.locals) || (StringMap.mem v scope.globals)) then v ^ "=" ^ expr a 
	  	else raise (Failure ("no id: " ^ v))
      | ApplyFunct(s, e) ->  if (StringMap.mem s scope.functsig) then ( s ^ "(" ^ (String.concat "," (List.map
                                 expr (List.rev e))) ^ ");") else raise (Failure ("no function: " ^ s)))
	   
    in let rec stmt = function
      | Expr(a) -> expr a ^ ";"
      | Return(b) -> "return " ^ expr b ^ ";"
      | If(c,d,e)  -> "if(" ^ expr c ^ "){ " ^ stmt d ^ "} else {" ^ stmt e ^ "} "
      | While(e,s) -> "while(" ^ expr e ^ ") {" ^ stmt s ^ " } "
      | Block(stmts) -> String.concat "" (List.map stmt stmts) ^ " "

    let scope = { functsig = functsigs; globals = global_Vars; locals = StringMap.empty } in

    let main_run = try
      (StringMap.find "main" functsigs) with Not_found -> raise (Failure ("no main"))
    in String.concat " " (List.map vardef_str (List.rev globals)) ^ " " ^
    (String.concat  " " (List.map (targetnew scope) (List.rev functions)))
