(* Andy Hunter
PLT Summer 15
Trix *)

{ open Parser }

rule token = parse
  | [' ' '\t' '\r' '\n'] { token lexbuf }
  | "%%" { comment lexbuf }  
  | "int" { INT }
  | "if" { IF }
  | "else" { ELSE }
  | "while" { WHILE }
  | "return" { RETURN }
  | "function" { FUNCTION }
  | '+' { PLUS }
  | '-' { MINUS }
  | '*' { TIMES }
  | '/' { DIVIDE }
  | '=' { ASSIGN }
  | '(' { LPAREN }
  | ')' { RPAREN }
  | '{' { LBRACE }
  | '}' { RBRACE }
  | ',' { COMMA }
  | ';' { SEMI }
  | ['0'-'9']+    as lxm { INT_LIT (int_of_string lxm) }
  | ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }
  | eof { EOF }
  | _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
  | "%%" { token lexbuf }
  | _ { comment lexbuf }
