# For those machine doesn't have ocamlbuild, build the project with this makefile

OBJ=ast.cmo \
	sast.cmo \
	semanalyze.cmo \
	scanner.cmo \
	parser.cmo \
	util.cmo \
	parser_test.cmo \
	semantic_test.cmo \
    interpreter.cmo \
    toplevel.cmo \
    values.cmo \
    output.cmo \
    printer.cmo

SMURF=semantic_test

FLAGS:=-g

$(SMURF): $(OBJ)
	ocamlc -g -o parser_test util.cmo parser.cmo scanner.cmo ast.cmo parser_test.cmo
	ocamlc -g -o semantic_test util.cmo parser.cmo scanner.cmo ast.cmo sast.cmo semanalyze.cmo semantic_test.cmo
	ocamlc -g -o toplevel util.cmo parser.cmo scanner.cmo ast.cmo sast.cmo semanalyze.cmo values.cmo output.cmo interpreter.cmo toplevel.cmo 

printer: $(OBJ)
	ocamlc -o printer.cma -a util.cmo ast.cmo sast.cmo values.cmo printer.cmo

.SUFFIXES: .ml .cmo .cmi .mll .mly .mli
.PRECIOUS: %.ml %.mli %.cmo

.ml.cmo:
	ocamlc -c $(FLAGS) $<

.mli.cmi:
	ocamlc -c $(FLAGS) $<
    
.mll.ml:
	ocamllex $<

.mly.ml:
	ocamlyacc -v $<

.mly.mli:
	ocamlyacc -v $<

clean:
	rm -f *.cmi *.cmo parser.ml scanner.ml *.output parser.mli parser_test semantic_test toplevel *.cma


parser_test: $(SMURF)
	./parser_testall.sh

# Generated by ocamldep
ast.cmo:
ast.cmx:
interpreter.cmo: values.cmo util.cmo sast.cmo output.cmo ast.cmo
interpreter.cmx: values.cmx util.cmx sast.cmx output.cmx ast.cmx
output.cmo: values.cmo util.cmo ast.cmo
output.cmx: values.cmx util.cmx ast.cmx
parser.cmo: util.cmo ast.cmo parser.cmi
parser.cmx: util.cmx ast.cmx parser.cmi
parser.cmi: ast.cmo
sast.cmo: util.cmo ast.cmo
sast.cmx: util.cmx ast.cmx
scanner.cmo: parser.cmi
scanner.cmx: parser.cmx
semanalyze.cmo: util.cmo sast.cmo ast.cmo
semanalyze.cmx: util.cmx sast.cmx ast.cmx
semantic_test.cmo: util.cmo semanalyze.cmo scanner.cmo sast.cmo parser.cmi
semantic_test.cmx: util.cmx semanalyze.cmx scanner.cmx sast.cmx parser.cmx
parser_test.cmo: scanner.cmo parser.cmi ast.cmo
parser_test.cmx: scanner.cmx parser.cmx ast.cmx
toplevel.cmo: values.cmo util.cmo semanalyze.cmo scanner.cmo parser.cmi \
            output.cmo interpreter.cmo
toplevel.cmx: values.cmx util.cmx semanalyze.cmx scanner.cmx parser.cmx \
            output.cmx interpreter.cmx
util.cmo:
util.cmx:
values.cmo: util.cmo sast.cmo ast.cmo
values.cmx: util.cmx sast.cmx ast.cmx
printer.cmo: util.cmo ast.cmo sast.cmo values.cmo
printer.cmx: util.cmx ast.cmx sast.cmx values.cmx


