/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class MessageInfo {
    public static String[] keyNames = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    public static String[] keySignatures = new String[]{"Cb", "Gb", "Db", "Ab", "Eb", "Bb", "F", "C", "G", "D", "A", "E", "B", "F#", "C#"};

    public static String toString(MidiMessage midiMessage) {
        if (midiMessage instanceof ShortMessage) {
            return MessageInfo.toString((ShortMessage)midiMessage);
        }
        if (midiMessage instanceof SysexMessage) {
            return MessageInfo.toString((SysexMessage)midiMessage);
        }
        if (midiMessage instanceof MetaMessage) {
            return MessageInfo.toString((MetaMessage)midiMessage);
        }
        return "unknown midi message " + midiMessage;
    }

    public static String toString(ShortMessage shortMessage) {
        String string = null;
        switch (shortMessage.getCommand()) {
            case 128: {
                string = "note off " + MessageInfo.getKeyName(shortMessage.getData1()) + ", velocity: " + shortMessage.getData2();
                break;
            }
            case 144: {
                string = "note " + MessageInfo.getKeyName(shortMessage.getData1()) + " on velocity: " + shortMessage.getData2();
                break;
            }
            case 160: {
                string = "polyphonic key pressure " + MessageInfo.getKeyName(shortMessage.getData1()) + " pressure: " + shortMessage.getData2();
                break;
            }
            case 176: {
                string = "control change " + shortMessage.getData1() + " value: " + shortMessage.getData2();
                break;
            }
            case 192: {
                string = "program change " + shortMessage.getData1();
                break;
            }
            case 208: {
                string = "key pressure " + MessageInfo.getKeyName(shortMessage.getData1()) + " pressure: " + shortMessage.getData2();
                break;
            }
            case 224: {
                string = "pitch bend " + MessageInfo.get14bitValue(shortMessage.getData1(), shortMessage.getData2());
                break;
            }
            case 240: {
                switch (shortMessage.getChannel()) {
                    case 0: {
                        string = "System Exclusive (should not be in ShortMessage)";
                        break;
                    }
                    case 1: {
                        string = "Undefined";
                        break;
                    }
                    case 2: {
                        string = "Song Position: " + MessageInfo.get14bitValue(shortMessage.getData1(), shortMessage.getData2());
                        break;
                    }
                    case 3: {
                        string = "Song Select: " + shortMessage.getData1();
                        break;
                    }
                    case 4: {
                        string = "Undefined";
                        break;
                    }
                    case 5: {
                        string = "Undefined";
                        break;
                    }
                    case 6: {
                        string = "Tune Request";
                        break;
                    }
                    case 7: {
                        string = "end of SysEx (should not be in ShortMessage)";
                        break;
                    }
                    case 8: {
                        string = "Timing clock";
                        break;
                    }
                    case 9: {
                        string = "Undefined";
                        break;
                    }
                    case 10: {
                        string = "Start";
                        break;
                    }
                    case 11: {
                        string = "Continue";
                        break;
                    }
                    case 12: {
                        string = "Stop";
                        break;
                    }
                    case 13: {
                        string = "Undefined";
                        break;
                    }
                    case 14: {
                        string = "Active Sensing";
                        break;
                    }
                    case 15: {
                        string = "System Reset";
                    }
                }
                break;
            }
            default: {
                string = "unknown message: status = " + shortMessage.getStatus() + ", byte1 = " + shortMessage.getData1() + ", byte2 = " + shortMessage.getData2();
            }
        }
        if (shortMessage.getCommand() != 240) {
            int n = shortMessage.getChannel() + 1;
            String string2 = "channel " + n + ": ";
            string = string2 + string;
        }
        return string;
    }

    public static String toString(SysexMessage sysexMessage) {
        byte[] byArray = sysexMessage.getData();
        String string = null;
        if (sysexMessage.getStatus() == 240) {
            string = "Sysex message: F0" + MessageInfo.getHexString(byArray);
        } else if (sysexMessage.getStatus() == 247) {
            string = "Special Sysex message (F7):" + MessageInfo.getHexString(byArray);
        }
        return string;
    }

    public static String toString(MetaMessage metaMessage) {
        byte[] byArray = metaMessage.getData();
        int n = metaMessage.getLength();
        String string = null;
        switch (metaMessage.getType()) {
            case 0: {
                int n2 = byArray[0] * 256 + byArray[1];
                string = "Sequence Number: " + n2;
                break;
            }
            case 1: {
                String string2 = new String(byArray, 0, n);
                string = "Text Event: " + string2;
                break;
            }
            case 2: {
                String string3 = new String(byArray, 0, n);
                string = "Copyright Notice: " + string3;
                break;
            }
            case 3: {
                String string4 = new String(byArray, 0, n);
                string = "Sequence/Track Name: " + string4;
                break;
            }
            case 4: {
                String string5 = new String(byArray, 0, n);
                string = "Instrument Name: " + string5;
                break;
            }
            case 5: {
                String string6 = new String(byArray, 0, n);
                string = "Lyric: " + string6;
                break;
            }
            case 6: {
                String string7 = new String(byArray, 0, n);
                string = "Marker: " + string7;
                break;
            }
            case 7: {
                String string8 = new String(byArray, 0, n);
                string = "Cue Point: " + string8;
                break;
            }
            case 32: {
                byte by = byArray[0];
                string = "MIDI Channel Prefix: " + by;
                break;
            }
            case 47: {
                string = "end of track";
                break;
            }
            case 81: {
                int n3 = MessageInfo.signedByteToUnsigned(byArray[0]) * 65536 + MessageInfo.signedByteToUnsigned(byArray[1]) * 256 + MessageInfo.signedByteToUnsigned(byArray[2]);
                string = "Set Tempo (us/quarter note): " + n3;
                break;
            }
            case 84: {
                string = "SMTPE Offset: " + byArray[0] + ":" + byArray[1] + ":" + byArray[2] + "." + byArray[3] + "." + byArray[4];
                break;
            }
            case 88: {
                string = "Time Signature: " + byArray[0] + "/" + (1 << byArray[1]) + ", MIDI clocks per metronome tick: " + byArray[2] + ", 1/32 per 24 MIDI clocks: " + byArray[3];
                break;
            }
            case 89: {
                String string9 = byArray[1] == 1 ? "minor" : "major";
                string = "Key Signature: " + keySignatures[byArray[0] + 7] + " " + string9;
                break;
            }
            case 127: {
                String string10 = "";
                string = "Sequencer-Specific Meta event: " + string10;
                break;
            }
            default: {
                String string11 = "";
                string = "unknown Meta event: " + string11;
            }
        }
        return string;
    }

    public static String getKeyName(int n) {
        if (n > 127) {
            return "illegal value";
        }
        int n2 = n % 12;
        int n3 = n / 12;
        return keyNames[n2] + (n3 - 1);
    }

    public static int get14bitValue(int n, int n2) {
        return n & 0x7F | (n2 & 0x7F) << 7;
    }

    public static int signedByteToUnsigned(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    public static String getHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3 + 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(' ');
            byte by = (byte)((byArray[i] & 0xF0) >> 4);
            stringBuffer.append((char)(by > 9 ? by + 65 - 10 : by + 48));
            byte by2 = (byte)(byArray[i] & 0xF);
            stringBuffer.append((char)(by2 > 9 ? by2 + 65 - 10 : by2 + 48));
        }
        return new String(stringBuffer);
    }
}

