/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class CSV2MIDI {
    public static void main(String[] stringArray) throws InvalidMidiDataException {
        int n;
        int n2;
        if (stringArray.length != 2) {
            CSV2MIDI.printUsageAndExit();
        }
        File file = new File(stringArray[1]);
        Sequence sequence = null;
        CSV cSV = new CSV(stringArray[0]);
        cSV.fillVector();
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < cSV.data.size(); ++n2) {
            try {
                Integer.parseInt(cSV.data.elementAt(n2).toString());
                ++n4;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (n4 <= true || cSV.data.elementAt(n2).toString().compareTo("\n") != 0) continue;
                n3 = n4 - 1;
                break;
            }
        }
        int n5 = 1;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < cSV.data.size(); ++n2) {
            try {
                n5 = Integer.parseInt(cSV.data.elementAt(n2).toString());
                System.out.println("\nTiming Resolution set to " + n5 + " PPQ\n");
                ++n2;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
        }
        n4 = 0;
        while (n2 < cSV.data.size()) {
            try {
                nArray[n4] = Integer.parseInt(cSV.data.elementAt(n2).toString());
                System.out.println("Instrument set to " + nArray[n4] + " on channel " + n4);
                if (++n4 >= n3) {
                    ++n2;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        try {
            sequence = new Sequence(0.0f, n5);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            System.exit(1);
        }
        Track[] trackArray = new Track[n3];
        for (n = 0; n < n3; ++n) {
            trackArray[n] = sequence.createTrack();
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(192, n, nArray[n], 0);
            trackArray[n].add(new MidiEvent(shortMessage, 0L));
        }
        n = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 90;
        int n9 = 0;
        while (n2 < cSV.data.size()) {
            try {
                n7 = Integer.parseInt(cSV.data.elementAt(n2).toString());
                n6 = Integer.parseInt(cSV.data.elementAt(n2 += 2).toString());
                n8 = Integer.parseInt(cSV.data.elementAt(n2 += 2).toString());
                ++n2;
                n = n9 / 3;
                n9 += 2;
                trackArray[n].add(CSV2MIDI.createNoteOnEvent(n6, n7, n, n8));
            }
            catch (NumberFormatException numberFormatException) {
                if (cSV.data.elementAt(n2).toString().compareTo("\n") == 0) {
                    n9 = 0;
                } else if (cSV.data.elementAt(n2).toString().compareTo(",") == 0) {
                    ++n9;
                }
                ++n2;
            }
        }
        System.out.println();
        if (trackArray != null) {
            for (int i = 0; i < trackArray.length; ++i) {
                System.out.println("Track " + i + ":");
                for (int j = 0; j < trackArray[i].size(); ++j) {
                    MidiEvent midiEvent = trackArray[i].get(j);
                    System.out.println(" tick " + midiEvent.getTick() + ", " + MessageInfo.toString(midiEvent.getMessage()));
                }
            }
        }
        try {
            MidiSystem.write(sequence, 1, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private static MidiEvent createNoteOnEvent(int n, long l, int n2, int n3) {
        return CSV2MIDI.createNoteEvent(144, n, n3, l, n2);
    }

    private static MidiEvent createNoteOffEvent(int n, long l, int n2) {
        return CSV2MIDI.createNoteEvent(128, n, 0, l, n2);
    }

    private static MidiEvent createNoteEvent(int n, int n2, int n3, long l, int n4) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, n4, n2, n3);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            System.exit(1);
        }
        MidiEvent midiEvent = new MidiEvent(shortMessage, l);
        return midiEvent;
    }

    private static void printUsageAndExit() {
        CSV2MIDI.out("usage:");
        CSV2MIDI.out("java CSV2MIDI <infile.csv> <outfile.midi>");
        System.exit(1);
    }

    private static void out(String string) {
        System.out.println(string);
    }
}

