#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

void get_binary(long decimal, char* buffer);
double** startIterative();
void iterativePass(int iterLength, double** grid);


int main(int argc, char* argv[]){
	double** grid = startIterative();
	int i, j;

	FILE *test_hmap;
	test_hmap = fopen("test_hmap.mif", "wb+");

	if(test_hmap != NULL){
		fputs("WIDTH=36;\n", test_hmap);
		fputs("DEPTH=1024;\n", test_hmap);
		fputs("\nADDRESS_RADIX=UNS;\n", test_hmap);
		fputs("DATA_RADIX=BIN;\n", test_hmap);
		fputs("\nCONTENT BEGIN\n", test_hmap);
		
		int truncated_height;
		char bin_z[37];
		char bin_x[37];
		char bin_y[37];
		long dist_interval = 6;
		int count = 0;
		for(j = 0; j < 32; j++){
			for(i = 0; i < 32; i++){
				truncated_height = (int)(grid[i][j] * 262144);
				printf("test\n");
				get_binary(262144 * (i - 16) * dist_interval, bin_x);
				get_binary(262144 * (j - 16) * dist_interval, bin_y);
				//get_binary(262144, bin_z);
				get_binary(truncated_height, bin_z);
				//fprintf(test_hmap, "%d : %s%s%s;\n", count, bin_x, bin_y, bin_z);
				fprintf(test_hmap, "%d : %s;\n", count, bin_z);
				printf("%d, %d, %s\n", i, j, bin_z);
				count++;
			}
		}
		fputs("END;", test_hmap);
	}
}

void get_binary(long decimal, char* buffer){
	int i;
	buffer[36] = '\0';
	if(decimal < 0){
		buffer[0] = '1';
		long current_value = -powl(2, 35);
		for(i = 1; i < 36; i++){
			if(current_value + powl(2, 35 - i) <= decimal){
				current_value += powl(2, 35 - i);
				buffer[i] = '1';
			}
			else{
				buffer[i] = '0';
			}
		}
	}
	else{
		buffer[0] = '0';
		for(i = 1; i < 36; i++){
			if(decimal - powl(2, 35 - i) >= 0){
				decimal -= powl(2, 35 - i);
				buffer[i] = '1';
			}
			else{
				buffer[i] = '0';
			}
		}
	}
}

double** startIterative(){
	srand(time(NULL));
	//int grid[33][33];
	
	double** grid = (double**)malloc(34 * sizeof(int*));
	int i;
	for(i = 0; i < 34; i++){
		grid[i] = (double*)malloc(34*sizeof(int));
	}

	int gridEnd = 33;
	int max = 6;
	grid[0][0] = rand() % max;
	grid[0][gridEnd] = rand() % max;
	grid[gridEnd][0] = rand() % max;
	grid[gridEnd][gridEnd] = rand() % max;

	int loops = 5;
	int iterLength = gridEnd;
	for(i = 0; i < loops && iterLength > 0; i++){
		iterativePass(iterLength, grid);
		iterLength /= 2;
	}
	iterLength *= 2;
	return grid;
}

void iterativePass(int iterLength, double** grid){
	int i, j;
	int max = 33;
	for(i = 0; i < 34 - iterLength; i+=iterLength){
		for( j = 0; j < 34 - iterLength; j+=iterLength){
			int centerX = iterLength/2 + i;
			int centerY = iterLength/2 + j;
			grid[centerX][centerY] = (grid[i][j] + grid[i+iterLength][j] + grid[i][j+iterLength] + grid[i+iterLength][j + iterLength])/4 + rand() % (max/2);
		}
	}
	for(i = 0; i < 34 - iterLength; i+=iterLength){
		for(j = 0; j < 34 - iterLength; j+=iterLength){
			grid[i + iterLength/2][j] = (grid[i][j] + grid[i + iterLength][j])/2 + rand() % (max/2);
			grid[i + iterLength][j + iterLength/2] = (grid[i + iterLength][j] + grid[i + iterLength][j + iterLength])/2 + rand() % (max/2);
			grid[i + iterLength/2][j + iterLength] = (grid[i][j + iterLength] + grid[i + iterLength][j + iterLength])/2 + rand() % (max/2);
			grid[i][j + iterLength/2] = (grid[i][j] + grid[i][j + iterLength])/2 + rand() % (max/2);
		}
	}
}
