#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

void get_binary(long decimal, char* buffer);

int main(int argc, char* argv[]){
	FILE *sin_file, *cos_file;

	sin_file = fopen("sin_lookup.mif", "wb+");
	cos_file = fopen("cos_lookup.mif", "wb+");
	
	if(sin_file != NULL){
		fputs("WIDTH=36;\n", sin_file);
		fputs("DEPTH=360;\n", sin_file);
		fputs("\nADDRESS_RADIX=UNS;\n", sin_file);
		fputs("DATA_RADIX=BIN;\n", sin_file);
		fputs("\nCONTENT BEGIN\n", sin_file);	
		int i;
		double current_angle;
		double current_sin;
		long truncated_sin;
		char current_binary[37];
		for(i = 0; i < 360; i++){
			current_angle = i * M_PI/180;
			current_sin = sin(current_angle / 4) * 262144;
			truncated_sin = (long)current_sin;
			get_binary(truncated_sin, current_binary);
			fprintf(sin_file, "%d : %s;\n", i, current_binary[16]);
			printf("%d %f %s\n", truncated_sin, sin(current_angle), current_binary);
			
		}
		fputs("END;", sin_file);
	}

	if(cos_file != NULL){
		fputs("WIDTH=36;\n", cos_file);
		fputs("DEPTH=360;\n", cos_file);
		fputs("\nADDRESS_RADIX=UNS;\n", cos_file);
		fputs("DATA_RADIX=BIN;\n", cos_file);
		fputs("\nCONTENT BEGIN\n", cos_file);
		int i;
		double current_angle, current_cos;
		long truncated_cos;
		char current_binary[37];
		for(i = 0; i < 360; i++){
			current_angle = i * M_PI/180;
			current_cos = cos(current_angle / 4) * 262144;
			truncated_cos = (int)current_cos;
			get_binary(truncated_cos, current_binary);
			fprintf(cos_file, "%d : %s;\n", i, current_binary[16]);
			printf("%d %f %s\n", truncated_cos, cos(current_angle), current_binary);
		}
		fputs("END;", cos_file);
	}
}

void get_binary(long decimal, char* buffer){
	int i;
	buffer[36] = '\0';
	if(decimal < 0){
		buffer[0] = '1';
		long current_value = -powl(2, 35);
		for(i = 1; i < 36; i++){
			if(current_value + powl(2, 35 - i) <= decimal){
				current_value += powl(2, 35 - i);
				buffer[i] = '1';
			}
			else{
				buffer[i] = '0';
			}
		}
	}
	else{
		buffer[0] = '0';
		for(i = 1; i < 36; i++){
			if(decimal - powl(2, 35 - i) >= 0){
				decimal -= powl(2, 35 - i);
				buffer[i] = '1';
			}
			else{
				buffer[i] = '0';
			}
		}
	}
}
