#include <io.h>
#include <system.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#define IOWR_VGA_DATA(base, offset, data) \
        IOWR_32DIRECT(base, (offset) * 4, data)
#define IORD_VGA_DATA(base, offset) \
        IORD_32DIRECT(base, (offset) * 4)

void iterativePass(int iterLength, double** grid){
	printf("start\n");
	int i, j;
	int max = 8;
	for(i = 0; i < 33 - iterLength; i+=iterLength){
		for( j = 0; j < 33 - iterLength; j+=iterLength){
			int centerX = iterLength/2 + i;
			int centerY = iterLength/2 + j;
			grid[centerX][centerY] = (grid[i][j] + grid[i+iterLength][j] + grid[i][j+iterLength] + grid[i+iterLength][j + iterLength])/4 + rand() % (max);
		}
	}
	printf("part1 done\n");
	for(i = 0; i < 33 - iterLength; i+=iterLength){
		for(j = 0; j < 33 - iterLength; j+=iterLength){
			grid[i + iterLength/2][j] = (grid[i][j] + grid[i + iterLength][j])/2 + rand() % (max);
			grid[i + iterLength][j + iterLength/2] = (grid[i + iterLength][j] + grid[i + iterLength][j + iterLength])/2 + rand() % (max);
			grid[i + iterLength/2][j + iterLength] = (grid[i][j + iterLength] + grid[i + iterLength][j + iterLength])/2 + rand() % (max);
			grid[i][j + iterLength/2] = (grid[i][j] + grid[i][j + iterLength])/2 + rand() % (max);
		}
	}
	printf("part2 done\n");
}

void startIterative(double **grid){
	//int grid[33][33];
	int i;
	int gridEnd = 32;
	int max = 128;
	grid[0][0] = rand() % max;
	grid[0][gridEnd] = rand() % max;
	grid[gridEnd][0] = rand() % max;
	grid[gridEnd][gridEnd] = rand() % max;

	int loops = 5;
	int iterLength = gridEnd;
	for(i = 0; i < loops && iterLength > 0; i++){
		iterativePass(iterLength, grid);
		iterLength /= 2;
		printf("pass: %d\n", i);
	}
	iterLength *= 2;
}

int main(){
	srand(time(NULL));
	double** grid = (double**)malloc(33 * sizeof(int*));
	int i,j;
	for(i = 0; i < 33; i++){
		grid[i] = (double*)malloc(33*sizeof(int));
	}
	while(1){
		if(IORD_VGA_DATA(0x101000, 3) == 1){
			startIterative(grid);
			for(i = 0; i < 32; i++){
				for(j = 0; j < 32; j++){
					IOWR_VGA_DATA(DE2_CPU_TO_VGA_0_BASE, 0, i);
					IOWR_VGA_DATA(DE2_CPU_TO_VGA_0_BASE, 1, j);
					IOWR_VGA_DATA(DE2_CPU_TO_VGA_0_BASE, 2, (int)grid[i][j] * 262144);
					//printf("%f\n", grid[i][j]);
				}
			}
			IOWR_VGA_DATA(DE2_CPU_TO_VGA_0_BASE, 4, 1);
			IOWR_VGA_DATA(DE2_CPU_TO_VGA_0_BASE, 4, 0);
			printf("%d\n", rand() % 32);
		}
		//IOWR_VGA_DATA(0x101000, 4, 1);
	}
	free(grid);

	return 0;
}
