library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity raster_tb is
end raster_tb;

architecture tb of raster_tb is
		signal x_signed, y_signed : signed(35 downto 0);
		signal x_index, y_index : integer := 0;
		signal offset : integer := -16;
	
	begin
		--clk <= not clk after 10 ns;
		process
		begin
			wait for 100 ns;
			x_index <= 0;
			y_index <= 0;
			wait for 20 ns;
			x_index <= 4;
			y_index <= 1;
			wait for 20 ns;
			x_index <= 16;
			y_index <= 16;
			wait for 20 ns;
			x_index <= 20;
			y_index <= 20;
			wait for 20 ns;
			x_index <= 15;
			y_index <= 15;
			wait for 20 ns;
			x_index <= 30;
			y_index <= 30;

			wait;
		end process;
		
		x_signed <= to_signed((x_index + offset) * 6, 18) & "000000000000000000";
		y_signed <= to_signed((y_index + offset) * 6, 18) & "000000000000000000";
end tb;