library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity lines_tb is
end lines_tb;

architecture tb of lines_tb is
	signal clk : std_logic := '0';
	signal rst : std_logic;
	signal x0, y0, x1, y1 : signed(17 downto 0);
	signal x_p, y_p : signed(17 downto 0);
	signal start : std_logic;
	signal step : std_logic;
	signal done, plot : std_logic;

	begin	
	clk <= not clk after 10 ns;
	
	process
	begin
		wait for 20 ns;
		start <= '1';
		rst <= '1';
		x0 <= to_signed(0, 18);
		y0 <= to_signed(0, 18);
		x1 <= to_signed(40, 18);
		y1 <= to_signed(20, 18);
		step <= '1';
		wait for 20 ns;
		rst <= '0';
		wait;
	end process;
	
	test_lines : entity work.lines
		port map (
			clk => clk,
			rst => rst,
			x0 => x0,
			y0 => y0,
			x1 => x1,
			y1 => y1,
			x_p => x_p,
			y_p => y_p,
			done => done,
			plot => plot,
			start => start
			--step => step
		);
end tb;