library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_cpu_to_vga is

  port (
    clk        : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  std_logic_vector(5 downto 0);
    readdata   : out std_logic_vector(31 downto 0);
    writedata  : in  std_logic_vector(31 downto 0);

	 gen_start : in std_logic;
	 gen_done : out std_logic := '0';
	 hmap_address : out std_logic_vector(9 downto 0);
	 data : out std_logic_vector(35 downto 0);
	 wren : out std_logic
  );

end de2_cpu_to_vga;

architecture rtl of de2_cpu_to_vga is
  type ram_type is array(31 downto 0) of
            std_logic_vector(31 downto 0);
  signal RAM : ram_type;
  signal ram_address, display_address : unsigned(4 downto 0);
  signal xpos : integer := 0;
  signal ypos : integer := 0;
  
  
begin
  ram_address <= unsigned(address(4 downto 0));

  process(clk)
  begin
    if rising_edge(clk) then
      if chipselect = '1' then
			if read = '1' then
					readdata <= RAM(to_integer(ram_address));
			elsif write = '1' then
				RAM(to_integer(ram_address)) <= writedata;
		  end if;
      end if;
		RAM(3) <= "0000000000000000000000000000000" & gen_start;
	 end if;
  end process;
  
	xpos <= to_integer(signed(RAM(0)));
	ypos <= to_integer(signed(RAM(1)));
	hmap_address <= std_logic_vector(to_unsigned(ypos * 32 + xpos, 10));
	data <= "0000" & RAM(2);
	wren <= '1' when write = '1' and to_integer(ram_address) = 2 else '0';
	gen_done <= RAM(4)(0);
end rtl;

