library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity HeightMapGenerator is
	port(
		signal clk : in std_logic;
		start : in std_logic;
		done : out std_logic;
		wraddress : out std_logic_vector(9 downto 0);
		rdaddress : out std_logic_vector(9 downto 0);
		data : out std_logic_vector(35 downto 0);
		wren : out std_logic;
		q : in std_logic_vector(35 downto 0)
	);
end HeightMapGenerator;

architecture rtl of HeightMapGenerator is
	type states is (IDLE_STATE, TEST_STATE, TEST2_STATE, SEED1_STATE, SEED2_STATE, SEED3_STATE, SEED4_STATE, DIAMOND_STATE, DIAMONDDRAW_STATE, SQUAREMAIN_STATE, SQUARE1_STATE, SQUARE2_STATE, SQUARE3_STATE, SQUARE4_STATE, SQUARE5_STATE, GETDIAMOND1_STATE, GETDIAMOND2_STATE, GETDIAMOND3_STATE, GETDIAMOND4_STATE, GETSQUARE1_STATE, GETSQUARE2_STATE, GETSQUARE3_STATE, GETSQUARE4_STATE);
	signal state, square_state : states := IDLE_STATE;
	signal signed_index : signed(17 downto 0);
	signal random_output : std_logic_vector(35 downto 0);
	signal fixed_spacer : signed(17 downto 0) := to_signed(0, 18);
	signal fixed_index, fixed_random : signed(35 downto 0);
	signal index : integer := 0;
	signal random_reset : std_logic := '0';
	signal x, y, z : signed(35 downto 0);
	signal x_index, y_index, x_pos, y_pos, x_read, y_read : integer;
	signal z1, z2, z3, z4, z_average : signed(35 downto 0);
	signal current_interval, half_interval : integer := 16;
	
	signal test_counter : integer := 0;
	signal x_base, y_base, x_count, y_count, counter, counter_max, square_counter, total_count : integer;
	
begin
	process(clk)
	begin
		if rising_edge(clk) then
			case state is
			when IDLE_STATE =>
				done <= '0';
				wren <= '0';
				if start = '1' then
					random_reset <= '0';
					state <= SEED1_STATE;
				else
					random_reset <= '1';
					state <= IDLE_STATE;
				end if;
				x_pos <= -96;
				y_pos <= -96;
				x_index <= 0;
				y_index <= 0;
				x_read <= 0;
				y_read <= 0;
				index <= 0;
				total_count <= 0;
			when TEST_STATE =>
				wren <= '1';
				if test_counter < 1023 then
					if test_counter mod 32  = 31 then
						x_pos <= -96;
						y_pos <= y_pos + 6;
						x_index <= 0;
						y_index <= y_index + 1;
					else
						x_pos <= x_pos + 6;
						x_index <= x_index + 1;
					end if;
					test_counter <= test_counter + 1;
					state <= TEST_STATE;
					z <= "000000000000000001000000000000000000";
					--z <= signed(random_output);
				else
					state <= SEED1_STATE;
					x_pos <= -96;
					y_pos <= -96;
					x_index <= 0;
					y_index <= 0;
				end if;
			when SEED1_STATE =>
				wren <= '1';
				x_pos <= 90;
				y_pos <= -96;
				x_index <= 31;
				y_index <= 0;
				z <= signed(random_output);
				state <= SEED2_STATE;
			when SEED2_STATE =>
				wren <= '1';
				x_pos <= -96;
				y_pos <= 90;
				x_index <= 0;
				y_index <= 31;
				z <= signed(random_output);
				state <= SEED3_STATE;
			when SEED3_STATE =>
				wren <= '1';
				x_pos <= 90;
				y_pos <= 90;
				x_index <= 31;
				y_index <= 31;
				z <= signed(random_output);
				state <= SEED4_STATE;
			when SEED4_STATE =>
				wren <= '1';	
				counter_max <= 1;
				x_count <= 0;
				y_count <= 0;
				current_interval <= 32;
				half_interval <= 16;
				z <= signed(random_output);
				state <= GETDIAMOND1_STATE;
				x_read <= 0;
				y_read <= 0;
				x_index <= 16;
				y_index <= 16;
				x_base <= 16;
				y_base <= 16;
			when TEST2_STATE =>
			when GETDIAMOND1_STATE =>
				wren <= '0';
				if x_count = counter_max - 1 then
					x_read <= x_index + half_interval - 1;
				else
					x_read <= x_index + half_interval;
				end if;
				y_read <= y_index - half_interval;
				z1 <= signed(q(35 downto 0));
				state <= GETDIAMOND2_STATE;
			when GETDIAMOND2_STATE =>
				if x_count = counter_max - 1 then
					x_read <= x_index + half_interval - 1;
				else
					x_read <= x_index + half_interval;
				end if;
				if y_count = counter_max - 1 then
					y_read <= y_index + half_interval - 1;
				else
					y_read <= y_index + half_interval;
				end if;
				z2 <= signed(q(35 downto 0));
				state <= GETDIAMOND3_STATE;
			when GETDIAMOND3_STATE =>
				x_read <= x_index - half_interval;
				if y_count = counter_max - 1 then
					y_read <= y_index + half_interval - 1;
				else
					y_read <= y_index + half_interval;
				end if;
				z3 <= signed(q(35 downto 0));
				state <= GETDIAMOND4_STATE;
			when GETDIAMOND4_STATE =>
				z4 <= signed(q(35 downto 0));
				state <= DIAMOND_STATE;
				wren <= '1';
			when DIAMOND_STATE =>
				z <= z_average + signed(random_output);
				
				if total_count < 6 then
					if y_count < counter_max -1  or (y_count < counter_max and total_count = 5) then
						if x_count < counter_max - 1 then
							wren <= '1';
							x_count <= x_count + 1;
							state <= DIAMONDDRAW_STATE;
						else
							wren <= '0';
							y_count <= y_count + 1;
							x_count <= 0;
							x_index <= x_base;
							if y_count = counter_max - 1 then
								y_index <= y_index + current_interval - 1;
							else
								y_index <= y_index + current_interval;
							end if;
							state <= DIAMOND_STATE;
						end if;
					else
						wren <= '0';
						x_index <= x_base;
						y_index <= y_base;
						x_count <= 0;
						y_count <= 0;
						state <= SQUAREMAIN_STATE;
					end if;
				else
					wren <= '0';
					state <= IDLE_STATE;
					done <= '1';
					x_index <= 16;
					y_index <= 16;
					x_base <= 16;
					y_base <= 16;
					counter_max <= 1;
					x_count <= 0;
					y_count <= 0;
					current_interval <= 32;
					half_interval <= 16;
					total_count <= 0;
					
				end if;
			when DIAMONDDRAW_STATE =>
				wren <= '1';
				state <= GETDIAMOND1_STATE;
				x_read <= x_index - half_interval;
				y_read <= y_index - half_interval;
				if x_count = counter_max - 1 then
					x_index <= x_index + current_interval - 1;
				else
					x_index <= x_index + current_interval;
				end if;
			when GETSQUARE1_STATE =>
				wren <= '0';
				if x_count = counter_max - 1 then
					x_read <= x_index + half_interval - 1;
				else
					x_read <= x_index + half_interval;
				end if;
				y_read <= y_index;
				
				z1 <= signed(q(35 downto 0));
				state <= GETSQUARE2_STATE;
			when GETSQUARE2_STATE =>
				if y_count = counter_max - 1 then
					y_read <= y_index + half_interval - 1;
				else
					y_read <= y_index + half_interval;
				end if;
				x_read <= x_index;
				z2 <= signed(q(35 downto 0));
				state <= GETSQUARE3_STATE;
			when GETSQUARE3_STATE =>
				x_read <= x_index - half_interval;
				y_read <= y_index;
				z3 <= signed(q(35 downto 0));
				state <= GETSQUARE4_STATE;
			when GETSQUARE4_STATE =>
				z3 <= signed(q(35 downto 0));
				state <= square_state;
			when SQUAREMAIN_STATE =>
				if y_count < counter_max - 1  or (y_count < counter_max and total_count = 5) then
					if x_count < counter_max - 1 then
						if x_count = counter_max - 1  and total_count >= 5 then
							x_index <= x_index + current_interval;
						elsif x_count = counter_max - 1 then
							x_index <= x_index + current_interval - 1;
						else
							x_index <= x_index + current_interval;
						end if;
						x_count <= x_count + 1;
						x_read <= x_index;
						y_read <= y_index - half_interval;
						state <= GETSQUARE1_STATE;
						square_state <= SQUARE1_STATE;
						wren <= '1';
					else
						wren <= '0';
						y_count <= y_count + 1;
						x_count <= 0;
						x_index <= x_base;
						if y_count = counter_max - 1 then
							y_index <= y_index + current_interval - 1;
						else
							y_index <= y_index + current_interval;
						end if;
						state <= SQUAREMAIN_STATE;
					end if;
				else
					wren <= '0';
					total_count <= total_count + 1;
					current_interval <= current_interval / 2;
					half_interval <= half_interval / 2;
					counter_max <= counter_max * 2;
					x_index <= x_base / 2;
					y_index <= y_base / 2;
					x_base <= x_base / 2;
					y_base <= y_base / 2;
					x_count <= 0;
					y_count <= 0;
					state <= DIAMOND_STATE;
				end if;
			when SQUARE1_STATE =>
				z <= z4/2 + z2/2 + signed(random_output);
				y_index <= y_index - 1;
				state <= GETSQUARE1_STATE;
				square_state <= SQUARE2_STATE;
			when SQUARE2_STATE =>
				z <= z4/2 + z2/2 + signed(random_output);
				y_index <= y_index + 2;
				state <= GETSQUARE1_STATE;
				square_state <= SQUARE3_STATE;
			when SQUARE3_STATE =>
				z <= z1/2 + z3/2 + signed(random_output);
				x_index <= x_index - 1;
				y_index <= y_index - 1;
				state <= GETSQUARE1_STATE;
				square_state <= SQUARE4_STATE;
			when SQUARE4_STATE =>
				z <= z1/2 + z3/2 + signed(random_output);
				x_index <= x_index + 2;
				state <= GETSQUARE1_STATE;
				square_state <= SQUARE5_STATE;
			when SQUARE5_STATE =>
				wren <= '0';
				x_index <= x_index - 1;
				state <= SQUAREMAIN_STATE;
			end case;
		end if;
	end process;
	
	x <= to_signed((x_index - 16) * 6 , 18) & "000000000000000000";
	y <= to_signed((y_index - 16) * 6, 18) & "000000000000000000";
	data <= std_logic_vector(z);
	wraddress <= std_logic_vector(to_unsigned(x_index + 32 * y_index, 10));
	
	rdaddress <= std_logic_vector(to_unsigned(x_read + 32 * y_read, 10));
	z_average <= z1/4 + z2/4 + z3/4;
	
--	z <= signed(random_output);
	
--	z <= signed(random_output) when state <= SEED1_STATE
--		else signed(random_output) when state <= SEED2_STATE
--		else signed(random_output) when state <= SEED3_STATE
--		else signed(random_output) when state <= SEED4_STATE
--		else "000000000000000001000000000000000000" when state <= TEST_STATE
--		else "000000000000000001000000000000000000" when state <= IDLE_STATE
--		else (signed(z1) + signed(z2) + signed(z3) + signed(z4))/4 + signed(random_output);
--	
	LFSR: entity work.LFSR port map(
		reset => random_reset,
		seed => "000000000000100111011100011000011000",
		output => random_output
	);
	
end rtl;