library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity DrawFacesModule is
	port(
		clk : in std_logic;
		start : in std_logic;
		done : out std_logic;
		
		data		: out STD_LOGIC_VECTOR (35 DOWNTO 0);
		rdaddress		: out STD_LOGIC_VECTOR (9 DOWNTO 0);
		wren		: out STD_LOGIC  := '0';
		q		: in STD_LOGIC_VECTOR (35 DOWNTO 0);
		
		frame_address		: out STD_LOGIC_VECTOR (16 DOWNTO 0);
		frame_data		: out STD_LOGIC_VECTOR (1 DOWNTO 0);
		frame_wren		: out STD_LOGIC;
		
		backface_on : in std_logic;
		z_section : in std_logic_vector(5 downto 0);
		
		rotcontrol_z : in std_logic_vector(1 downto 0)
		
	);
end DrawFacesModule;


architecture rtl of DrawFacesModule is 
	signal done_internal : std_logic := '0';
	type states is (IDLE_STATE, GETFACE_STATE, GETFACE2_STATE, GETFACE3_STATE, GETFACE4_STATE, WAIT1_STATE, WAIT2_STATE, WAIT3_STATE, WAIT4_STATE, WAIT5_STATE, WAIT6_STATE, BACKFACE_STATE, DRAW_STATE, DRAW2_STATE, DRAW3_STATE, DRAW4_STATE);
	signal state : states := IDLE_STATE;
	signal count, index, x_index, y_index, x_draw, y_draw, x_offset, y_offset, row_count, vertex_count : integer := 0;
	signal vertex, vertex1, vertex2, vertex3, vertex4 : STD_LOGIC_VECTOR (35 DOWNTO 0);
	signal rotated_x, rotated_y, rotated_z, rotated_x1, rotated_y1, rotated_x2, rotated_y2, rotated_x3, rotated_y3, rotated_x4, rotated_y4 : signed(10 downto 0);
	signal x_signed, y_signed : signed(35 downto 0);
   signal x0, y0, x1, y1 : signed(10 downto 0);
	signal line_start, line_done, line_reset, line_plot : std_logic := '0';
	signal x_p, y_p : signed(10 downto 0);
	signal scanline_data : std_logic_vector(1 downto 0);
	
	signal cos_value, sin_value : signed(19 downto 0);
	signal cos_x : signed(19 downto 0) := "00100000000000000000";
	signal sin_x : signed(19 downto 0) := "00110111011011001111";
	
	signal angle : integer := 0;
	
	signal sin_address, cos_address : STD_LOGIC_VECTOR (7 DOWNTO 0);
	signal sin_q, cos_q	: STD_LOGIC_VECTOR (19 DOWNTO 0);
	
	signal ux, uy, uz, vx, vy, vz : signed(10 downto 0);
	signal normal_z : signed(21 downto 0);
	signal face_angle : signed(32 downto 0);
	
	begin
		 lines_inst : entity work.lines
		  port map (
			 clk => clk,
			 x0 => x0,
			 y0 => y0,
			 x1 => x1,
			 y1 => y1,
			 x_p => x_p,
			 y_p => y_p,
			 start => line_start,
			 done => line_done,
			 rst => line_reset,
			 plot => line_plot
			 
		  );

		
		process(clk)
		begin
			if rising_edge(clk) then
				case state is
				when IDLE_STATE =>
					done <= '0';
					wren <= '0';
					vertex1 <= q;
					count <= 0;
					
					if angle < 180 then
						sin_address <= std_logic_vector(to_unsigned(angle, 8));
						cos_address <= std_logic_vector(to_unsigned(angle, 8));
						cos_value <= signed(cos_q);
						sin_value <= signed(sin_q);
					else
						sin_address <= std_logic_vector(to_unsigned((angle - 180), 8));
						cos_address <= std_logic_vector(to_unsigned((angle - 180), 8));
						cos_value <= not signed(cos_q);
						sin_value <= not signed(sin_q);
					end if;
					if angle >= 0 and angle < 90 then
						index <= 0;
						x_index <= 0;
						y_index <= 0;
						x_draw <= -96;
						y_draw <= -96;
					elsif angle >= 90 and angle < 180 then
						index <= 960;
						x_index <= 0;
						y_index <= 30;
						x_draw <= -96;
						y_draw <= 84;
					elsif angle >= 180 and angle < 270 then
						index <= 990;
						x_index <= 30;
						y_index <= 30;
						x_draw <= 84;
						y_draw <= 84;
					elsif angle >= 270 and angle < 360 then
						index <= 30;
						x_index <= 30;
						y_index <= 0;
						x_draw <= 84;
						y_draw <= -96;
					end if;
					if start = '1' then
						state <= GETFACE_STATE;
					else
						state <= IDLE_STATE;
					end if;
				when GETFACE_STATE =>
					if count < 961 then
						vertex1 <= q;
						state <= WAIT1_STATE;
					else
						if rotcontrol_z = "10" then
							if angle < 360 then
								angle <= angle + 1;
							else
								angle <= 0;
							end if;
						elsif rotcontrol_z = "01" then
							if angle > 0 then
								angle <= angle - 1;
							else
								angle <= 360;
							end if;
						else
							angle <= angle;
						end if;
						state <= IDLE_STATE;
						count <= 0;
						done <= '1';
					end if;
				when WAIT1_STATE =>
					state <= GETFACE2_STATE;
					rotated_x1 <= rotated_x;
					rotated_y1 <= rotated_y;
				when GETFACE2_STATE =>
					vertex2 <= q;
					state <= WAIT2_STATE;
				when WAIT2_STATE =>
					state <= GETFACE3_STATE;
					rotated_x2 <= rotated_x;
					rotated_y2 <= rotated_y;
				when GETFACE3_STATE =>
					vertex3 <= q;
					state <= WAIT3_STATE;
				when WAIT3_STATE =>
					state <= GETFACE4_STATE;
					rotated_x3 <= rotated_x;
					rotated_y3 <= rotated_y;
				when GETFACE4_STATE =>
					vertex4 <= q;
					state <= WAIT4_STATE;
				when WAIT4_STATE =>
					rotated_x4 <= rotated_x;
					rotated_y4 <= rotated_y;
					state <= WAIT5_STATE;
				when WAIT5_STATE =>
					if angle >= 0 and angle < 90 then
						if row_count = 30 then
							row_count <= 0;
							index <= index - 959;
							x_index <= x_index + 1;
							y_index <= 0;
							x_draw <= x_draw + 6;
							y_draw <= -96;
						else
							row_count <= row_count + 1;
							index <= index + 32;
							y_index <= y_index + 1;
							y_draw <= y_draw + 6;
						end if;
					elsif angle >= 90 and angle < 180 then
						if row_count = 30 then
							row_count <= 0;
							index <= index - 62;
							x_index <= 0;
							y_index <= y_index - 1;
							x_draw <= -96;
							y_draw <= y_draw - 6;
						else
							row_count <= row_count + 1;
							index <= index + 1;
							x_index <= x_index + 1;
							x_draw <= x_draw + 6;
						end if;
					elsif angle >= 180 and angle < 270 then
						if row_count = 30 then
							row_count <= 0;
							index <= index + 959;
							x_index <= x_index - 1;
							y_index <= 30;
							x_draw <= x_draw - 6;
							y_draw <= 84;
						else
							row_count <= row_count + 1;
							index <= index - 32;
							y_index <= y_index - 1;
							y_draw <= y_draw - 6;
						end if;
					elsif angle >= 270 and angle < 360 then
						if row_count = 30 then
							row_count <= 0;
							index <= index + 62;
							x_index <= 30;
							y_index <= y_index + 1;
							x_draw <= 84;
							y_draw <= y_draw + 6;
						else
							row_count <= row_count + 1;
							index <= index - 1;
							x_index <= x_index - 1;
							x_draw <= x_draw - 6;
						end if;
					end if;
					count <= count + 1;
					state <= WAIT6_STATE;
				when WAIT6_STATE =>
					state <= BACKFACE_STATE;
				when BACKFACE_STATE =>
					if normal_z > to_signed(0, 22) or (normal_z <= to_signed(0, 22) and backface_on = '0') then
						if count < 160 and z_section(5) = '1' then
							frame_data <= "01";
							state <= DRAW_STATE;
						elsif count >= 160 and count < 320 and z_section(4) = '1' then
							frame_data <= "10";
							state <= DRAW_STATE;
						elsif count >= 320 and count < 480 and z_section(3) = '1' then
							frame_data <= "11";
							state <= DRAW_STATE;
						elsif count >= 480 and count < 640 and z_section(2) = '1' then
							frame_data <= "01";
							state <= DRAW_STATE;
						elsif count >= 640 and count < 800 and z_section(1) = '1' then
							frame_data <= "10";
							state <= DRAW_STATE;
						elsif count >= 800 and count < 961 and z_section(0) = '1' then
							frame_data <= "11";
							state <= DRAW_STATE;
						else
							frame_data <= "01";
							state <= GETFACE_STATE;
						end if;
					else
						frame_data <= "01";
						state <= GETFACE_STATE;
					end if;
				when DRAW_STATE =>
					if line_done = '0' then
						x0 <= rotated_x1 + to_signed(160, 11);
						y0 <= rotated_y1 + to_signed(180, 11);
						x1 <= rotated_x2 + to_signed(160, 11);
						y1 <= rotated_y2 + to_signed(180, 11);
						line_reset <= '0';
						line_start <= '1';
					else
						line_start <= '0';
						line_reset <= '1';
						state <= DRAW2_STATE;
					end if;
				when DRAW2_STATE =>
					if line_done = '0' then
						x0 <= rotated_x1 + to_signed(160, 11);
						y0 <= rotated_y1 + to_signed(180, 11);
						x1 <= rotated_x3 + to_signed(160, 11);
						y1 <= rotated_y3 + to_signed(180, 11);
						line_reset <= '0';
						line_start <= '1';
					else
						line_start <= '0';
						line_reset <= '1';
						state <= DRAW3_STATE;
					end if;
				when DRAW3_STATE =>
					if line_done = '0' then
						x0 <= rotated_x2 + to_signed(160, 11);
						y0 <= rotated_y2 + to_signed(180, 11);
						x1 <= rotated_x4 + to_signed(160, 11);
						y1 <= rotated_y4 + to_signed(180, 11);
						line_reset <= '0';
						line_start <= '1';
					else
						line_start <= '0';
						line_reset <= '1';
						state <= DRAW4_STATE;
					end if;
				when DRAW4_STATE =>
					if line_done = '0' then
						x0 <= rotated_x3 + to_signed(160, 11);
                  y0 <= rotated_y3 + to_signed(180, 11);
						x1 <= rotated_x4 + to_signed(160, 11);
						y1 <= rotated_y4 + to_signed(180, 11);
						line_reset <= '0';
						line_start <= '1';
					else
						line_start <= '0';
						line_reset <= '1';
						state <= GETFACE_STATE;
					end if;
				end case;
			end if;
		end process;
		
		frame_address <= std_logic_vector(y_p * 320 + x_p)(16 downto 0);
		frame_wren <= line_plot;
		rdaddress <= std_logic_vector(to_unsigned(index + vertex_count, 10));
		vertex_count <= 1 when state = GETFACE_STATE or state = WAIT1_STATE else
							 32 when state = GETFACE2_STATE or state = WAIT2_STATE else
							 33 when state = GETFACE3_STATE or state = WAIT3_STATE else 0;
		x_offset <= 6 when state = GETFACE2_STATE or state = WAIT2_STATE or state = GETFACE4_STATE or state = WAIT4_STATE else 0;
		y_offset <= 6 when state = GETFACE3_STATE or state = WAIT3_STATE or state = GETFACE4_STATE or state = WAIT4_STATE else 0;
		
		rotated_x <= signed(x_signed * cos_value + y_signed * not sin_value)(46 downto 36);
		rotated_y <= signed(y_signed * cos_x * cos_value + signed(vertex(35 downto 0)) * not sin_x * to_signed(262144, 20) + x_signed * cos_x * sin_value)(64 downto 54);
		
		
		ux <= rotated_x2 - rotated_x1;
		uy <= rotated_y2 - rotated_y1;
		vx <= rotated_x3 - rotated_x1;
		vy <= rotated_y3 - rotated_y1;
		normal_z <= ux*vy - uy*vx;
		
		vertex <= vertex1 when state = WAIT1_STATE else
					 vertex2 when state = WAIT2_STATE else
					 vertex3 when state = WAIT3_STATE else
					 vertex4 when state = WAIT4_STATE;
					 
		x_signed <= to_signed((x_draw + x_offset), 18) & "000000000000000000";
		y_signed <= to_signed((y_draw + y_offset), 18) & "000000000000000000";
		
		sin_memory : entity work.SinLookup port map(
			address => sin_address,
			clock => clk,
			q => sin_q
		);
	
		cos_memory : entity work.CosLookup port map(
			address => cos_address,
			clock => clk,
			q => cos_q
		);
		
end rtl;
