#include <system.h>
#include <io.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
//#include <math.h>

int ball_x = 320;
int ball_y = 398;
int ball_vx = 1;
int ball_vy = 1;
int ball_x_counter;
int ball_y_counter;
int x_speed = 5; //the larger, slower
int y_speed = 5; //the larger, slower
int x_board;
int slow = 0;
int row, col;
int brick_x;
int brick_y;
int z_flag;
int dazhao_flag = 1; //0: super mode. 1:regular mode
int dazhao_counter = 6666; //the super mode can only least for around 3 sec
int game_win = 48; //assume there are 48 bricks, eliminate one brick, game_win --, when game_win = 0, game win.
int game_over = 3; //0: game over, assume has 3 life at beginning.
int game_speed = 20; //30 is easy mode, 20 is normal, 10 is hard
int launch_ball; //0: to launch ball, 1:gaming
int game_score = 0;
int difficulty_mode = 0; //0 means easy. 1 means hard
int dazhao_flag_temp = 0;
int life_flag = 0;
#define brick_row 24
#define brick_column 16
#define brick_length 40
#define brick_width 20
#define brick_ox 80			// brick length, we can ignore them
#define brick_oy 40			// brick width, we can ignore them
#define width  480
#define length 640
#define radius 7
#define paddle_length  54
#define paddle_height  405

int brick_con_flag[brick_row] = { 0 };
int brick_flag[brick_row][brick_column] = { { 0 }, { 0 } };

void convert_flag(int row, int col, int re_set) {
	int tmp = (1 << (brick_column - col - 1)); //this minus 1 is necessary
	if (re_set == 0) {
		brick_con_flag[row] = brick_con_flag[row] & (0xFFFF - tmp);
		IOWR_16DIRECT(VGA_BASE, 2*row + 6, brick_con_flag[row]);
	} else {
		brick_con_flag[row] = brick_con_flag[row] | tmp;
		IOWR_16DIRECT(VGA_BASE, 2*row + 6, brick_con_flag[row]);
	}
	game_win--;
	game_score = game_score + 1 + difficulty_mode * 2;
	int tempHundred, tempHex, tempMod, tempScore;
	tempHundred = game_score / 100;
	tempHex = (game_score % 100) / 10;
	tempMod = (game_score % 100) % 10;
	//tempHex = game_score/10;
	//tempMod = game_score%10;
	tempScore = tempHundred * 256 + tempHex * 16 + tempMod;
	//printf("%d~%d~%d\n",tempHex,tempMod,game_score);
	IOWR_16DIRECT(VGA_BASE, 30, tempScore);

}

void set_ball_position() { //this is a better way because predicating methods is used below
	if (ball_x_counter > 0) {
		ball_x_counter--;
	} else {
		ball_x = ball_x + ball_vx;
		ball_x_counter = x_speed;
		IOWR_16DIRECT(VGA_BASE, 0, ball_x);

	}

	if (ball_y_counter > 0) {
		ball_y_counter--;
	} else {
		ball_y = ball_y + ball_vy;
		IOWR_16DIRECT(VGA_BASE, 2, ball_y);

		ball_y_counter = y_speed;
	}

}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// set the value of the brick_flag
void set_brick_flag() {
	int i;
	for (i = 0; i < brick_row - 16; i++)
		IOWR_16DIRECT(VGA_BASE, 2*i + 6, 0);
	// Need one outside cycle to be 0, as a buffer area
	int m, n;
	for (m = 2; m < brick_row - 2 - 16; m++) {
		for (n = 2; n < brick_column - 2; n++) {
			brick_flag[m][n] = 1;
		}
		brick_con_flag[m] = 0x3FFC; // 3 is left in screen, C is right in screen 3FFC
		IOWR_16DIRECT(VGA_BASE, 2*m + 6, brick_con_flag[m]);
	}
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// different situations of hitcases
void hitcase(int hit) {
	IOWR_16DIRECT(AUDIO_BASE, 0, 1);
	//play sound
	switch (hit) {
	case 0:
		break;
	case 1: // hit the upper bound OR the paddle
		ball_vy = 0 - ball_vy;
		x_speed = 6;
		y_speed = 3;

		break;

	case 2: // hit the left/right bound
		ball_vx = 0 - ball_vx;

		break;

	case 3: // hit the ground
	{
		ball_y = 1000;
		IOWR_16DIRECT(VGA_BASE, 2, ball_y);

		break;
	}
	case 4: // hit the other brick
	{
		ball_vx = 0 - ball_vx;
		ball_vy = 0 - ball_vy;
		break;
	}
	case 5: // hit the right paddle
	{
		ball_vy = 0 - ball_vy;
		//randomly generate 6 or 7 for x
		//3 or 4 for y
		if (ball_vx == 1) {
			x_speed = 2 + rand() % 2;
			y_speed = 7 + rand() % 2;
		} else if (ball_vx == -1) {
			ball_vx = 0 - ball_vx;
			x_speed = 6 + rand() % 2;
			y_speed = 3 + rand() % 2;
		}

		break;
	}
	case 6: // hit the left paddle
	{
		ball_vy = 0 - ball_vy;
		if (ball_vx == -1) {
			x_speed = 2 + rand() % 2;
			y_speed = 7 + rand() % 2;
		} else if (ball_vx == 1) {
			ball_vx = 0 - ball_vx;
			x_speed = 6 + rand() % 2;
			y_speed = 3 + rand() % 2;
		}
		break;
	}
	default:
		break;
	}

}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// break_bricks
void break_brick() {
	brick_x = 0; //brick_x = 1 denotes it's heading right's brick edge, -1 is heading left's edge
	brick_y = 0; //brick_y = 1 denotes it's heading top's edge, -1 is heading bottow's edge

	row = ball_y / brick_width;
	col = ball_x / brick_length;

	if (((col + 1) * brick_length - ball_x) <= (ball_vx + radius)
			&& (brick_flag[row][col + 1] != 0) && ball_vx > 0) {
		brick_x = 1;
	} else if ((ball_x - col * brick_length) <= (radius - ball_vx)
			&& (brick_flag[row][col - 1] != 0) && ball_vx < 0) { //it is important here
			// because when you want to judge if it will hit left, the ball_vx should be negative
			// so it is radius - ball_vx
		brick_x = -1;
	}

	if (((row + 1) * brick_width - ball_y) <= (ball_vy + radius)
			&& (brick_flag[row + 1][col] != 0) && ball_vy > 0) {
		brick_y = 1;
	} else if ((ball_y - row * brick_width) <= (radius - ball_vy)
			&& (brick_flag[row - 1][col] != 0) && ball_vy < 0) {
		brick_y = -1;
	}

	if ((ball_x >= 0) && (ball_x <= 640) && (ball_y <= 480) && (ball_y >= 0)) {
		// this is very important protection
		if ((brick_x != 0) && (brick_y != 0)) {
			// hit up or down
			if ((brick_flag[row][col + brick_x] == 0)
					&& (brick_flag[row + brick_y][col] == 1)) {
				brick_flag[row + brick_y][col] = 0;
				convert_flag(row + brick_y, col, 0);
				hitcase(1 * dazhao_flag);

			}

			// hit left or right
			else if ((brick_flag[row][col + brick_x] == 1)
					&& (brick_flag[row + brick_y][col] == 0)) {
				brick_flag[row][col + brick_x] = 0;
				convert_flag(row, col + brick_x, 0);
				hitcase(2 * dazhao_flag);
			}

			// hit both directions
			else if ((brick_flag[row][col + brick_x] == 1)
					&& (brick_flag[row + brick_y][col] == 1)) {
				brick_flag[row + brick_y][col] = 0;
				convert_flag(row + brick_y, col, 0);
				brick_flag[row][col + brick_x] = 0;
				convert_flag(row, col + brick_x, 0);
				hitcase(4 * dazhao_flag);

			}

			// hit the diagonal brick
			else if (brick_flag[row + brick_y][col + brick_x] == 1) {
				brick_flag[row + brick_y][col + brick_x] = 0;
				convert_flag(row + brick_y, col + brick_x, 0);
				hitcase(4 * dazhao_flag);
				ball_vy *= -1; //might need to add a new hitcase for this part.
			}
		} else if ((brick_x == 0) && (brick_y != 0)) {
			if (brick_flag[row + brick_y][col] != 0) {
				brick_flag[row + brick_y][col] = 0; //this cause the stuck!!!
				convert_flag(row + brick_y, col, 0);
				hitcase(1 * dazhao_flag); // and this
			}
		} else if ((brick_y == 0) && (brick_x != 0)) {
			if (brick_flag[row][col + brick_x] != 0) {
				brick_flag[row][col + brick_x] = 0;
				convert_flag(row, col + brick_x, 0);
				hitcase(2 * dazhao_flag);
			}
		}

	}

}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// judge if it is in the brick zone
void zone_flag() { //////brick_width and brick_length multiply by 2  is necessary
////so we need a outside circle of bricks
	if (((ball_y >= (brick_width * 2 - radius))
			&& (ball_y <= (brick_width * (brick_row - 2) + radius)))
			&& ((ball_x >= (brick_length * 2 - radius))
					&& (ball_x <= (640 - brick_length * 2 + radius)))) {
		z_flag = 1;
	} else {
		z_flag = 0;
	}
}
void transForm() {
	int i, j;
	for (i = 1; i < 10; i++) {
		for (j = 500 / i; j > 0; j--) {
			printf(" ");
		}
		IOWR_16DIRECT(VGA_BASE, 26, 0x0100);
		for (j = 500 / i; j > 0; j--) {
			printf(" ");
		}
		IOWR_16DIRECT(VGA_BASE, 26, 0x0000);
	}

}

void superMode(int score) { //which score to trigger the superMode
	if (game_score == score) {
		dazhao_flag = 0;
		dazhao_flag_temp = 1;
	}
	if (game_score > score && dazhao_flag_temp == 1) {
		dazhao_flag = 0;
		dazhao_flag_temp = 0;
		transForm();
		IOWR_16DIRECT(VGA_BASE, 26, 0x0000);

	}
	//turn off dazhao mode
	if (dazhao_flag == 0) {
		dazhao_counter--;
		if (dazhao_counter < 1000) {
			if (dazhao_counter % 100 < 50)
				IOWR_16DIRECT(VGA_BASE, 26, 0x0100);
			else
				IOWR_16DIRECT(VGA_BASE, 26, 0x0000);
		}
	}
	if (dazhao_counter < 0) {
		dazhao_counter = 6666;
		dazhao_flag = 1;
		IOWR_16DIRECT(VGA_BASE, 26, 0x0100);
	}

}

void addLifeMode(int score) { //which score to trigger the addLifeMode

	if (game_score == score && game_over<5 && life_flag == 0) {
		int j, i, life,life_plus_one;
		life = game_over;
		life_plus_one = life + 1;
		for (j = 0; j < 5; j++) {
			for (i = 0; i < 100; i++) {
				printf(" ");
			}
			IOWR_16DIRECT(VGA_BASE, 28, life_plus_one);
			for (i = 0; i < 100; i++) {
				printf(" ");
			}
			IOWR_16DIRECT(VGA_BASE, 28, life);
		}
		game_over++;
		life_flag = 1;
		IOWR_16DIRECT(VGA_BASE, 28, game_over);
	}

}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void judge_hit(int x_boards) {

	superMode(6);
	addLifeMode(12);
	break_brick();

	if (((ball_x > radius) && (ball_x < length - radius - ball_vx)
			&& (ball_y > radius) && (ball_y < paddle_height - radius - ball_vy))) {
		//set_ball_position();
	} else {
		// case 1: hit the upper bound
		if (ball_y <= radius && ball_vy == -1) {
			hitcase(1);
			set_ball_position();
		} else if (ball_y <= radius && ball_vy == 1) {
			set_ball_position(); //wait for the speed counter to be zero
		}

		// case 2: hit the left bound
		if (ball_x <= radius && ball_vx == -1) {
			hitcase(2);
			set_ball_position();
		} else if (ball_x <= radius && ball_vx == 1) {
			set_ball_position(); //wait for the speed counter to be zero
		}
		// case 3: hit the right bound
		if (ball_x >= length - radius - ball_vx && ball_vx == 1) {
			hitcase(2);
			set_ball_position();
		} else if (ball_x >= length - radius - ball_vx && ball_vx == -1) {
			set_ball_position(); //wait for the speed counter to be zero
		}
	}
	if (ball_y >= (paddle_height - radius - ball_vy)) { //radius+1
		/// hit the paddle
		if (ball_x <= radius) {
			hitcase(1);
			set_ball_position();
		}
		// case 3: hit the right bound
		if (ball_x >= length - radius - ball_vx) {
			hitcase(1);
			set_ball_position();
		}

		//middle of the paddle
		if ((ball_x <= (x_boards + (paddle_length / 4)))
				&& (ball_x > (x_boards - (paddle_length / 4)))) {
			hitcase(1);
			set_ball_position();
			//set_ball_position(); // help it to get out of judgement range
		}
		//right paddle
		else if ((ball_x <= (x_boards + (paddle_length / 2)))
				&& (ball_x > (x_boards + (paddle_length / 4)))) {
			hitcase(5);

			set_ball_position();
		}
		//left paddle
		else if ((ball_x <= (x_boards - (paddle_length / 4)))
				&& (ball_x >= (x_boards - (paddle_length / 2)))) {
			hitcase(6);

			set_ball_position();
		} else {
			game_over--;
			dazhao_flag_temp = 0;
			dazhao_flag = 1;
			IOWR_16DIRECT(VGA_BASE, 26, 0x0100);
			IOWR_16DIRECT(VGA_BASE, 28, game_over);
			hitcase(3);
			launch_ball = 0;
			if (game_over == 0) {
				hitcase(3);
			}
		}
	}

	set_ball_position();

	/*if(dazhao_flag == 0){
	 dazhao_counter--;

	 }
	 if(dazhao_counter == 0)
	 dazhao_flag = 1;*/

}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
void main_game() {
	ball_x = 228;
	ball_x_counter = 5;
	ball_y_counter = 5;
	int x_board = ball_x;
	set_brick_flag();
	launch_ball = 0;
	int direction_board;
	int fire_button_counter = 0;
	int offSet = 2;
	void zone_flag();
	while (1) {
		//IOWR_16DIRECT(VGA_BASE, 34, 0x0000);//init the ball to red bird

		direction_board = IORD_16DIRECT(ROTARY_BASE,0);
		if (direction_board == 4) {
			fire_button_counter++;
		} else
			fire_button_counter = 0;

		if (fire_button_counter == 60) {
			printf("push");
		}
		if ((x_board >= paddle_length / 2)
				&& (x_board <= length - paddle_length / 2)) {
			if (direction_board == 1) {
				x_board -= 1 * offSet;
			} else if (direction_board == 2) {
				x_board += 1 * offSet;
			}
		} else if (x_board <= paddle_length / 2) {
			x_board = paddle_length / 2;
		} else {
			x_board = length - paddle_length / 2;
		}
		if (launch_ball != 0) { //gaming
			slow++;
			zone_flag();
			if (slow == game_speed) { // let the maximux number be the speed

				judge_hit(x_board);
				//x_board = ball_x; //TEST!

				//below if can't be removed if rotary is added
				if (x_board <= paddle_length / 2) {
					x_board = paddle_length / 2;
				} else if (x_board >= (length - paddle_length / 2)) {
					x_board = length - paddle_length / 2;
				}
				slow = 0;
			}
		} else { //ready to launch the ball.
			ball_x = x_board;
			ball_y = 395;
			IOWR_16DIRECT(VGA_BASE, 0, ball_x);
			IOWR_16DIRECT(VGA_BASE, 2, ball_y);
			if (fire_button_counter == 60) {
				launch_ball = 1;
				ball_vy = -1;
				ball_vx = 1;
			}

		}

		IOWR_16DIRECT(VGA_BASE, 4, x_board);
		if (game_over == 0) {
			IOWR_16DIRECT(VGA_BASE, 22, 0xffff);
			int i = 0;
			for (i = 0; i < 3600; i++) {
				printf(" ");
			}
			printf("game over, your score%d", game_score);
			IOWR_16DIRECT(VGA_BASE, 22, 0x0000);
			IOWR_16DIRECT(VGA_BASE, 24, 0x0000);
			IOWR_16DIRECT(VGA_BASE, 26, 0x0100);
			//yellow bird
			break;
		}
		if (game_win == 0) {
			int i = 0;
			for (i = 0; i < 3600; i++) {
				printf(" ");
			}
			printf("game win, your score%d", game_score);
			IOWR_16DIRECT(VGA_BASE, 22, 0x0000);
			IOWR_16DIRECT(VGA_BASE, 24, 0x0000);
			IOWR_16DIRECT(VGA_BASE, 26, 0x0100);
			break;
		}
	}
}

void enterMode() {
	system("cls");
	printf("start!\n");
	printf("With difficulty level:%d", difficulty_mode);
	if (difficulty_mode == 1) { //hard mode
		game_over = 1;
		game_speed = 12;
	} else {
		game_over = 3;
		game_speed = 20;
	}

	game_win = 48;
	life_flag = 0;
	IOWR_16DIRECT(VGA_BASE, 28, game_over);
	IOWR_16DIRECT(VGA_BASE, 22, 0x0001);
	//main game

	game_score = 0;
	IOWR_16DIRECT(VGA_BASE, 30, 0x0000);
	//IOWR_16DIRECT(VGA_BASE, 34, 0x0000);//init the ball to red bird
	//printf("/n30~~%d",IORD_16DIRECT(VGA_BASE, 30));
	//printf("/n~~%d",IORD_16DIRECT(VGA_BASE, 32));
	main_game();

}

void print_menu() {
	system("cls");
	printf("\t\t Start Game\n");
	printf("\t\t  < Mode >\n");
	printf("\t\tInstructions\n");
	printf("\t\t The Credits\n");
	printf("\t\t  Quit Game\n\n");

}
void print_state(int menuCounter) {
	//only for print current status
	switch (menuCounter) {
	case 0: //Start Game
		printf("Start Game");
		IOWR_16DIRECT(VGA_BASE, 24, 0x0000);
		break;
	case 1: //Select Mode
		printf("Select Mode");
		IOWR_16DIRECT(VGA_BASE, 24, 0x0001);
		break;
	case 2: //Easy Mode
		printf("Easy Mode");
		IOWR_16DIRECT(VGA_BASE, 26, 0x0100);
		break;
	case 3: //Hard Mode
		printf("Hard Mode");
		IOWR_16DIRECT(VGA_BASE, 26, 0x0101);
		break;
	default:
		break;

	}
}
int main() {

	char cmd;
	int pram[3] = { 0 };
	int menuCounter = 1000;
	int modeCounter = 0;
	int inputs;
	print_menu();
	IOWR_16DIRECT(VGA_BASE, 22, 0x0000);
	IOWR_16DIRECT(VGA_BASE, 24, 0x0000);
	IOWR_16DIRECT(VGA_BASE, 26, 0x0100);
	int rotate_debounce = 60;
	int push_debounce = 5000;

	while (1) {
		inputs = IORD_16DIRECT(ROTARY_BASE,0); //1:right,2:left,4:enter

		//handle the exit, enter, input, left, right, up, down(assume two rotary controllers)
		//rotary 1 handle: up, down, enter
		//rotary 2 handle: left, right, exit
		switch (inputs) {
		case 1: //Up(left)
			//printf("\r          ");
			rotate_debounce--;
			if (rotate_debounce == 0) {
				menuCounter--;
				print_menu();
				print_state(menuCounter % 2);
				rotate_debounce = 60;
			}
			//printf("%d",menuCounter%5);
			break;
		case 2: //Down(right)
			//printf("\r          ");
			rotate_debounce--;
			if (rotate_debounce == 0) {
				menuCounter++;
				print_menu();
				print_state(menuCounter % 2);
				rotate_debounce = 60;
			}
			//printf("%d",menuCounter%5);
			break;
		case 4: //Enter
			push_debounce--;
			if (push_debounce == 0) {
				if (menuCounter % 2 == 1) {
					modeCounter++;
					//printf("Mode_Counter:%d", modeCounter);
					print_state(2 + (modeCounter % 2));
				} else {
					difficulty_mode = modeCounter % 2; //mode
					enterMode();
					print_menu();
					modeCounter = 0;

				}
				push_debounce = 5000;
			}

			break;
		default:
			break;
		}

	}

	return 0;
}

