library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_wm8731_audio is
port (
    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    reset_n : in std_logic;
    --test_mode : in std_logic;       --    Audio CODEC controller test mode
    writedata : in std_logic_vector(15 downto 0) := "0000000000000000";
	 --address    : in  std_logic_vector(16 downto 0);
	 write      : in std_logic;
	 chipselect : in std_logic;
  
    -- Audio interface signals
    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
  );
end  de2_wm8731_audio;

architecture rtl of de2_wm8731_audio is     

    signal lrck : std_logic;
    signal bclk : std_logic;
    signal xck  : std_logic;    
    signal lrck_divider : unsigned(15 downto 0); 
    signal bclk_divider : unsigned(11 downto 0);
    signal set_bclk : std_logic;
    signal set_lrck : std_logic;
    signal clr_bclk : std_logic;
    signal lrck_lat : std_logic;
			    
    signal shift_out : unsigned(15 downto 0);
	 signal data : std_logic_vector(15 downto 0);
    signal en_out: std_logic;
	 signal ram_address : std_logic_vector(13 downto 0);
	 --signal clk_25 :std_logic;
	 
 component music is
	port
	(
		address		: IN STD_LOGIC_VECTOR (13 DOWNTO 0);
		clock		: IN STD_LOGIC  := '1';
		q		: OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
	);
end component;

begin
    -- LRCK divider 
    -- Audio chip main clock is 18.432MHz / Sample rate 48KHz
    -- Divider is 18.432 MHz / 48KHz = 192 (X"C0")
    -- Left justify mode set by I2C controller
 
  --process (clk)
  --begin
   -- if rising_edge(clk) then
   --   clk_25 <= not clk_25;
   -- end if;
  --end process;
  
  
musicrom: music port map(
      address	=> ram_address,	
		clock => clk,
		q	=> data	
	);	 



--------------------------------------------interrupt----------------------------------- 
  process (clk)
  begin
    if rising_edge(clk) then
	     if reset_n = '0' then 
           en_out <= '0';
	     elsif write = '1' and chipselect = '1' then
	        en_out <= writedata(0);
		  elsif ram_address=std_logic_vector(to_unsigned(8283,14)) then
		     en_out <= '0';
		 end if;
	 end if;
  end process;
  
   ---------------------------------------------RAM address counter----------------------------------------------- 
    process(clk)      
    begin
      if rising_edge(clk) then
        if reset_n = '0' then 
            ram_address <= (others => '0');
        elsif lrck_lat = '1' and lrck = '0'  then  
			 if ram_address = std_logic_vector(to_unsigned(8283,14)) then  
			     ram_address <= std_logic_vector(to_unsigned(0,14)); 
          else
              ram_address <= std_logic_vector(unsigned(ram_address) + 1);
          end if;
        end if;
      end if;
    end process;
	 
  -------------------------------------clock-----------------------------------------------------
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then 
        lrck_divider <= (others => '0');
      elsif lrck_divider = X"0236"  then       
        lrck_divider <= X"0000";
      else 
        lrck_divider <= lrck_divider + 1;
      end if;
    end if;   
  end process;
  

  process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then 
        bclk_divider <= (others => '0');
      elsif bclk_divider = X"023" or set_lrck = '1'  then   
        bclk_divider <= X"000";
      else 
        bclk_divider <= bclk_divider + 1;
      end if;
    end if;
  end process;

  set_lrck <= '1' when lrck_divider = X"0236" else '0';
    
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        lrck <= '0';
      elsif set_lrck = '1' then 
        lrck <= not lrck;
      end if;
    end if;
  end process;
  
  process(clk)
    begin
      if rising_edge(clk) then
        lrck_lat <= lrck;
      end if;
  end process;

  set_bclk <= '1' when bclk_divider(11 downto 0) = X"011" else '0';  --72
  clr_bclk <= '1' when bclk_divider(11 downto 0) = X"023" else '0';   --144
  
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        bclk <= '0';
      elsif set_lrck = '1' or clr_bclk = '1' then
        bclk <= '0';
      elsif set_bclk = '1' then 
        bclk <= '1';
      end if;
    end if;
  end process;
  
  ------------------------------------------- Audio data shift output--------------------------------------
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        shift_out <= (others => '0');
      elsif en_out='1' and ram_address < std_logic_vector(to_unsigned(8283,14)) then
		  if set_lrck = '1' then
          shift_out <= unsigned(data);
        elsif clr_bclk = '1' then 
          shift_out <= shift_out (14 downto 0) & '0'; 
        end if;
		else
		  shift_out <= (others => '0');
		end if;
    end if;   
  end process;

    -- Audio outputs
    AUD_ADCLRCK  <= lrck;          
    AUD_DACLRCK  <= lrck;          
    AUD_DACDAT   <= shift_out(15); 
    AUD_BCLK     <= bclk;          


end architecture;


