-------------------------------------------------------------------------------
--
-- Simple VGA raster display
--
-- Stephen A. Edwards
-- sedwards@cs.columbia.edu
--
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

entity de2_vga_raster is 
  port (
    reset_n : in std_logic;
    clk   : in std_logic;                    -- Should be 25.125 MHz
	 
	
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  std_logic_vector(4 downto 0);

    readdata   : out std_logic_vector(15 downto 0);
    writedata  : in  std_logic_vector(15 downto 0);

    VGA_CLK,                         -- Clock
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0); -- Blue[9:0]
	 
	 sram_address   : out std_logic_vector(17 downto 0);  --sram address 10^18=256*1024
	 sram_datain : in  std_logic_vector(15 downto 0)   --sram data read in
    );

end de2_vga_raster;

architecture rtl of de2_vga_raster is
  
  -- Video parameters
  
  constant HTOTAL       : integer := 800;
  constant HSYNC        : integer := 96;
  constant HBACK_PORCH  : integer := 48;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 16;
  
  constant VTOTAL       : integer := 525;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 33;
  constant VACTIVE      : integer := 480;
  constant VFRONT_PORCH : integer := 10;
  
  
--  constant x       : integer := 300;    --the coodination of circle
--  constant y       : integer := 300;
  
--  type cir_pix is array (0 to 14) of
--       std_logic_vector(0 to 14);  
--  constant cir_pixel: cir_pix :=
--(
--('0','0','0','0','0','1','1','1','1','1','0','0','0','0','0'),
--('0','0','0','1','1','1','1','1','1','1','1','1','0','0','0'),
--('0','0','1','1','1','1','1','1','1','1','1','1','1','0','0'),
--('0','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
--('0','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
--('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
--('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
--('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
--('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
--('1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'),
--('0','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
--('0','1','1','1','1','1','1','1','1','1','1','1','1','1','0'),
--('0','0','1','1','1','1','1','1','1','1','1','1','1','0','0'),
--('0','0','0','1','1','1','1','1','1','1','1','1','0','0','0'),
--('0','0','0','0','0','1','1','1','1','1','0','0','0','0','0')
--);

--constant brick_layout: std_logic_vector(0 to 127) :=  ---bricklayout= 16*8
--(
--'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0',
--'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0',
--'0','0','1','1','1','1','0','1','1','1','1','1','1','1','0','0',
--'0','0','1','1','0','1','1','1','1','1','1','0','1','1','0','0',
--'0','0','1','1','1','0','1','1','1','1','1','1','1','1','0','0',
--'0','0','1','1','1','0','1','1','1','1','1','1','1','1','0','0',
--'0','0','1','1','0','0','1','1','1','1','1','1','0','1','0','0',
--'0','0','1','1','1','1','1','1','1','0','1','1','1','1','0','0'
--);


constant circle_pix: std_logic_vector(0 to 224) :=
(
'0','0','0','0','0','0','0','1','1','1','0','0','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','0','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1'
);


constant board_pix: std_logic_vector(0 to 942) :=
(
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0'
);




constant brick1_pix: std_logic_vector(0 to 799) :=
(
'0','0','0','0','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0',   
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','0','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','0','0',
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0'
); 
constant brick2_pix: std_logic_vector(0 to 799) :=
(
'0','0','0','0','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','0','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','0','0',
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0'
);  



type RGB is array (0 to 255) of
       integer;  
  constant R: RGB :=
(255,255,255,255,255,255,255,125,153,173,255,255,255,255,255,255,
255,255,255,255,255,185,172,100,213,218,151,255,255,255,255,255,
255,255,255,255,169,199,214,201,144,182,219,186,255,255,255,255,
255,255,255,255,255,116,124,188,212,212,215,177,168,255,255,255,
255,255,255,255,154,156,213,212,213,212,213,221,212,133,255,255,
255,255,255,194,141,211,213,213,213,213,213,213,214,220,147,255,
255,255,194,111,191,212,213,212,195,178,213,212,213,213,181,214,
186,92,92,168,197,213,213,213,90,14,137,212,213,154,36,137,
67,30,55,183,198,212,213,212,193,106,45,53,65,41,85,137,
255,83,100,184,198,213,200,203,171,232,142,181,109,194,144,145,
255,255,117,183,191,200,193,194,185,139,137,203,194,150,183,135,
255,255,116,184,184,191,204,204,199,148,230,251,251,237,158,122,
255,255,160,160,184,191,207,205,205,149,143,170,196,186,170,137,
255,255,255,95,162,203,205,205,205,200,160,200,173,185,82,241,
255,255,255,255,126,99,172,204,205,204,205,176,140,89,225,255,
255,255,255,255,255,234,151,103,93,93,96,113,186,255,255,255);


  constant G: RGB :=
(255,255,255,255,255,255,255,97,57,162,255,255,255,255,255,255,
255,255,255,255,255,179,150,15,0,0,117,255,255,255,255,255,
255,255,255,255,169,1,0,1,0,1,1,178,255,255,255,255,
255,255,255,255,255,113,0,0,0,0,0,22,164,255,255,255,
255,255,255,255,149,1,0,1,0,1,0,1,1,108,255,255,
255,255,255,193,3,0,0,0,0,0,0,0,0,0,129,255,
255,255,193,42,0,1,0,1,0,1,0,1,0,1,5,214,
186,92,89,0,0,0,0,0,1,1,0,0,0,0,1,102,
67,30,3,1,0,1,0,1,0,97,45,2,1,41,7,29,
255,83,20,0,0,0,0,0,0,232,142,181,109,173,34,1,
255,255,38,1,0,1,0,1,0,36,58,154,141,33,0,3,
255,255,72,0,0,0,0,9,42,34,169,186,186,176,37,46,
255,255,157,1,0,23,116,171,175,133,124,116,135,128,116,129,
255,255,255,75,37,163,175,175,175,171,123,128,119,40,39,241,
255,255,255,255,125,86,147,174,175,174,175,150,119,82,225,255,
255,255,255,255,255,234,151,101,88,86,91,112,186,255,255,255);



 constant B: RGB :=
(255,255,255,255,255,255,255,105,87,166,255,255,255,255,255,255,
255,255,255,255,255,181,157,33,44,56,127,255,255,255,255,255,
255,255,255,255,169,54,45,42,30,38,59,181,255,255,255,255,
255,255,255,255,255,114,26,39,43,43,46,71,165,255,255,255,
255,255,255,255,150,31,44,44,44,44,44,52,63,116,255,255,
255,255,255,193,24,42,44,44,44,44,44,44,45,60,135,255,
255,255,193,53,31,44,44,44,40,38,44,44,44,45,52,214,
186,92,90,24,34,44,44,44,20,5,29,43,44,32,11,112,
67,31,11,27,35,44,44,44,39,100,46,13,15,42,22,56,
255,83,32,27,35,44,36,38,30,232,142,181,110,176,51,31,
255,255,50,27,31,37,32,33,28,51,45,39,24,22,26,29,
255,255,78,27,27,31,39,44,62,40,27,30,30,28,26,61,
255,255,158,24,27,46,112,144,147,120,91,22,24,24,22,131,
255,255,255,78,48,139,147,147,147,144,78,27,46,59,45,241,
255,255,255,255,125,75,123,146,147,146,147,128,101,80,225,255,
255,255,255,255,255,234,151,99,83,80,87,111,186,255,255,255);



type RGB_Board is array (0 to 942) of
       integer;  
  constant R_Board: RGB_Board :=
(255,255,255,255,255,255,255,148,139,139,139,139,143,157,152,128,168,170,170,159,110,134,130,121,139,157,139,121,116,103,121,121,121,139,152,255,255,255,255,255,255,
255,255,255,255,152,112,115,148,170,148,116,85,85,103,110,233,255,255,255,255,223,95,159,191,98,141,201,212,223,255,255,212,148,85,94,134,255,255,255,255,255,
255,255,255,139,132,223,255,255,255,255,255,244,212,138,106,255,255,255,255,255,255,255,255,233,170,255,255,255,255,255,255,255,255,233,159,95,125,139,139,255,255,
255,255,139,108,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,180,212,170,112,255,
255,152,97,197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,113,255,
255,121,149,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,212,103,255,
255,89,191,238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,201,127,116,255,
130,117,210,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,116,121,255,
112,152,210,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,89,255,
103,172,210,218,255,255,255,255,255,255,159,127,191,255,255,255,255,255,255,255,255,255,255,255,255,255,223,95,63,79,255,255,255,255,255,255,255,255,255,148,130,
103,178,210,210,235,255,255,255,255,143,255,95,47,239,255,255,255,255,255,255,255,255,255,255,255,255,143,255,111,0,143,255,255,255,255,255,255,255,255,212,107,
116,178,210,210,210,221,238,255,255,31,175,47,0,191,255,239,191,255,255,159,255,255,159,63,255,255,63,127,47,0,127,255,255,255,255,255,255,255,255,180,116,
134,147,210,210,210,210,210,215,226,71,0,0,31,239,255,191,191,255,95,95,143,191,143,79,255,255,175,15,0,47,239,255,255,255,255,255,255,255,252,111,143,
255,133,210,210,210,210,210,210,210,183,118,105,181,255,255,239,127,127,239,255,175,127,127,223,255,255,255,223,191,239,243,255,255,255,255,255,255,252,187,98,255,
255,130,194,210,210,210,210,210,210,210,210,210,210,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,252,212,218,246,255,255,255,246,207,108,139,255,
255,255,133,210,210,210,210,210,210,210,210,210,210,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,210,210,210,194,203,210,186,112,130,255,255,
255,255,134,131,210,210,210,210,210,210,210,210,210,210,226,232,232,232,249,255,255,255,240,243,255,255,255,246,221,210,210,210,210,109,103,103,107,143,255,255,255,
255,255,255,112,108,178,210,210,210,210,210,210,210,210,210,210,210,210,226,243,243,232,210,210,210,210,210,210,210,210,210,210,147,148,255,255,255,255,255,255,255,
255,255,255,255,116,85,108,116,202,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,186,110,255,255,255,255,255,255,255,255,
255,255,255,255,255,148,139,98,186,210,210,194,186,210,210,210,210,210,210,210,210,210,186,186,210,210,210,210,210,210,191,105,143,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,125,139,210,210,131,116,210,210,210,210,210,210,210,210,178,120,101,131,178,178,178,178,147,101,143,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,152,107,103,103,121,121,112,178,210,210,210,194,147,100,112,148,255,125,112,103,103,103,130,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,148,116,103,103,103,116,139,143,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

constant G_Board: RGB_Board :=
(255,255,255,255,255,255,255,189,182,182,182,182,185,197,193,170,196,196,196,188,155,178,174,167,182,197,182,167,163,152,167,167,167,182,193,255,255,255,255,255,255,
255,255,255,255,193,159,159,181,196,181,159,137,137,152,155,240,255,255,255,255,232,144,188,210,148,177,218,225,232,255,255,225,181,137,144,178,255,255,255,255,255,
255,255,255,182,170,232,255,255,255,255,255,247,225,173,151,255,255,255,255,255,255,255,255,240,196,255,255,255,255,255,255,255,255,240,188,144,170,182,182,255,255,
255,255,182,155,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,203,225,196,159,255,
255,193,147,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,159,255,
255,167,184,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,225,152,255,
255,140,222,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,218,166,163,255,
174,163,237,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,159,167,255,
159,190,237,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,232,140,255,
152,207,237,240,255,255,255,255,255,255,159,127,191,255,255,255,255,255,255,255,255,255,255,255,255,255,223,95,63,79,255,255,255,255,255,255,255,255,255,181,174,
152,212,237,237,247,255,255,255,255,143,255,95,47,239,255,255,255,255,255,255,255,255,255,255,255,255,143,255,111,0,143,255,255,255,255,255,255,255,255,225,155,
163,212,237,237,237,241,248,255,255,31,175,47,0,191,255,239,191,255,255,159,255,255,159,63,255,255,63,127,47,0,127,255,255,255,255,255,255,255,255,203,163,
178,187,237,237,237,237,237,239,243,76,0,0,31,239,255,191,191,255,95,95,143,191,143,79,255,255,175,15,0,47,239,255,255,255,255,255,255,255,253,156,185,
255,175,237,237,237,237,237,237,237,207,133,118,197,255,255,239,127,127,239,255,175,127,127,223,255,255,255,223,191,239,250,255,255,255,255,255,255,253,215,148,255,
255,174,224,237,237,237,237,237,237,237,237,237,237,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,238,240,251,255,255,255,251,233,155,182,255,
255,255,175,237,237,237,237,237,237,237,237,237,237,246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,237,237,237,224,232,237,218,159,174,255,255,
255,255,178,174,237,237,237,237,237,237,237,237,237,237,243,246,246,246,252,255,255,255,249,250,255,255,255,251,241,237,237,237,237,157,152,152,155,185,255,255,255,
255,255,255,159,155,212,237,237,237,237,237,237,237,237,237,237,237,237,243,250,250,246,237,237,237,237,237,237,237,237,237,237,187,189,255,255,255,255,255,255,255,
255,255,255,255,163,137,155,162,230,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,237,218,158,255,255,255,255,255,255,255,255,
255,255,255,255,255,189,182,148,218,237,237,224,218,237,237,237,237,237,237,237,237,237,218,218,237,237,237,237,237,237,222,153,185,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,170,180,237,237,174,162,237,237,237,237,237,237,237,237,212,165,150,174,212,212,212,212,187,150,185,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,193,155,152,152,167,167,159,212,237,237,237,224,187,149,159,189,255,170,159,152,152,152,174,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,189,163,152,152,152,163,182,185,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);


constant B_Board: RGB_Board :=
(255,255,255,255,255,255,255,234,234,234,234,234,234,234,234,236,243,244,244,243,236,234,234,234,234,234,234,234,234,234,234,234,234,234,234,255,255,255,255,255,255,
255,255,255,255,234,234,236,241,244,241,237,234,234,234,236,252,255,255,255,255,251,235,243,247,234,239,248,249,251,255,255,249,241,234,234,234,255,255,255,255,255,
255,255,255,234,239,251,255,255,255,255,255,253,249,240,236,255,255,255,255,255,255,255,255,252,244,255,255,255,255,255,255,255,255,252,243,235,234,234,234,255,255,
255,255,234,237,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,245,249,244,234,255,
255,234,235,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,235,255,
255,234,229,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,234,255,
255,234,247,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,248,239,234,255,
234,237,251,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,237,234,255,
234,242,251,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,251,234,255,
234,244,251,251,255,255,255,255,255,255,159,127,191,255,255,255,255,255,255,255,255,255,255,255,255,255,223,95,63,79,255,255,255,255,255,255,255,255,255,241,234,
234,246,251,251,253,255,255,255,255,143,255,95,47,239,255,255,255,255,255,255,255,255,255,255,255,255,143,255,111,0,143,255,255,255,255,255,255,255,255,249,234,
234,246,251,251,251,252,253,255,255,31,175,47,0,191,255,239,191,255,255,159,255,255,159,63,255,255,63,127,47,0,127,255,255,255,255,255,255,255,255,245,234,
234,242,251,251,251,251,251,251,252,78,0,0,31,239,255,191,191,255,95,95,143,191,143,79,255,255,175,15,0,47,239,255,255,255,255,255,255,255,254,237,234,
255,239,251,251,251,251,251,251,251,219,141,125,204,255,255,239,127,127,239,255,175,127,127,223,255,255,255,223,191,239,254,255,255,255,255,255,255,254,247,234,255,
255,234,248,251,251,251,251,251,251,251,251,251,251,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,251,251,254,255,255,255,254,250,237,234,255,
255,255,239,251,251,251,251,251,251,251,251,251,251,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,252,251,251,251,248,248,251,247,237,234,255,255,
255,255,234,240,251,251,251,251,251,251,251,251,251,251,252,253,253,253,254,255,255,255,253,254,255,255,255,254,252,251,251,251,251,236,234,234,234,234,255,255,255,
255,255,255,234,237,246,251,251,251,251,251,251,251,251,251,251,251,251,252,254,254,253,251,251,251,251,251,251,251,251,251,251,242,234,255,255,255,255,255,255,255,
255,255,255,255,234,234,237,238,249,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,247,235,255,255,255,255,255,255,255,255,
255,255,255,255,255,234,234,234,247,251,251,248,247,251,251,251,251,251,251,251,251,251,247,247,251,251,251,251,251,251,247,236,234,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,234,241,251,251,240,238,251,251,251,251,251,251,251,251,246,238,235,240,246,246,246,246,242,235,234,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,234,234,234,234,234,234,237,246,251,251,251,248,242,236,234,234,255,234,234,234,234,234,234,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,234,234,234,234,234,234,234,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);


type RGB_Brick1 is array (0 to 799) of
       integer;  
  constant R_Brick1: RGB_Brick1 :=
(255,255,255,255,251,251,251,251,251,251,251,251,251,255,251,251,251,251,251,255,251,251,251,251,251,251,251,251,251,251,255,255,255,255,255,255,255,255,255,255,
255,255,251,251,255,255,255,255,255,255,255,255,251,251,251,255,255,255,251,251,251,255,255,255,255,255,255,255,255,255,253,255,253,253,253,253,253,253,255,255,
255,251,255,255,255,255,249,251,243,252,224,220,246,222,185,215,234,195,194,250,224,190,221,229,203,188,231,231,227,246,244,243,248,250,255,255,255,255,253,255,
255,251,255,255,251,251,252,251,250,253,242,248,222,231,252,252,241,248,248,184,205,254,246,246,255,246,222,236,255,255,252,249,249,251,252,252,255,255,253,255,
251,255,255,255,249,246,248,251,255,255,230,227,215,234,221,163,99,139,241,145,177,227,120,91,176,233,221,208,245,250,254,254,252,251,248,249,255,255,253,255,
251,255,255,255,243,244,255,255,254,229,218,233,206,230,160,102,0,71,182,181,182,161,53,2,119,158,243,218,218,227,249,255,255,254,245,247,255,255,253,255,
251,255,255,255,249,251,255,255,253,248,233,231,177,223,219,220,193,212,209,206,212,211,204,176,224,215,229,168,230,234,247,250,255,255,249,247,255,255,253,255,
251,255,255,255,249,255,255,255,254,255,246,243,111,162,236,246,241,223,217,228,221,217,234,244,254,204,110,111,241,249,253,250,255,255,253,252,255,255,253,255,
251,255,255,255,255,246,252,255,251,244,241,253,150,59,123,173,210,230,237,246,239,228,232,203,154,97,62,147,228,246,250,250,255,252,251,253,255,255,255,251,
251,255,255,255,251,250,255,255,250,255,246,245,200,77,76,84,83,125,199,169,163,198,118,83,85,91,74,131,213,253,251,252,255,253,248,250,255,255,255,251,
251,255,255,255,253,254,254,249,248,252,252,230,226,150,82,100,82,99,163,119,111,166,93,86,102,88,102,217,242,243,251,249,255,255,255,255,255,255,255,251,
251,255,255,255,251,251,251,255,250,251,251,236,189,208,101,82,88,81,56,64,70,63,82,86,88,81,190,240,243,244,252,252,255,254,253,253,255,255,255,251,
251,255,255,255,248,249,251,255,252,249,247,243,234,244,201,84,85,118,132,107,103,117,130,126,79,150,242,241,246,247,252,252,252,252,247,248,255,255,255,251,
251,255,255,255,250,251,253,255,255,252,249,250,246,243,254,197,166,225,240,233,218,235,237,222,164,245,247,252,250,250,255,255,252,252,245,246,255,255,255,251,
251,255,255,255,252,255,255,255,255,255,252,253,245,249,250,255,206,220,246,244,255,253,231,220,195,255,245,252,254,254,255,255,253,253,251,251,255,255,253,255,
255,253,253,255,255,255,255,254,255,255,255,255,255,251,250,255,202,188,247,243,247,241,239,207,189,255,255,253,255,255,255,255,253,253,255,255,255,255,253,255,
255,255,255,253,255,255,251,250,252,253,255,255,255,252,253,251,241,185,190,207,233,237,193,191,240,255,247,254,254,254,250,250,252,252,255,255,255,255,253,255,
255,255,255,255,253,252,246,247,247,248,255,255,253,255,247,246,254,250,218,198,242,237,205,245,253,247,255,251,252,251,245,245,246,247,253,255,255,255,253,255,
255,255,255,255,255,253,253,255,255,255,255,255,255,255,253,253,253,253,253,253,253,253,253,253,255,255,255,255,255,255,255,253,255,255,255,253,253,253,255,255,
255,255,255,255,255,255,255,251,251,251,251,251,251,251,255,255,255,255,255,255,255,255,255,255,251,251,251,251,251,251,251,255,255,255,255,255,255,255,255,255);
 
 constant G_Brick1: RGB_Brick1 :=
(255,255,255,255,217,217,217,217,217,217,217,217,217,255,217,217,217,217,217,255,217,217,217,217,217,217,217,217,217,217,255,255,255,255,255,255,255,255,255,255,
255,255,201,204,243,239,239,239,239,239,239,239,201,201,201,239,239,239,201,201,201,239,239,239,239,239,239,239,239,239,220,255,220,220,220,220,220,220,255,255,
255,201,239,243,239,238,244,246,243,252,221,217,251,227,178,208,221,182,181,237,214,180,208,216,198,183,232,232,216,235,242,224,243,245,232,236,239,239,220,255,
255,201,239,240,239,240,244,244,244,248,233,237,206,215,255,255,253,255,246,182,204,253,255,255,255,247,206,220,242,247,247,244,240,242,237,237,239,239,220,255,
217,239,239,239,248,245,233,236,239,237,208,205,194,208,239,181,136,176,246,150,188,238,160,131,187,244,192,179,224,229,243,243,238,237,244,245,239,239,220,255,
217,239,239,239,241,242,239,241,237,212,199,217,187,211,186,128,44,117,187,186,197,176,100,49,139,178,222,197,194,203,232,238,237,234,242,244,239,239,220,255,
217,239,239,239,242,244,239,238,245,241,222,220,161,203,229,230,211,236,199,196,206,205,226,198,230,221,210,149,215,219,235,238,241,239,243,241,239,239,220,255,
217,239,239,239,238,244,242,236,244,246,245,242,84,139,228,238,246,228,201,212,208,204,233,243,237,187,79,80,236,244,244,241,242,240,242,241,239,239,220,255,
217,239,239,239,244,235,229,237,237,234,241,253,123,32,99,149,200,220,235,244,244,233,219,190,118,61,27,119,223,242,240,239,238,235,238,240,239,239,239,217,
217,239,239,239,244,243,244,242,235,241,240,239,171,48,25,33,42,84,200,170,165,200,77,42,27,33,41,98,201,241,239,240,243,240,242,244,239,239,239,217,
217,239,239,239,238,239,240,240,236,240,247,225,195,123,19,37,32,49,136,92,79,134,38,31,38,24,74,189,239,240,242,242,234,234,238,239,239,239,239,217,
217,239,239,239,244,244,239,243,240,241,247,232,171,190,46,27,35,28,15,23,23,16,23,27,32,25,175,220,242,243,242,242,241,240,241,241,239,239,239,217,
217,239,239,239,245,246,237,241,243,240,246,242,230,240,163,46,27,60,70,45,32,46,67,63,35,106,234,233,242,243,241,241,242,242,242,243,239,239,239,217,
217,239,239,239,241,242,236,239,241,238,242,243,248,245,231,174,105,164,156,149,126,143,169,154,132,213,242,247,241,241,238,238,242,242,241,242,239,239,239,217,
217,239,239,239,237,240,239,239,238,237,237,238,238,242,235,244,147,161,153,151,153,151,160,149,169,238,235,242,237,237,238,238,240,240,240,240,239,239,220,255,
255,220,220,239,240,241,244,242,240,241,239,239,241,236,240,249,155,141,165,161,155,149,174,142,168,246,241,238,236,236,241,241,241,241,241,242,239,239,220,255,
255,255,255,220,241,239,244,243,242,243,239,239,236,232,246,244,216,160,137,154,163,167,149,147,227,242,232,239,239,239,241,241,243,243,239,239,239,239,220,255,
255,255,255,255,220,235,240,241,243,244,239,240,237,241,245,244,249,245,188,168,195,190,179,219,248,242,243,239,242,241,241,241,224,225,215,234,239,239,220,255,
255,255,255,255,255,220,220,239,239,239,239,239,239,239,220,220,220,220,220,220,220,220,220,220,239,239,239,239,239,239,239,220,255,255,255,220,220,220,255,255,
255,255,255,255,255,255,255,217,217,217,217,217,217,217,255,255,255,255,255,255,255,255,255,255,217,217,217,217,217,217,217,255,255,255,255,255,255,255,255,255);
 
 constant B_Brick1: RGB_Brick1 :=
(255,255,255,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,
255,255,0,0,121,86,83,83,83,83,83,83,0,0,0,83,83,83,0,0,0,83,83,83,83,83,83,83,83,83,0,255,0,0,0,0,0,0,255,255,
255,0,83,125,104,120,125,119,73,124,99,95,146,112,158,188,200,161,74,130,125,91,190,198,158,143,74,74,92,111,87,0,84,86,91,95,83,83,0,255,
255,0,83,90,83,92,114,129,115,122,110,73,147,156,255,255,241,248,195,131,184,233,255,255,248,239,121,135,78,83,68,65,85,87,84,84,83,83,0,255,
0,83,83,83,88,85,91,94,103,101,71,68,156,160,239,181,154,194,248,152,186,236,178,149,205,255,138,125,73,78,81,81,93,92,83,84,83,83,0,255,
0,83,83,83,94,95,83,85,97,72,79,120,74,98,164,106,59,132,146,145,130,109,108,57,125,164,95,70,66,75,93,99,90,87,91,93,83,83,0,255,
0,83,83,83,92,94,61,60,75,102,78,76,90,121,229,230,220,248,127,124,138,137,247,219,215,206,82,21,86,90,89,92,75,73,91,89,83,83,0,255,
0,83,83,83,86,92,87,81,87,89,85,82,61,119,202,212,182,164,92,103,102,98,194,204,217,167,40,41,98,106,93,90,76,74,90,89,83,83,0,255,
0,83,83,83,94,85,99,107,104,131,113,95,78,0,15,65,77,97,88,97,80,69,109,80,66,9,0,96,107,124,94,87,90,87,95,97,83,83,83,0,
0,83,83,83,78,77,86,84,86,92,88,87,117,0,20,28,36,78,132,102,105,140,59,24,24,30,0,45,65,105,83,84,92,89,90,92,83,83,83,0,
0,83,83,83,98,99,82,121,91,95,87,65,110,50,30,48,21,38,143,99,82,137,44,37,54,40,0,109,93,94,79,114,108,108,89,90,83,83,83,0,
0,83,83,83,80,80,83,87,81,82,85,70,51,70,42,23,29,22,24,32,39,32,25,29,33,26,94,113,82,83,82,82,85,84,82,82,83,83,83,0,
0,83,83,83,74,75,92,96,78,75,86,82,71,81,119,2,18,51,73,48,50,64,58,54,0,71,91,90,80,81,89,89,72,72,86,87,83,83,83,0,
0,83,83,83,90,91,97,100,85,82,94,95,79,76,130,73,84,143,156,149,139,156,156,141,52,133,80,85,88,88,98,98,82,82,98,99,83,83,83,0,
0,83,83,83,98,101,89,89,87,86,95,96,93,97,93,102,115,129,161,159,165,163,156,145,58,127,75,82,108,108,94,94,87,87,96,96,83,83,0,255,
255,0,0,83,92,93,74,72,83,84,91,91,114,109,80,89,101,87,167,163,158,152,168,136,39,117,92,89,95,95,85,85,83,83,83,84,83,83,0,255,
255,255,255,0,86,84,76,75,82,83,85,85,103,99,78,76,113,57,97,114,130,134,102,100,84,99,83,90,88,88,86,86,80,80,83,83,83,83,0,255,
255,255,255,255,0,85,92,93,84,85,82,83,82,86,72,71,97,93,98,78,120,115,84,124,89,83,87,83,83,82,97,97,0,0,0,97,83,83,0,255,
255,255,255,255,255,0,0,83,83,83,83,83,83,83,0,0,0,0,0,0,0,0,0,0,83,83,83,83,83,83,83,0,255,255,255,0,0,0,255,255,
255,255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255);
 constant R_Brick2: RGB_Brick1 :=
(255,255,255,255,251,249,249,249,249,249,249,249,249,255,249,249,249,249,249,255,249,249,249,249,249,249,249,249,249,249,255,255,255,255,255,255,255,255,255,255,
255,255,249,249,251,251,251,251,251,251,251,251,251,249,251,251,251,251,251,249,251,251,251,251,251,251,251,251,251,251,249,255,249,249,249,249,249,249,255,255,
255,249,251,251,255,253,252,241,213,234,255,254,254,255,246,250,243,253,255,250,249,253,255,249,255,255,244,242,252,248,254,249,251,249,255,255,251,251,249,255,
255,249,251,251,250,255,255,193,101,205,255,235,255,207,104,241,255,223,250,255,255,237,228,254,178,148,254,254,241,251,181,156,252,250,252,254,251,251,249,255,
249,251,251,251,255,251,253,218,197,255,222,93,198,192,181,208,156,65,255,255,251,154,85,209,178,162,222,81,146,255,217,234,251,245,251,249,251,251,249,255,
249,251,251,251,255,249,251,205,255,230,177,255,253,253,248,249,253,211,184,255,175,214,241,241,252,252,255,229,178,232,255,255,251,253,255,249,251,251,249,255,
249,251,251,251,251,254,253,255,245,169,249,253,252,238,153,148,239,255,229,139,231,253,197,131,141,181,251,250,255,159,255,249,253,252,246,255,251,251,249,255,
249,251,251,251,255,255,246,255,217,198,255,255,203,72,0,0,67,211,212,43,210,242,67,0,0,26,190,249,255,176,239,254,255,255,255,253,251,251,249,255,
249,251,251,251,255,255,243,255,224,197,249,253,168,33,0,0,59,120,121,251,128,174,79,0,0,27,197,249,251,184,245,255,253,255,250,255,251,251,251,249,
249,251,251,251,253,250,255,245,255,188,197,251,240,188,99,94,234,189,178,252,210,201,217,146,130,189,255,255,219,178,255,248,255,254,250,249,251,251,251,249,
249,251,251,251,252,254,252,248,245,255,193,196,230,250,253,255,243,168,134,252,143,148,245,255,255,255,244,199,190,244,255,249,255,255,255,253,251,251,251,249,
249,251,251,251,250,253,254,253,255,243,246,228,194,191,198,194,215,246,188,236,180,246,207,178,188,180,207,211,253,236,253,255,250,251,251,253,251,251,251,249,
249,251,251,251,254,254,252,255,255,255,243,244,255,255,255,251,255,255,255,255,249,255,255,255,255,255,255,250,234,243,255,252,254,255,253,250,251,251,251,249,
249,251,251,251,254,255,252,254,255,255,246,252,250,252,255,251,255,255,255,255,255,255,252,255,254,254,248,252,251,255,249,253,253,249,254,252,251,251,251,249,
249,251,251,251,254,255,254,254,250,255,255,254,254,253,255,249,239,249,231,232,244,240,238,255,252,253,250,251,252,255,255,255,252,255,253,255,251,251,249,255,
255,249,249,251,255,251,254,253,251,243,245,255,215,193,169,167,157,126,186,128,103,165,189,142,180,190,199,219,255,240,222,250,255,255,254,255,251,251,249,255,
255,255,255,249,254,255,253,246,255,221,248,228,244,255,255,254,249,182,255,195,157,255,255,185,255,255,255,253,199,130,128,224,254,245,255,252,251,251,249,255,
255,255,255,255,252,253,249,253,244,255,228,154,196,255,245,248,232,158,154,164,174,151,144,195,251,239,246,254,177,149,180,235,250,250,245,252,251,251,249,255,
255,255,255,255,255,249,249,251,251,251,251,251,251,251,249,249,249,249,249,249,249,249,249,249,251,251,251,251,251,251,251,249,255,255,255,249,249,249,255,255,
255,255,255,255,255,255,255,249,249,249,249,249,249,249,255,255,255,255,255,255,255,255,255,255,249,249,249,249,249,249,249,255,255,255,255,255,255,255,255,255);

 constant G_Brick2: RGB_Brick1 :=
(255,255,255,255,217,225,225,225,225,225,225,225,225,255,225,225,225,225,225,255,225,225,225,225,225,225,225,225,225,225,255,255,255,255,255,255,255,255,255,255,
255,255,225,225,241,241,241,241,241,241,241,241,241,225,241,241,241,241,241,225,241,241,241,241,241,241,241,241,241,241,225,255,225,225,225,225,225,225,255,255,
255,225,241,241,241,236,243,233,212,233,248,243,243,245,251,254,244,254,240,235,241,245,251,244,240,248,246,244,248,243,234,214,243,241,240,241,241,241,225,255,
255,225,241,241,238,244,252,188,94,198,252,226,248,195,105,242,253,217,237,244,250,227,228,254,164,134,254,254,239,249,162,136,248,245,240,242,241,241,225,255,
225,241,241,241,241,235,255,222,198,255,207,79,193,187,157,183,159,68,249,245,244,148,81,205,164,147,215,76,145,255,205,222,246,241,240,238,241,241,225,255,
225,241,241,241,240,233,253,207,255,233,165,252,255,255,255,255,255,215,182,255,172,211,255,255,255,255,251,223,172,225,249,249,240,242,244,233,241,241,225,255,
225,241,241,241,238,241,240,245,242,166,252,255,251,237,213,208,242,255,233,143,239,255,243,176,166,206,255,255,254,154,252,238,240,239,229,243,241,241,225,255,
225,241,241,241,237,243,236,246,204,185,254,255,237,104,36,30,99,245,205,36,211,243,125,34,15,65,197,255,248,165,230,244,242,242,244,238,241,241,225,255,
225,241,241,241,235,236,241,255,211,188,246,248,228,92,9,8,100,162,116,245,127,173,132,30,12,63,199,251,251,178,235,250,232,235,234,239,241,241,241,225,
225,241,241,241,245,242,244,232,254,186,202,255,255,206,164,159,234,189,185,255,192,183,255,196,165,225,255,255,213,172,249,234,246,241,244,243,241,241,241,225,
225,241,241,241,241,243,241,240,242,255,182,185,222,248,251,254,248,172,137,255,144,149,236,250,253,254,232,187,187,241,243,239,239,239,243,239,241,241,241,225,
225,241,241,241,236,239,241,240,251,237,242,224,196,193,202,198,215,246,179,227,179,245,208,179,190,182,208,212,253,236,242,244,235,236,241,243,241,241,241,225,
225,241,241,241,241,241,237,243,241,240,232,233,255,252,251,245,245,249,238,237,236,250,250,253,251,251,254,248,225,234,248,243,240,242,246,243,241,241,241,225,
225,241,241,241,237,245,236,238,236,236,233,238,239,241,241,237,243,243,241,245,241,242,242,246,242,242,238,242,235,239,240,244,239,235,243,241,241,241,241,225,
225,241,241,241,238,240,242,242,237,244,248,246,250,249,251,244,242,252,237,238,244,240,241,255,249,250,246,248,241,247,244,246,240,244,233,238,241,241,225,255,
255,225,225,241,243,238,245,244,241,234,236,246,204,182,161,159,150,119,182,124,92,154,179,132,173,182,188,208,246,231,210,238,243,243,236,239,241,241,225,255,
255,255,255,225,235,240,240,234,251,214,242,223,238,251,255,252,244,178,255,192,153,255,248,176,253,255,249,245,191,122,124,219,243,235,243,238,241,241,225,255,
255,255,255,255,225,240,241,245,239,250,218,145,181,241,240,242,229,155,156,166,178,156,143,194,251,239,243,251,174,146,178,233,229,229,219,240,241,241,225,255,
255,255,255,255,255,225,225,241,241,241,241,241,241,241,225,225,225,225,225,225,225,225,225,225,241,241,241,241,241,241,241,225,255,255,255,225,225,225,255,255,
255,255,255,255,255,255,255,225,225,225,225,225,225,225,255,255,255,255,255,255,255,255,255,255,225,225,225,225,225,225,225,255,255,255,255,255,255,255,255,255);


 constant B_Brick2: RGB_Brick1 :=
(255,255,255,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,
255,255,0,0,79,79,79,79,79,79,79,79,79,0,79,79,79,79,79,0,79,79,79,79,79,79,79,79,79,79,0,255,0,0,0,0,0,0,255,255,
255,0,79,79,83,79,98,88,52,72,87,83,86,88,78,80,71,79,107,102,74,78,85,79,106,113,78,76,85,81,95,0,98,96,82,83,79,79,0,255,
255,0,79,79,75,80,97,36,0,83,118,93,111,61,0,130,96,63,79,85,102,80,75,99,42,12,103,103,84,93,42,16,85,83,79,80,79,79,0,255,
0,79,79,79,99,93,88,56,46,102,107,0,179,174,160,186,104,13,80,78,126,31,45,169,137,120,154,14,1,109,49,65,85,80,80,79,79,79,0,255,
0,79,79,79,101,94,74,30,92,67,135,221,255,255,242,243,248,206,45,117,119,159,255,255,245,245,251,223,108,161,82,82,91,93,104,93,79,79,0,255,
0,79,79,79,80,83,84,89,125,50,253,255,255,243,205,200,221,236,208,119,207,229,246,178,196,238,253,252,212,114,92,79,82,81,78,91,79,79,0,255,
0,79,79,79,93,99,87,97,132,113,240,242,255,137,76,70,118,255,213,44,224,255,129,38,36,85,207,255,254,171,68,81,78,78,85,79,79,79,0,255,
0,79,79,79,100,101,71,88,136,130,248,250,221,85,6,5,140,201,13,141,66,111,148,46,54,104,211,252,232,160,83,89,101,104,105,110,79,79,79,0,
0,79,79,79,79,77,93,81,114,49,208,255,255,216,181,177,253,207,37,108,133,124,255,189,188,250,238,237,162,120,108,94,77,72,82,81,79,79,79,0,
0,79,79,79,94,96,81,120,73,85,133,136,225,250,252,255,187,113,31,147,67,72,255,255,254,255,236,191,61,113,89,119,105,105,79,76,79,79,79,0,
0,79,79,79,95,98,82,81,65,52,98,80,63,60,76,72,80,110,52,98,31,95,82,54,80,73,113,86,86,71,85,87,90,91,79,80,79,79,79,0,
0,79,79,79,85,85,79,85,83,82,80,81,82,79,88,83,79,82,92,91,80,93,78,80,89,89,80,75,75,83,79,75,99,101,73,70,79,79,79,0,
0,79,79,79,90,98,83,85,100,100,84,89,82,84,100,96,85,85,94,98,96,97,79,83,92,92,83,87,108,112,70,74,96,92,84,82,79,79,79,0,
0,79,79,79,85,87,80,80,91,98,81,80,82,81,91,85,68,77,70,71,86,82,53,69,79,80,76,77,103,107,92,94,79,82,103,108,79,79,0,255,
255,0,0,79,74,69,77,76,104,97,97,107,87,66,61,59,93,63,162,103,90,152,139,91,65,75,70,89,111,96,68,94,78,78,84,87,79,79,0,255,
255,255,255,0,99,104,92,86,98,64,80,62,86,98,105,98,171,106,240,178,131,232,210,140,105,107,106,103,54,0,0,62,96,88,81,77,79,79,0,255,
255,255,255,255,0,82,76,79,79,88,69,0,44,102,62,64,114,41,74,83,85,63,44,95,84,74,73,79,26,0,27,80,0,0,0,90,79,74,0,255,
255,255,255,255,255,0,0,79,79,79,79,79,79,79,0,0,0,0,0,0,0,0,0,0,79,79,79,79,79,79,79,0,255,255,255,0,0,0,255,255,
255,255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255);

type colormap is array (0 to 81) of
       integer;  
  constant R_map: colormap :=
(32,32,32,0,0,0,0,0,0,0,64,64,64,96,64,64,64,96,32,0,96,32,32,0,32,0,0,32,32,192,160,96,128,160,0,128,96,128,128,32,160,64,128,192,224,160,64,96,96,0,32,32,64,64,
 160,128,128,0,64,64,0,96,96,96,128,128,0,96,64,166,255,255,32,0,192,160,192,192,192,224,224,224);

  constant G_map: colormap :=
  (128,160,192,128,160,255,192,96,96,64,160,192,128,128,96,96,64,96,64,128,160,32,32,160,96,32,64,96,128,128,128,96,96,96,32,96,64,64,128,64,96,64,160,160,160,160,
  128,128,64,96,160,96,32,160,128,128,64,0,128,96,128,160,128,96,160,128,0,192,32,202,255,251,64,64,220,192,128,96,192,128,96,160);
  constant B_map: colormap :=
  (192,192,192,192,192,255,192,192,128,128,192,192,192,192,192,128,128,192,128,128,192,128,64,128,128,64,64,192,128,192,192,128,192,192,128,128,128,128,192,64,128,
  64,192,192,192,192,128,128,64,64,128,64,64,128,128,128,64,64,64,64,64,128,64,64,128,64,0,192,0,240,255,240,0,0,192,192,128,128,192,128,128,128);
  
  
   ------------------------------add new colormaps, new ball and new brick----------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  
  -------------------super ball-------------
--  type RGB is array (0 to 255) of
--       integer;  
  constant R2: RGB :=
(255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,0,64,64,96,255,255,255,255,255,255,255,
255,255,255,255,255,160,32,0,64,255,255,255,255,255,255,255,
255,255,255,255,255,255,160,160,160,192,255,255,255,255,255,255,
255,255,255,255,255,255,160,224,224,192,192,255,255,255,255,255,
255,255,255,255,255,128,224,224,224,224,160,255,255,255,255,255,
255,255,255,255,160,224,224,224,224,224,224,128,255,255,255,255,
255,255,255,255,128,224,224,224,224,224,224,224,128,255,255,255,
128,255,160,128,224,224,224,224,224,224,224,224,192,160,255,255,
64,96,64,128,224,224,192,192,192,224,224,224,224,160,192,192,
192,0,64,224,224,224,224,192,192,128,224,192,224,160,128,255,
192,96,160,224,224,224,224,192,192,128,160,224,192,128,160,192,
255,128,224,224,224,224,224,224,224,128,192,192,160,160,160,128,
255,96,192,224,224,224,224,224,224,192,192,192,192,224,224,96 ,
255,160,96,96,128,160,192,192,192,192,192,160,128,128,96,160,
255,255,255,255,255,192,192,192,192,192,192,192,255,255,255,255);


  constant G2: RGB :=
(255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,0,64,64,96,255,255,255,255,255,255,255,
255,255,255,255,255,160,32,0,64,255,255,255,255,255,255,255,
255,255,255,255,255,255,160,128,160,192,255,255,255,255,255,255,
255,255,255,255,255,251,160,224,224,160,192,255,255,255,255,255,
255,255,255,255,255,128,224,224,224,224,160,251,255,255,255,255,
255,255,255,255,160,192,224,224,224,224,224,128,251,255,255,255,
251,255,255,251,128,224,224,224,224,224,224,224,128,255,255,255,
128,255,160,128,192,224,160,192,224,224,224,224,192,160,255,255,
64,96,64,128,224,192,96,64,96,160,224,224,160,96,96,160,
192,0,32,224,224,224,224,192,192,96,160,128,160,128,128,255,
192,96,128,224,224,224,224,160,192,128,128,160,160,128,160,192,
255,128,192,224,224,224,224,224,224,128,128,128,128,128,160,128,
255,64,192,224,224,224,224,224,224,220,160,160,192,224,224,96 ,
255,160,96,96,128,160,192,192,192,192,192,160,128,128,96,160,
255,255,255,255,251,192,192,192,192,192,192,220,251,255,255,255);



 constant B2: RGB :=
(255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,0,64,64,128,255,255,255,255,255,255,255,
255,255,255,255,255,164,64,0,64,255,255,255,255,255,255,255,
255,255,255,255,255,255,164,0,64,192,255,255,255,255,255,255,
255,255,255,255,255,240,64,64,64,64,192,255,255,255,255,255,
255,255,255,255,255,64,0,64,64,128,64,240,255,255,255,255,
255,255,255,255,164,0,64,64,64,64,64,64,240,255,255,255,
240,255,255,240,64,64,64,64,64,64,64,0,128,255,255,255,
128,255,164,128,0,64,0,0,64,64,64,64,0,164,255,255,
64,64,64,0,64,0,0,0,0,0,0,0,0,0,64,128,
192,0,0,64,64,64,64,128,192,64,0,0,128,128,64,255,
192,128,0,64,64,64,64,64,192,64,0,0,64,64,0,192,
255,128,0,64,64,64,64,64,0,0,0,0,0,0,0,64 ,
255,64,0,0,64,64,64,64,128,192,128,64,192,128,64,0  ,
255,164,64,0,0,64,128,192,192,192,192,164,128,128,128,164,
255,255,255,255,240,192,192,192,192,192,192,192,240,255,255,255);

constant circle_pix2: std_logic_vector(0 to 224) :=                --different from circle_pix which is 15*15 
(
'0','0','0','0','0','1','1','0','0','0','0','0','0','0','0',
'0','0','0','0','0','1','1','1','1','0','0','0','0','0','0',
'0','0','0','0','0','1','1','1','1','0','0','0','0','0','0',
'0','0','0','0','0','0','1','1','1','1','0','0','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','0','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','1','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','0','0',
'1','0','0','1','1','1','1','1','1','1','1','1','1','0','0',
'1','0','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1'
);                

  
  
    -------------------board when contact with the ball-------------
--  type RGB_Board is array (0 to 942) of
--       integer;  
  constant R_Board2: RGB_Board :=
(255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,184,154,146,141,131,118,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,168,131,136,122,124,125,118,124,198,188,174,244,255,255,255,209,96,145,185,119,167,166,176,186,170,170,159,122,90,116,220,255,255,255,255,255,
255,255,255,255,148,175,224,244,246,246,246,242,201,113,115,248,255,253,254,254,252,233,255,255,171,213,255,255,255,255,255,255,250,217,153,99,141,213,198,255,255,
255,255,255,135,238,255,255,255,255,255,255,255,255,244,219,255,254,254,254,254,255,255,254,253,255,255,255,252,252,252,252,252,255,255,255,228,156,160,165,120,255,
255,255,120,208,255,251,252,254,254,254,254,254,253,255,255,254,255,255,254,255,254,253,254,254,253,253,254,255,254,254,255,254,254,253,252,255,255,255,255,135,192,
255,176,141,255,254,253,254,255,255,255,255,254,255,254,253,255,255,255,255,255,255,255,255,255,254,254,255,255,255,255,255,255,255,255,255,253,252,255,255,124,201,
255,127,202,252,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,254,238,149,105,255,
145,148,223,247,254,253,255,254,253,254,255,254,255,255,255,255,255,255,255,255,254,255,254,254,255,254,254,254,254,252,252,254,255,254,254,254,253,252,168,90,255,
113,182,215,243,254,254,254,255,255,252,251,254,254,254,254,255,253,253,254,254,254,254,252,254,255,254,254,253,254,255,255,255,254,255,255,255,253,254,255,138,168,
119,198,208,224,255,253,253,234,219,255,255,255,254,252,255,255,255,255,255,255,255,255,255,255,255,255,253,255,255,148,58,200,255,252,254,255,255,253,254,223,128,
114,197,213,207,232,254,255,213,74,85,139,224,255,255,253,255,210,194,222,222,231,221,123,162,255,251,255,210,88,36,165,250,254,254,254,254,254,254,254,253,133,
136,189,212,206,206,219,237,254,249,187,104,40,65,181,253,255,134,137,115,116,153,175,182,155,252,254,135,0,13,199,255,255,255,252,251,251,251,250,254,240,127,
154,178,241,241,243,240,214,214,221,194,136,30,31,178,254,254,144,246,255,255,255,255,255,157,253,255,173,86,63,24,53,170,246,249,248,250,250,248,255,174,152,
205,217,255,250,252,255,242,192,55,0,49,141,220,255,252,255,180,193,255,243,245,253,213,138,255,253,255,255,255,194,95,54,239,255,251,250,251,253,223,110,255,
255,236,234,250,243,244,233,195,122,163,217,220,210,244,255,253,233,97,203,253,252,252,102,166,254,251,252,250,254,255,231,211,226,241,248,254,250,220,124,168,255,
255,255,139,200,220,210,206,211,224,218,209,207,206,225,252,255,255,183,76,112,139,105,164,249,255,255,255,255,251,221,205,208,210,178,152,170,156,122,169,255,255,
255,255,194,104,181,217,217,211,207,208,209,209,209,208,217,223,222,228,237,213,210,229,242,222,241,242,242,235,216,206,210,208,212,134,159,169,176,255,255,255,255,
255,255,255,186,88,121,169,199,210,209,209,209,208,210,208,207,207,204,213,234,236,225,205,206,207,208,209,208,208,209,206,221,156,147,255,255,255,255,255,255,255,
255,255,255,255,255,137,122,106,185,213,206,213,215,208,209,210,210,210,208,204,202,206,213,216,216,209,207,208,208,209,221,183,111,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,149,154,228,220,167,154,222,209,208,208,208,209,214,221,215,171,117,178,215,221,220,220,208,164,113,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,104,151,140,97,113,152,207,215,215,215,213,184,149,116,126,184,128,124,136,134,135,115,131,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,184,187,255,255,153,122,145,146,147,130,126,144,195,255,255,255,255,182,183,185,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,197,143,143,140,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

constant G_Board2: RGB_Board :=
(255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,202,183,178,176,169,161,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,193,167,171,163,164,164,158,163,214,206,198,247,255,255,255,223,144,178,204,158,191,189,200,206,195,195,187,162,140,153,228,255,255,255,255,255,
255,255,255,255,177,199,234,247,248,249,248,246,218,155,157,250,255,253,254,254,253,239,255,255,196,225,255,255,255,255,255,255,251,228,184,145,174,225,215,255,255,
255,255,255,170,243,255,255,255,255,255,255,255,255,248,230,254,254,254,254,254,255,255,254,254,255,255,254,252,253,253,253,253,255,255,255,236,186,188,192,159,255,
255,255,160,226,255,252,253,254,254,254,254,254,253,255,255,254,255,255,254,255,254,254,254,254,254,254,254,255,254,254,255,254,254,254,253,255,255,255,255,171,209,
255,198,181,255,253,254,254,255,255,255,255,255,255,254,253,255,255,255,255,255,255,255,255,255,254,254,255,255,255,255,255,255,255,255,255,254,252,254,255,163,215,
255,164,228,253,254,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,243,181,149,255,
172,184,245,251,255,253,255,254,253,254,255,254,255,255,255,255,255,255,255,255,254,255,254,254,255,254,254,254,254,252,252,254,255,254,254,254,253,253,194,139,255,
149,212,241,248,255,254,254,255,255,252,251,254,254,254,254,255,253,253,254,254,254,254,252,254,255,254,254,253,254,255,255,255,254,255,254,254,253,253,255,173,193,
159,224,237,242,255,253,253,234,219,255,255,255,254,252,255,255,255,255,255,255,255,255,255,255,255,255,253,255,255,148,58,200,254,252,254,255,255,253,253,233,165,
160,226,237,234,245,252,255,213,74,85,139,224,255,255,253,255,210,197,228,227,234,222,123,162,255,251,255,210,88,36,166,250,254,255,254,253,253,254,255,253,170,
172,222,242,238,238,244,248,255,248,187,104,40,65,181,253,255,129,94,86,86,113,127,122,136,255,254,135,0,13,199,255,255,253,218,194,192,192,196,241,246,164,
187,195,203,188,189,188,223,244,241,206,141,31,36,179,254,255,138,171,192,189,186,185,182,138,255,254,173,86,63,24,51,170,239,174,172,174,175,166,207,207,180,
227,176,175,174,176,170,197,220,63,0,57,161,242,255,251,255,180,136,191,173,175,186,149,133,255,252,255,255,255,194,100,60,239,220,182,184,183,194,225,158,255,
255,209,176,188,183,183,210,221,136,183,244,249,236,249,254,254,236,78,143,182,178,183,68,171,254,251,253,250,253,255,253,239,243,252,254,255,254,242,172,193,255,
255,255,171,223,238,230,236,239,253,246,236,234,234,243,253,254,255,187,71,87,106,84,163,249,254,254,254,255,253,239,233,236,238,211,189,206,195,165,191,255,255,
255,255,212,154,217,244,242,237,233,235,236,236,236,236,239,242,241,250,250,215,213,232,255,242,249,249,249,246,239,235,237,235,239,174,184,192,196,255,255,255,255,
255,255,255,203,138,166,205,228,237,236,236,236,236,237,236,235,235,233,237,251,252,245,233,234,235,236,236,236,236,236,234,245,195,177,255,255,255,255,255,255,255,
255,255,255,255,255,171,160,151,218,239,234,239,241,235,236,237,237,237,236,233,231,235,239,241,241,236,235,235,235,236,246,216,154,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,177,194,251,245,202,193,246,236,235,236,235,236,240,245,241,205,163,212,240,246,245,245,235,201,156,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,151,190,181,145,155,192,235,240,241,241,239,218,189,162,164,203,166,168,178,176,176,160,166,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,203,205,255,255,181,165,185,186,187,173,165,176,211,255,255,255,255,201,202,203,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,213,172,172,170,193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

constant B_Board2: RGB_Board :=
(255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,242,240,240,238,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,242,238,238,238,237,239,228,236,239,233,234,254,254,254,255,248,234,240,245,236,241,241,244,245,243,244,241,237,233,234,249,255,255,255,255,255,
255,255,255,255,238,244,251,252,253,253,253,254,248,232,238,255,255,253,254,254,254,251,254,255,243,248,255,255,255,255,255,255,253,249,242,234,239,249,247,255,255,
255,255,255,238,252,255,254,255,255,255,255,254,255,254,250,254,254,254,255,254,255,255,254,254,255,255,255,254,254,254,254,254,254,255,255,251,242,242,243,237,255,
255,255,236,248,255,253,253,254,254,254,254,254,254,255,255,254,255,255,254,255,254,254,255,254,254,254,254,255,254,254,255,254,254,254,254,255,255,254,255,239,246,
255,243,240,255,254,254,254,255,255,255,255,255,255,254,254,255,255,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,255,255,255,254,253,254,255,237,247,
255,237,248,254,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,252,241,235,255,
238,240,251,253,254,253,255,254,253,254,255,254,255,255,255,255,255,255,255,255,254,255,254,254,255,254,254,254,254,252,252,254,255,254,254,254,254,254,243,233,255,
233,245,251,253,255,254,254,255,255,252,251,254,254,254,254,255,253,253,254,254,254,254,252,254,255,254,254,253,254,255,255,255,254,255,254,254,254,254,255,239,242,
237,247,250,251,254,253,254,234,219,255,255,255,254,252,255,255,255,255,255,255,255,255,255,255,254,255,253,255,255,148,58,200,254,252,254,255,255,254,254,250,237,
237,247,250,249,251,252,254,213,74,85,139,224,255,255,253,255,210,196,227,226,234,222,123,162,255,251,255,210,88,36,166,250,254,255,254,253,253,254,255,254,238,
238,249,253,252,252,253,254,255,247,187,104,40,64,181,253,255,131,105,94,93,123,139,137,141,254,254,135,0,13,199,255,255,253,226,208,207,206,210,243,254,237,
244,235,214,206,206,206,238,254,252,212,143,30,38,179,254,255,140,190,212,209,205,204,202,142,254,254,173,86,63,24,51,169,241,194,191,193,194,188,213,248,239,
254,209,189,193,193,188,215,231,68,0,61,171,253,255,252,255,180,149,210,191,192,204,165,134,255,252,255,255,255,194,101,63,238,228,199,201,200,207,238,237,255,
255,226,200,202,202,201,227,234,144,194,255,255,250,251,254,254,235,83,160,201,197,203,77,169,254,251,253,250,254,255,255,253,253,255,253,253,253,251,240,243,255,
255,255,235,244,246,245,251,254,255,255,250,248,249,251,254,253,255,185,72,94,115,88,163,249,253,253,254,254,253,248,248,250,250,245,242,245,243,238,242,255,255,
255,255,247,237,247,252,251,250,247,248,250,250,251,250,251,252,250,255,254,213,212,231,255,252,253,253,253,252,251,250,250,250,250,239,241,242,242,255,255,255,255,
255,255,255,243,233,238,245,248,250,250,250,251,250,251,250,250,250,248,250,255,255,255,247,250,250,251,250,250,250,250,249,252,243,239,255,255,255,255,255,255,255,
255,255,255,255,255,239,236,235,247,250,249,250,251,250,250,251,251,251,250,248,248,249,251,251,251,250,250,250,250,250,252,246,235,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,239,243,252,251,244,242,252,250,250,250,250,250,251,251,251,244,237,246,250,252,251,251,250,244,236,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,235,242,240,234,236,242,250,251,251,251,251,247,242,237,237,244,238,238,240,240,240,237,237,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,245,245,255,255,240,238,241,241,241,239,238,240,246,255,255,255,255,244,245,244,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,247,238,239,238,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);


constant board2_pix: std_logic_vector(0 to 942) :=
(
'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','0','1','1','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0'
);

  
    
    ------------------items!!!!!---------------
constant item_pix: std_logic_vector(0 to 399) :=
(
'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0',
'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0'
);

constant item_ball_pix: std_logic_vector(0 to 399) :=
(
'0','0','0','0','0','0','0','0','0','0','1','1','1','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0',
'0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0',
'0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0',
'0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0',
'0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0',
'0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','1','1','1','0','1','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','1','1','0','0','0','0','0','0','0','0','0','0'
);                                                                           
 
 constant scorenum: std_logic_vector(0 to 3999) :=
(
'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0',
'0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0',
'0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0',
'0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','0','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','1','1','1','0','0','0',
'0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','0','0','0','0','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','0','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','0','0','0','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','1','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','0','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','0','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','1','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','0','0','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','1','1','1','1','0','0','1','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','1','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','1','1','1','0','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','1','1','1','1','0','0','0','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','0','0','1','1','1','0','0','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','0','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','0','0','0','0','0','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','0','0','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0',
'0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0','0','0','0','0','0','0','0','1','1','1','1','1','1','1','1','1','0','0','0','0','0',
'0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0'
);
 

 type RGB_item is array (0 to 399) of
       integer;  
  constant R_lifeplus: RGB_item :=
  (255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,245,217,189,208,217,245,255,255,255,255,255,255,
255,255,255,255,255,208,133,105,105,133,105,105,105,123,226,255,255,255,255,255,
255,255,255,236,114,114,161,208,255,255,255,255,217,161,105,170,255,255,255,255,
255,255,245,133,133,255,255,255,255,255,255,255,255,255,189,114,161,255,255,255,
255,255,180,114,255,255,239,239,247,255,255,255,255,255,255,226,114,189,255,255,
255,255,114,198,247,196,193,193,196,243,255,231,212,208,216,255,198,105,236,255,
255,217,123,255,204,224,251,255,235,208,220,220,235,239,220,231,255,114,180,255,
255,180,170,239,208,255,255,255,255,227,251,255,255,255,239,216,255,161,151,255,
255,161,198,239,208,255,255,255,255,255,255,255,255,255,239,208,255,198,142,255,
255,142,217,255,196,251,255,255,255,255,255,255,255,255,239,224,255,217,142,255,
255,142,208,255,208,216,255,255,255,255,255,255,255,255,216,231,255,217,142,255,
255,180,170,255,247,196,212,247,255,255,255,255,255,231,196,251,255,180,161,255,
255,217,123,255,255,247,200,196,224,251,255,255,231,193,231,255,255,123,189,255,
255,255,114,180,255,255,251,216,193,196,231,224,193,231,255,255,189,105,245,255,
255,255,217,114,198,255,255,255,251,227,204,212,243,255,255,198,105,161,255,255,
255,255,255,198,114,151,245,255,255,255,255,255,255,245,180,105,151,245,255,255,
255,255,255,255,236,151,114,180,217,217,217,189,180,123,114,198,255,255,255,255,
255,255,255,255,255,255,217,161,142,114,105,105,114,161,236,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

  constant G_lifeplus: RGB_item :=
 (255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,249,233,217,228,233,249,255,255,255,255,255,255,
255,255,255,255,255,228,185,170,170,185,170,170,170,180,239,255,255,255,255,255,
255,255,255,244,175,175,201,228,255,255,255,255,233,201,170,207,255,255,255,255,
255,255,249,185,185,255,255,255,255,255,255,255,255,255,217,175,201,255,255,255,
255,255,212,175,255,255,216,216,235,255,255,255,255,255,255,239,175,217,255,255,
255,255,175,223,235,109,100,100,109,225,255,196,148,138,158,255,223,170,244,255,
255,233,180,255,129,115,129,131,121,138,167,113,121,123,113,196,255,175,212,255,
255,212,207,216,107,131,131,131,131,117,129,131,131,131,123,158,255,201,196,255,
255,201,223,216,107,131,131,131,131,131,131,131,131,131,123,138,255,223,191,255,
255,191,233,255,101,129,131,131,131,131,131,131,131,131,123,177,255,233,191,255,
255,191,228,255,138,111,131,131,131,131,131,131,131,131,111,196,255,233,191,255,
255,212,207,255,235,109,109,127,131,131,131,131,131,119,109,245,255,212,201,255,
255,233,180,255,255,235,119,101,115,129,131,131,119,100,196,255,255,180,217,255,
255,255,175,212,255,255,245,158,100,101,119,115,100,196,255,255,217,170,249,255,
255,255,233,175,223,255,255,255,245,187,129,148,225,255,255,223,170,201,255,255,
255,255,255,223,175,196,249,255,255,255,255,255,255,249,212,170,196,249,255,255,
255,255,255,255,244,196,175,212,233,233,233,217,212,180,175,223,255,255,255,255,
255,255,255,255,255,255,233,201,191,175,170,170,175,201,244,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

  constant B_lifeplus: RGB_item :=
  (255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,254,251,248,250,251,254,255,255,255,255,255,255,
255,255,255,255,255,250,243,241,241,243,241,241,241,242,252,255,255,255,255,255,
255,255,255,253,241,241,246,250,255,255,255,255,251,246,241,247,255,255,255,255,
255,255,254,243,243,255,255,255,255,255,255,255,255,255,248,241,246,255,255,255,
255,255,248,241,255,255,216,216,235,255,255,255,255,255,255,252,241,248,255,255,
255,255,241,249,235,109,100,100,109,225,255,196,148,138,158,255,249,241,253,255,
255,251,242,255,129,100,100,100,100,138,167,100,100,100,100,196,255,241,248,255,
255,248,247,216,100,100,100,100,100,100,100,100,100,100,100,158,255,246,245,255,
255,246,249,216,100,100,100,100,100,100,100,100,100,100,100,138,255,249,244,255,
255,244,251,255,100,100,100,100,100,100,100,100,100,100,100,177,255,251,244,255,
255,244,250,255,138,100,100,100,100,100,100,100,100,100,100,196,255,251,244,255,
255,248,247,255,235,109,100,100,100,100,100,100,100,100,109,245,255,248,246,255,
255,251,242,255,255,235,119,100,100,100,100,100,100,100,196,255,255,242,248,255,
255,255,241,248,255,255,245,158,100,100,100,100,100,196,255,255,248,241,254,255,
255,255,251,241,249,255,255,255,245,187,129,148,225,255,255,249,241,246,255,255,
255,255,255,249,241,245,254,255,255,255,255,255,255,254,248,241,245,254,255,255,
255,255,255,255,253,245,241,248,251,251,251,248,248,242,241,249,255,255,255,255,
255,255,255,255,255,255,251,246,244,241,241,241,241,246,253,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);


  constant R_lifeminus: RGB_item :=
  (255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,245,217,189,208,217,245,255,255,255,255,255,255,
255,255,255,255,255,208,133,105,105,133,105,105,105,123,226,255,255,255,255,255,
255,255,255,236,114,114,161,208,255,255,255,255,217,161,105,170,255,255,255,255,
255,255,245,133,133,255,255,255,255,255,255,255,255,255,189,114,161,255,255,255,
255,255,180,114,255,255,216,216,235,255,255,255,255,255,255,226,114,189,255,255,
255,255,114,198,235,109,100,100,109,225,255,196,148,138,158,255,198,105,236,255,
255,217,123,255,129,100,100,100,100,138,167,100,100,100,100,196,255,114,180,255,
255,180,170,216,100,100,100,100,100,100,100,100,100,100,100,158,255,161,151,255,
255,161,198,216,100,100,100,100,100,100,100,100,100,100,100,138,255,198,142,255,
255,142,217,255,100,100,100,100,100,100,100,100,100,100,100,177,255,217,142,255,
255,142,208,255,138,100,100,100,100,100,100,100,100,100,100,196,255,217,142,255,
255,180,170,255,247,109,100,100,100,100,100,100,100,100,109,251,255,180,161,255,
255,217,123,255,255,235,119,100,100,100,100,100,100,100,196,255,255,123,189,255,
255,255,114,180,255,255,251,158,100,100,100,100,100,196,255,255,189,105,245,255,
255,255,217,114,198,255,255,255,251,187,129,148,225,255,255,198,105,161,255,255,
255,255,255,198,114,151,245,255,255,255,255,255,255,245,180,105,151,245,255,255,
255,255,255,255,236,151,114,180,217,217,217,189,180,123,114,198,255,255,255,255,
255,255,255,255,255,255,217,161,142,114,105,105,114,161,236,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

  constant G_lifeminus: RGB_item :=
(255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,249,233,217,228,233,249,255,255,255,255,255,255,
255,255,255,255,255,228,185,170,170,185,170,170,170,180,239,255,255,255,255,255,
255,255,255,244,175,175,201,228,255,255,255,255,233,201,170,207,255,255,255,255,
255,255,249,185,185,255,255,255,255,255,255,255,255,255,217,175,201,255,255,255,
255,255,212,175,255,255,216,216,235,255,255,255,255,255,255,239,175,217,255,255,
255,255,175,223,235,109,100,100,109,225,255,196,148,138,158,255,223,170,244,255,
255,233,180,255,129,100,100,100,100,138,167,100,100,100,100,196,255,175,212,255,
255,212,207,216,100,100,100,100,100,100,100,100,100,100,100,158,255,201,196,255,
255,201,223,216,100,100,100,100,100,100,100,100,100,100,100,138,255,223,191,255,
255,191,233,255,100,100,100,100,100,100,100,100,100,100,100,177,255,233,191,255,
255,191,228,255,138,100,100,100,100,100,100,100,100,100,100,196,255,233,191,255,
255,212,207,255,235,109,100,100,100,100,100,100,100,100,109,245,255,212,201,255,
255,233,180,255,255,235,119,100,100,100,100,100,100,100,196,255,255,180,217,255,
255,255,175,212,255,255,245,158,100,100,100,100,100,196,255,255,217,170,249,255,
255,255,233,175,223,255,255,255,245,187,129,148,225,255,255,223,170,201,255,255,
255,255,255,223,175,196,249,255,255,255,255,255,255,249,212,170,196,249,255,255,
255,255,255,255,244,196,175,212,233,233,233,217,212,180,175,223,255,255,255,255,
255,255,255,255,255,255,233,201,191,175,170,170,175,201,244,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

  constant B_lifeminus: RGB_item :=
  (255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,254,251,248,250,251,254,255,255,255,255,255,255,
255,255,255,255,255,250,243,241,241,243,241,241,241,242,252,255,255,255,255,255,
255,255,255,253,241,241,246,250,255,255,255,255,251,246,241,247,255,255,255,255,
255,255,254,243,243,255,255,255,255,255,255,255,255,255,248,241,246,255,255,255,
255,255,248,241,255,255,216,216,235,255,255,255,255,255,255,252,241,248,255,255,
255,255,241,249,235,109,100,100,109,225,255,196,148,138,158,255,249,241,253,255,
255,251,242,255,129,100,100,100,100,138,167,100,100,100,100,196,255,241,248,255,
255,248,247,216,100,100,100,100,100,100,100,100,100,100,100,158,255,246,245,255,
255,246,249,216,100,100,100,100,100,100,100,100,100,100,100,138,255,249,244,255,
255,244,251,255,100,100,100,100,100,100,100,100,100,100,100,177,255,251,244,255,
255,244,250,255,138,100,100,100,100,100,100,100,100,100,100,196,255,251,244,255,
255,248,247,255,235,109,100,100,100,100,100,100,100,100,109,245,255,248,246,255,
255,251,242,255,255,235,119,100,100,100,100,100,100,100,196,255,255,242,248,255,
255,255,241,248,255,255,245,158,100,100,100,100,100,196,255,255,248,241,254,255,
255,255,251,241,249,255,255,255,245,187,129,148,225,255,255,249,241,246,255,255,
255,255,255,249,241,245,254,255,255,255,255,255,255,254,248,241,245,254,255,255,
255,255,255,255,253,245,241,248,251,251,251,248,248,242,241,249,255,255,255,255,
255,255,255,255,255,255,251,246,244,241,241,241,241,246,253,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

  constant R_speedplus: RGB_item :=
 (255,255,255,255,255,255,255,255,255,255,217,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,226,189,142,123,105,105,105,123,217,255,255,255,255,255,255,
255,255,255,255,189,105,133,161,189,255,255,255,161,114,142,236,255,255,255,255,
255,255,255,161,133,236,255,255,255,218,218,218,255,255,133,114,226,255,255,255,
255,255,180,114,245,255,255,181,135,172,181,181,163,108,236,161,123,245,255,255,
255,245,114,217,255,255,144,190,255,255,255,255,218,135,255,255,123,161,255,255,
255,189,142,255,255,209,181,255,255,237,255,255,153,181,255,255,198,105,236,255,
255,151,198,255,255,126,255,255,255,237,255,218,108,190,255,255,255,105,198,255,
255,133,226,255,209,153,255,237,237,237,237,237,126,108,117,227,255,142,180,255,
255,105,255,255,181,181,255,255,255,237,255,255,255,218,172,144,255,180,180,255,
255,105,255,255,181,181,255,218,135,237,255,255,255,245,181,163,255,180,180,255,
255,133,217,255,181,172,255,255,108,218,255,255,218,117,153,236,255,151,180,255,
255,170,170,255,209,117,245,245,108,236,255,255,255,153,190,255,255,105,217,255,
255,208,114,245,255,135,135,135,172,255,153,172,255,153,209,255,170,123,255,255,
255,255,142,142,255,255,255,255,255,255,199,108,117,199,255,198,105,180,255,255,
255,255,245,114,142,236,255,255,255,255,255,255,255,255,198,105,142,245,255,255,
255,255,255,236,142,105,180,226,255,255,255,255,217,161,105,161,255,255,255,255,
255,255,255,255,255,208,123,105,105,105,105,105,105,142,217,255,255,255,255,255,
255,255,255,255,255,255,255,245,217,217,217,217,236,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

  constant G_speedplus: RGB_item :=
(255,255,255,255,255,255,255,255,255,255,233,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,239,217,191,180,170,170,170,180,233,255,255,255,255,255,255,
255,255,255,255,217,170,185,201,217,255,255,255,201,175,191,244,255,255,255,255,
255,255,255,201,185,244,255,255,255,228,228,228,255,255,185,175,239,255,255,255,
255,255,212,175,249,255,255,202,168,195,202,202,188,149,241,201,180,249,255,255,
255,249,175,233,255,255,175,208,255,255,255,255,228,168,255,255,180,201,255,255,
255,217,191,255,255,221,202,255,255,28,255,255,182,202,255,255,223,170,244,255,
255,196,223,255,255,162,255,255,255,28,255,228,149,208,255,255,255,170,223,255,
255,185,239,255,221,182,255,28,28,28,28,28,162,149,155,235,255,191,212,255,
255,170,255,255,202,202,255,255,255,28,255,255,255,228,195,175,255,212,212,255,
255,170,255,255,202,202,255,228,168,28,255,255,255,248,202,188,255,212,212,255,
255,185,233,255,202,195,255,255,149,228,255,255,228,155,182,241,255,196,212,255,
255,207,207,255,221,155,248,248,149,241,255,255,255,182,208,255,255,170,233,255,
255,228,175,249,255,168,168,168,195,255,182,195,255,182,221,255,207,180,255,255,
255,255,191,191,255,255,255,255,255,255,215,149,155,215,255,223,170,212,255,255,
255,255,249,175,191,244,255,255,255,255,255,255,255,255,223,170,191,249,255,255,
255,255,255,244,191,170,212,239,255,255,255,255,233,201,170,201,255,255,255,255,
255,255,255,255,255,228,180,170,170,170,170,170,170,191,233,255,255,255,255,255,
255,255,255,255,255,255,255,249,233,233,233,233,244,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

  constant B_speedplus: RGB_item :=
  (255,255,255,255,255,255,255,255,255,255,251,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,252,248,244,242,241,241,241,242,251,255,255,255,255,255,255,
255,255,255,255,248,241,243,246,248,255,255,255,246,241,244,253,255,255,255,255,
255,255,255,246,243,253,255,255,255,239,239,239,255,255,243,241,252,255,255,255,
255,255,248,241,254,255,255,224,204,220,224,224,216,193,247,246,242,254,255,255,
255,254,241,251,255,255,208,227,255,255,255,255,239,204,255,255,242,246,255,255,
255,248,244,255,255,235,224,255,255,36,255,255,212,224,255,255,249,241,253,255,
255,245,249,255,255,200,255,255,255,36,255,239,193,227,255,255,255,241,249,255,
255,243,252,255,235,212,255,36,36,36,36,36,200,193,196,243,255,244,248,255,
255,241,255,255,224,224,255,255,255,36,255,255,255,239,220,208,255,248,248,255,
255,241,255,255,224,224,255,239,204,36,255,255,255,251,224,216,255,248,248,255,
255,243,251,255,224,220,255,255,193,239,255,255,239,196,212,247,255,245,248,255,
255,247,247,255,235,196,251,251,193,247,255,255,255,212,227,255,255,241,251,255,
255,250,241,254,255,204,204,204,220,255,212,220,255,212,235,255,247,242,255,255,
255,255,244,244,255,255,255,255,255,255,231,193,196,231,255,249,241,248,255,255,
255,255,254,241,244,253,255,255,255,255,255,255,255,255,249,241,244,254,255,255,
255,255,255,253,244,241,248,252,255,255,255,255,251,246,241,246,255,255,255,255,
255,255,255,255,255,250,242,241,241,241,241,241,241,244,251,255,255,255,255,255,
255,255,255,255,255,255,255,254,251,251,251,251,253,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);


  constant R_speedminus: RGB_item :=
  (255,255,255,255,255,255,255,255,255,255,217,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,226,189,142,123,105,105,105,123,217,255,255,255,255,255,255,
255,255,255,255,189,105,133,161,189,255,255,255,161,114,142,236,255,255,255,255,
255,255,255,161,133,236,255,255,255,218,218,218,255,255,133,114,226,255,255,255,
255,255,180,114,245,255,255,181,135,172,181,181,163,108,236,161,123,245,255,255,
255,245,114,217,255,255,144,190,255,255,255,255,218,135,255,255,123,161,255,255,
255,189,142,255,255,209,181,255,255,255,255,255,153,181,255,255,198,105,236,255,
255,151,198,255,255,126,255,255,255,255,255,218,108,190,255,255,255,105,198,255,
255,133,226,255,209,153,255,0,0,0,0,209,126,108,117,227,255,142,180,255,
255,105,255,255,181,181,255,255,255,255,255,255,255,218,172,144,255,180,180,255,
255,105,255,255,181,181,255,218,135,218,255,255,255,245,181,163,255,180,180,255,
255,133,217,255,181,172,255,255,108,218,255,255,218,117,153,236,255,151,180,255,
255,170,170,255,209,117,245,245,108,236,255,255,255,153,190,255,255,105,217,255,
255,208,114,245,255,135,135,135,172,255,153,172,255,153,209,255,170,123,255,255,
255,255,142,142,255,255,255,255,255,255,199,108,117,199,255,198,105,180,255,255,
255,255,245,114,142,236,255,255,255,255,255,255,255,255,198,105,142,245,255,255,
255,255,255,236,142,105,180,226,255,255,255,255,217,161,105,161,255,255,255,255,
255,255,255,255,255,208,123,105,105,105,105,105,105,142,217,255,255,255,255,255,
255,255,255,255,255,255,255,245,217,217,217,217,236,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);
  
  constant G_speedminus: RGB_item :=
 (255,255,255,255,255,255,255,255,255,255,233,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,239,217,191,180,170,170,170,180,233,255,255,255,255,255,255,
255,255,255,255,217,170,185,201,217,255,255,255,201,175,191,244,255,255,255,255,
255,255,255,201,185,244,255,255,255,228,228,228,255,255,185,175,239,255,255,255,
255,255,212,175,249,255,255,202,168,195,202,202,188,149,241,201,180,249,255,255,
255,249,175,233,255,255,175,208,255,255,255,255,228,168,255,255,180,201,255,255,
255,217,191,255,255,221,202,255,255,255,255,255,182,202,255,255,223,170,244,255,
255,196,223,255,255,162,255,255,255,255,255,228,149,208,255,255,255,170,223,255,
255,185,239,255,221,182,255,0,0,0,0,221,162,149,155,235,255,191,212,255,
255,170,255,255,202,202,255,255,255,255,255,255,255,228,195,175,255,212,212,255,
255,170,255,255,202,202,255,228,168,228,255,255,255,248,202,188,255,212,212,255,
255,185,233,255,202,195,255,255,149,228,255,255,228,155,182,241,255,196,212,255,
255,207,207,255,221,155,248,248,149,241,255,255,255,182,208,255,255,170,233,255,
255,228,175,249,255,168,168,168,195,255,182,195,255,182,221,255,207,180,255,255,
255,255,191,191,255,255,255,255,255,255,215,149,155,215,255,223,170,212,255,255,
255,255,249,175,191,244,255,255,255,255,255,255,255,255,223,170,191,249,255,255,
255,255,255,244,191,170,212,239,255,255,255,255,233,201,170,201,255,255,255,255,
255,255,255,255,255,228,180,170,170,170,170,170,170,191,233,255,255,255,255,255,
255,255,255,255,255,255,255,249,233,233,233,233,244,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);
 
  constant B_speedminus: RGB_item :=
(255,255,255,255,255,255,255,255,255,255,251,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,252,248,244,242,241,241,241,242,251,255,255,255,255,255,255,
255,255,255,255,248,241,243,246,248,255,255,255,246,241,244,253,255,255,255,255,
255,255,255,246,243,253,255,255,255,239,239,239,255,255,243,241,252,255,255,255,
255,255,248,241,254,255,255,224,204,220,224,224,216,193,247,246,242,254,255,255,
255,254,241,251,255,255,208,227,255,255,255,255,239,204,255,255,242,246,255,255,
255,248,244,255,255,235,224,255,255,255,255,255,212,224,255,255,249,241,253,255,
255,245,249,255,255,200,255,255,255,255,255,239,193,227,255,255,255,241,249,255,
255,243,252,255,235,212,255,0,0,0,0,235,200,193,196,243,255,244,248,255,
255,241,255,255,224,224,255,255,255,255,255,255,255,239,220,208,255,248,248,255,
255,241,255,255,224,224,255,239,204,239,255,255,255,251,224,216,255,248,248,255,
255,243,251,255,224,220,255,255,193,239,255,255,239,196,212,247,255,245,248,255,
255,247,247,255,235,196,251,251,193,247,255,255,255,212,227,255,255,241,251,255,
255,250,241,254,255,204,204,204,220,255,212,220,255,212,235,255,247,242,255,255,
255,255,244,244,255,255,255,255,255,255,231,193,196,231,255,249,241,248,255,255,
255,255,254,241,244,253,255,255,255,255,255,255,255,255,249,241,244,254,255,255,
255,255,255,253,244,241,248,252,255,255,255,255,251,246,241,246,255,255,255,255,
255,255,255,255,255,250,242,241,241,241,241,241,241,244,251,255,255,255,255,255,
255,255,255,255,255,255,255,254,251,251,251,251,253,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255);

  constant R_superball: RGB_item :=
  (255,255,255,255,255,255,255,255,255,255,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,224,224,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,255,255,224,224,224,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,255,224,224,224,224,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,224,224,224,224,224,224,224,224,224,224,224,255,255,255,255,255,
255,255,255,224,224,224,224,224,224,224,224,224,224,224,224,224,255,255,255,255,
255,255,255,224,224,0,64,192,224,224,224,224,224,96,128,224,224,255,255,255,
255,255,255,224,224,224,160,64,224,192,192,192,64,128,224,224,224,255,255,255,
255,255,255,224,224,64,192,224,128,224,224,224,224,96,64,224,224,255,255,255,
255,255,255,224,224,224,224,224,192,128,128,96,224,224,224,224,224,255,255,255,
255,255,255,255,224,224,224,224,224,224,224,224,224,224,224,224,255,255,255,255,
255,255,255,255,255,224,224,224,224,224,224,224,224,224,224,224,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,224,224,224,224,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,224,224,224,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,224,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,255,255,255,255,255,255,255,255,255,255);
  
  constant G_superball: RGB_item :=
(255,255,255,255,255,255,255,255,255,255,224,224,224,255,255,255,255,255,255,255,  
255,255,255,255,255,255,255,255,255,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,255,255,251,224,224,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,255,255,224,224,224,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,255,224,224,224,224,224,224,224,224,255,255,255,255,255,255,255,
255,255,255,255,224,224,224,224,224,224,224,224,224,224,224,255,255,255,255,255,
255,255,255,224,224,224,224,224,224,224,224,224,224,224,224,224,251,255,255,255,
255,255,255,224,224,0,64,192,224,224,224,224,224,96,128,224,192,255,255,255,
255,255,255,224,224,224,160,64,224,192,192,192,32,128,224,224,224,255,255,255,
255,255,255,224,224,64,192,224,96,160,160,160,192,96,32,224,224,255,255,255,
255,255,255,224,224,224,224,224,160,96,96,64,224,224,224,224,224,255,255,255,
255,255,255,251,224,224,224,224,224,224,224,224,224,224,224,224,255,255,255,255,
255,255,255,255,255,224,192,192,224,224,224,224,224,224,224,224,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,224,224,224,224,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,224,224,224,251,255,255,255,255,255,
255,255,255,255,255,255,255,251,224,224,224,224,224,251,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,224,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,224,255,251,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,224,224,255,255,255,255,255,255,255,255,255,255);

  constant B_superball: RGB_item :=
 (255,255,255,255,255,255,255,255,255,255,64,64,64,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,64,64,64,64,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,64,128,128,128,64,255,255,255,255,255,255,255,
255,255,255,255,255,255,240,64,128,128,128,128,64,255,255,255,255,255,255,255,
255,255,255,255,255,255,64,128,128,128,128,128,64,255,255,255,255,255,255,255,
255,255,255,255,255,64,128,128,128,128,128,128,64,255,255,255,255,255,255,255,
255,255,255,255,64,128,128,128,128,128,128,128,64,64,64,255,255,255,255,255,
255,255,255,64,128,128,128,128,128,128,128,128,128,128,128,64,240,255,255,255,
255,255,255,64,128,0,64,128,128,128,128,128,128,64,64,128,0,255,255,255,
255,255,255,64,128,128,128,64,128,128,128,128,0,64,128,128,64,255,255,255,
255,255,255,64,128,64,128,128,64,192,192,192,128,64,0,128,64,255,255,255,
255,255,255,64,128,128,128,128,128,64,64,64,128,128,128,128,64,255,255,255,
255,255,255,240,64,128,128,128,128,128,128,128,128,128,128,64,255,255,255,255,
255,255,255,255,255,64,0,0,128,128,128,128,128,128,128,64,255,255,255,255,
255,255,255,255,255,255,255,255,64,128,128,128,128,128,0,255,255,255,255,255,
255,255,255,255,255,255,255,255,64,128,128,128,128,64,240,255,255,255,255,255,
255,255,255,255,255,255,255,240,64,128,128,128,0,240,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,64,128,128,0,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,0,64,0,255,240,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255);

 ---------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------

 ---------------------------------------new color maps----------------------------------------------------------------- 
 type colormap_opening is array (0 to 102) of
       integer;  
  constant R_map_opening: colormap_opening :=
  (166,96,96,128,255,255,128,192,64,0,128,192,32,96,160,96,96,64,160,64,224,128,64,160,64,96,192,192,160,96,128,160,160,224,128,128,96,192,160,64,96,192,160,32,224,96,
  96,128,160,0,128,128,128,224,192,192,128,192,224,224,192,224,224,224,160,64,192,96,128,160,224,192,224,128,192,160,160,224,0,32,64,192,224,192,160,224,224,224,96,224,
  224,192,64,255,192,160,128,64,32,64,32,128,160);

  constant G_map_opening: colormap_opening :=
  (202,160,128,160,255,251,192,192,64,0,128,220,32,96,160,96,128,96,192,128,160,64,64,96,96,64,128,160,128,96,96,128,0,0,0,96,64,0,32,32,32,32,32,64,32,32,0,128,96,32,
  0,32,96,192,160,128,64,32,96,128,96,160,224,224,64,32,192,64,96,128,32,160,192,32,128,128,160,160,0,0,64,192,192,160,96,64,160,96,96,64,224,64,64,0,96,64,64,128,160,
  160,96,128,160);

  constant B_map_opening: colormap_opening :=
  (240,192,192,192,255,240,192,192,64,0,128,192,64,64,164,128,128,64,192,192,192,192,192,192,192,192,192,192,192,192,192,128,64,64,0,128,64,64,64,0,64,0,0,64,0,0,64,192,
  128,64,64,64,64,0,0,0,0,64,128,128,128,0,64,0,0,64,128,0,0,0,64,128,128,0,128,64,128,128,64,64,128,64,64,64,64,64,64,64,0,0,128,0,0,0,64,64,64,128,192,192,128,64,192);
  
  
  type colormap_over1 is array (0 to 48) of
       integer;  
  constant R_map_over1: colormap_over1 :=
  (0,64,160,128,255,192,255,32,128,192,64,96,160,64,64,64,96,64,32,160,0,32,128,166,96,0,96,96,160,128,96,32,160,128,128,64,64,160,224,192,96,192,192,128,224,96,96,64,128);
  
  constant G_map_over1: colormap_over1 :=
  (0,64,160,128,255,192,251,32,160,220,32,96,160,64,96,96,128,128,64,160,32,64,160,202,128,0,96,160,192,192,96,96,128,96,128,96,32,96,160,128,64,128,160,96,128,64,160,128,64);
	 
  constant B_map_over1: colormap_over1 :=
  (0,64,128,128,255,192,240,64,128,192,0,128,164,128,128,192,192,192,128,192,64,64,192,240,128,64,192,192,192,192,64,128,128,128,192,64,64,128,192,192,64,128,192,64,192,128,128,128,64);
  
  
  type colormap_over2 is array (0 to 40) of
       integer;  
  constant R_map_over2: colormap_over2 :=
  (0,32,64,64,0,0,32,32,64,96,64,160,128,255,255,192,160,32,166,96,128,160,128,192,0,128,96,64,96,32,0,0,96,64,64,32,128,0,0,32,32);
  
  constant G_map_over2: colormap_over2 :=
  (0,32,32,96,0,32,64,64,64,96,64,160,160,251,255,192,160,32,202,128,128,192,160,220,32,192,160,128,128,96,64,64,96,128,96,96,128,96,96,128,64);

  
  constant B_map_over2: colormap_over2 :=
  (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

  
  ---------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  ------------------------change of ball and brick---------------------------------------------------------------------------------------------
  -- constant transfer: std_logic_vector(0 to 19) := ('0','0','0','1','0','0','0','1','0','0','1','1','0','0','1','1','0','1','1','1');
  --	signal change_timer:unsigned(31 downto 0) := "00000000000000000000000000000000";
  ---------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
 
  
  
  
--  constant RECTANGLE_HSTART : integer := x-15; 
--  constant RECTANGLE_HEND   : integer := x+14; 
--  constant RECTANGLE_VSTART : integer := y-14; 
--  constant RECTANGLE_VEND   : integer := y+15; 
 
    signal RECTANGLE_HSTART : unsigned(15 downto 0); 
    signal RECTANGLE_HEND   : unsigned(15 downto 0); 
    signal RECTANGLE_VSTART : unsigned(15 downto 0); 
    signal RECTANGLE_VEND   : unsigned(15 downto 0);
	 
	 signal RECTANGLE_HSTART_board : unsigned(15 downto 0);    ----to draw the board
    signal RECTANGLE_HEND_board   : unsigned(15 downto 0); 
    signal RECTANGLE_VSTART_board : unsigned(15 downto 0); 
    signal RECTANGLE_VEND_board   : unsigned(15 downto 0);
	 
	 
	 signal RECTANGLE_HSTART_brick1 : unsigned(15 downto 0);    ----to draw the board
    signal RECTANGLE_HEND_brick1   : unsigned(15 downto 0); 
    signal RECTANGLE_VSTART_brick1 : unsigned(15 downto 0); 
    signal RECTANGLE_VEND_brick1   : unsigned(15 downto 0);
	 
	 signal bg_change : std_logic_vector(9 downto 0);
	 signal brick_change : unsigned(15 downto 0);
	 signal timer: unsigned(31 downto 0);
	 signal brick_choose: std_logic;
	 
    signal count_H: unsigned(15 downto 0); --- use to draw brick arrays
    signal count_V: unsigned(15 downto 0);
-----------------------------ram-----------------------------------
type ram_type is array(23 downto 0) of             -- 24 byte ram type
             std_logic_vector(15 downto 0);
signal RAM: ram_type :=(others=>("0000000110000000"));
signal ram_address: unsigned(3 downto 0);
signal RAM_drop: ram_type :=(others=>("0000000010101001"));   -------define a new ram only for the drop item


signal x: unsigned(15 downto 0); --------coordinate of circle
signal y: unsigned(15 downto 0); --------coordinate of circle
signal x_board: unsigned(15 downto 0); --------coordinate of board

signal brick_x: unsigned(15 downto 0); --- coordination of bricks
signal brick_y: unsigned(15 downto 0);


----------------------------signal for drop-------------------------
signal x_drop: unsigned(15 downto 0);
signal y_drop: unsigned(15 downto 0);
signal y_drop_temp: unsigned(15 downto 0);

signal bricknumber_x: std_logic_vector(3 downto 0); --- eliminate number of bricks --0 to 15
signal bricknumber_y: std_logic_vector(3 downto 0); 

signal count_drop:unsigned(15 downto 0);
signal drop_enable: std_logic := '0';
signal drop_temp: std_logic_vector(15 downto 0);  

signal reveal_en0 :std_logic;
signal reveal_en1 :std_logic;
signal reveal_en2 :std_logic;
signal reveal_en3 :std_logic;
signal reveal_en4 :std_logic;

---------------------------------signal for boardchange----------------------------------
signal count_board:unsigned(23 downto 0);
signal flag_board:std_logic;

-------------------------------------------------------------------

 -- Signals for the video controller
 
  signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
  signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
  signal EndOfLine, EndOfField : std_logic;

  signal vga_hblank, vga_hsync,
    vga_vblank, vga_vsync : std_logic;  -- Sync. signals

  signal rectangle_h, rectangle_v, rectangle, circle : std_logic;  -- rectangle area    circle board and brick signal
  signal rectangle_h_board, rectangle_v_board, rectangle_board, board : std_logic;
  signal rectangle_h_brick1, rectangle_v_brick1, rectangle_brick1, brick1 : std_logic;
  signal temp : std_logic_vector(7 downto 0);
  signal temp_board : std_logic_vector(40 downto 0);

  signal feedback : std_logic ;       ---for random num generator
  signal lfsr_reg : std_logic_vector(128 - 1 downto 0) ;
  signal feedback2 : std_logic ;       ---for random num generator
  signal lfsr_reg2 : std_logic_vector(128 - 1 downto 0) ;
  signal feedback3 : std_logic ;       ---for random num generator
  signal lfsr_reg3 : std_logic_vector(128 - 1 downto 0) ;
  signal random_temp : std_logic_vector(128 - 1 downto 0) ;
  signal random_temp2 : std_logic_vector(128 - 1 downto 0) ;
  signal random_temp3 : std_logic_vector(128 - 1 downto 0) ;
  signal random_temp4 : std_logic_vector(128 - 1 downto 0) ;
  
  signal feedback4 : std_logic ;       ---random num generator for drop
  signal lfsr_reg4 : std_logic_vector(7 downto 0) ;
  signal item_type : unsigned(7 downto 0) ; 
  
  
  signal brick_line :unsigned(3 downto 0) := to_unsigned(0,4);
  signal brick_layout: std_logic_vector(0 to 127); ---bricklayout= 16*8

  signal sram_label: std_logic := '1';
  
  
  
   ----------------new signals ----------------------------------
  --------------------------------------------------------------
  --------------------------------------------------------------
  signal state : unsigned(15 downto 0) := "1111111111111111";   ------------0 opening; 1111111111111111 ending; others gaming
  
  -------------------signal to draw the opening-----------------
  signal RECTANGLE_HSTART_opening : unsigned(15 downto 0);    ----to draw the opening
  signal RECTANGLE_HEND_opening   : unsigned(15 downto 0); 
  signal RECTANGLE_VSTART_opening : unsigned(15 downto 0); 
  signal RECTANGLE_VEND_opening   : unsigned(15 downto 0);
  
  signal rectangle_h_opening, rectangle_v_opening, rectangle_opening : std_logic;
  
  signal random_x :unsigned(15 downto 0) := "0000000101000000";  ------center of opening  320
  signal random_y :unsigned(15 downto 0) := "0000000011110000";  ---------------240

  signal counter_opening :std_logic_vector(15 downto 0) := "0000000000000000";
  signal mode: unsigned(15 downto 0) := "0000000000000000";
  signal difficulty: unsigned(15 downto 0) := "0000000000000000";
  signal difficulty_temp: unsigned(15 downto 0) := "0000000000000000";
  
    -------------------signal to draw the ending-----------------
  signal RECTANGLE_HSTART_over : unsigned(15 downto 0);    ----to draw the opening
  signal RECTANGLE_HEND_over   : unsigned(15 downto 0); 
  signal RECTANGLE_VSTART_over : unsigned(15 downto 0); 
  signal RECTANGLE_VEND_over   : unsigned(15 downto 0);
  
  signal rectangle_h_over, rectangle_v_over, rectangle_over : std_logic;
  
  
  signal RECTANGLE_HSTART_over2 : unsigned(15 downto 0);    ----to draw the opening
  signal RECTANGLE_HEND_over2   : unsigned(15 downto 0); 
  signal RECTANGLE_VSTART_over2 : unsigned(15 downto 0); 
  signal RECTANGLE_VEND_over2   : unsigned(15 downto 0);
  
  signal rectangle_h_over2, rectangle_v_over2, rectangle_over2 : std_logic;
  
  signal over_counter : std_logic := '0';
  signal crying : unsigned(23 downto 0) := "000000000000000000000000";
  signal crying_flag : std_logic := '0';
  ---------------------signal in gaming--------------------------
  signal rectangle_h_life, rectangle_v_life, rectangle_life : std_logic;
  signal RECTANGLE_HSTART_life : unsigned(15 downto 0);    ----to draw the opening
  signal RECTANGLE_HEND_life   : unsigned(15 downto 0); 
  signal RECTANGLE_VSTART_life : unsigned(15 downto 0); 
  signal RECTANGLE_VEND_life   : unsigned(15 downto 0);
  signal life : unsigned(15 downto 0) := "0000000000000011";   ----3 lives now   
  signal score : unsigned(15 downto 0) := "0000000000000000";
  signal score1 : unsigned(3 downto 0) := "0000";
  signal score2 : unsigned(3 downto 0) := "0000";
  signal score3 : unsigned(3 downto 0) := "0000";
  
  signal rectangle_h_score, rectangle_v_score, rectangle_score : std_logic;
  signal RECTANGLE_HSTART_score : unsigned(15 downto 0);    ----to draw the score
  signal RECTANGLE_HEND_score   : unsigned(15 downto 0); 
  signal RECTANGLE_VSTART_score : unsigned(15 downto 0); 
  signal RECTANGLE_VEND_score   : unsigned(15 downto 0);
  ---------------------signal for items--------------------
  signal ball_flag: std_logic;
  --signal ball_flag_temp: std_logic_vector(15 downto 0);
begin
------------------------------ram_address initial----------------------
   ram_address <= unsigned(address(3 downto 0));
  --ram_address <= ('0','0','0','0');
-----------------------------------------------------------------------
  -- Horizontal and vertical counters
--RECTANGLE_HSTART <= x - 14;
--RECTANGLE_HEND <= x + 14;
--RECTANGLE_VSTART <= y - 14;
--RECTANGLE_VEND <= y + 14;
--RAM(0):ram_type:= "0000000001011111";
--RAM(2):= "0000000001011111";
---------------------------ram process---------------------------------
  forRam: process(clk)
    begin	 
    if rising_edge(clk) then
      if reset_n = '0' then
        readdata <= (others => '0');
      else
        if chipselect = '1' then
          if address(4) = '0' then   -----the address indicate to the RAM
             if read = '1' then
               readdata <= RAM(to_integer(ram_address));
             elsif write = '1' then
			--	   if to_integer(ram_address)=0 then
			--		  x<= unsigned(writedata); 
			--		elsif to_integer(ram_address)=1 then
		    --       y <= unsigned(writedata); 
			--		elsif to_integer(ram_address)=2 then
			--		  x_board <= unsigned(writedata); 
			--		end if;
			     --if(ram_address>)
			      RAM(to_integer(ram_address))<=writedata;   -- change to ram drop
             end if;
          end if;
		  end if;
	
	
	     x <= unsigned(RAM(0));
		  y <= unsigned(RAM(1));
        RECTANGLE_HSTART <= x - 8;
		  RECTANGLE_HEND <= x + 6; --+6
		  RECTANGLE_VSTART <= y - 7;---7
		  RECTANGLE_VEND <= y + 8; 
		  x_board <= unsigned(RAM(2));
		  	  
		  state <= unsigned(RAM(11));    --address should after the bricklayout
		  mode <= unsigned(RAM(12));
		  difficulty_temp <= unsigned(RAM(13));
		  difficulty(7 downto 0)<=difficulty_temp(7 downto 0);
		  ball_flag<=difficulty_temp(8);
		  life <= unsigned(RAM(14));
		  
		  score <= unsigned(RAM(15));                              -- ram(15) store score!!!
		  score1 <= score(11 downto 8);
		  score2 <= score(7 downto 4);
	     score3 <= score(3 downto 0);
		  
		  
		  RECTANGLE_HSTART_board <= x_board - 21;
		  RECTANGLE_HEND_board <= x_board + 19;
		  RECTANGLE_VSTART_board <= to_unsigned(405,16);        ------leave 50-11 pixels for text
		  RECTANGLE_VEND_board <= to_unsigned(428,16);       


        RECTANGLE_HSTART_brick1 <= to_unsigned(0,16);   -- brick_x;
		  RECTANGLE_HEND_brick1 <= to_unsigned(639,16); --brick_x + 40; 
		  RECTANGLE_VSTART_brick1 <= to_unsigned(0,16);-- brick_y;        ------leave 50-11 pixels for text
		  RECTANGLE_VEND_brick1 <= to_unsigned(159,16);--brick_y + 20 ;    

        RECTANGLE_HSTART_opening <= random_x - 175;
		  RECTANGLE_HEND_opening <= random_x + 172 ;
		  RECTANGLE_VSTART_opening <= random_y - 179;
		  RECTANGLE_VEND_opening <= random_y + 180;
		  
		  RECTANGLE_HSTART_over <= to_unsigned(100,16);--320 - 210;
        RECTANGLE_HEND_over <= to_unsigned(529,16);--320 + 209;  
        RECTANGLE_VSTART_over <= to_unsigned(143,16);--180 - 37;
        RECTANGLE_VEND_over <= to_unsigned(216,16);--180 + 38;
		  
		  RECTANGLE_VSTART_life <= to_unsigned(444,16);
		  RECTANGLE_VEND_life   <= to_unsigned(470,16);
		  RECTANGLE_HEND_life   <= to_unsigned(304,16);
		  
		  
		  RECTANGLE_HSTART_over2 <= to_unsigned(235,16);--320 - 85;
        RECTANGLE_HEND_over2 <= to_unsigned(404,16);--320 + 84;  
        RECTANGLE_VSTART_over2 <= to_unsigned(277,16);--330 - 53;
        RECTANGLE_VEND_over2 <= to_unsigned(384,16);--330 + 54;
		  
		  RECTANGLE_HSTART_score <= to_unsigned(410,16);
        RECTANGLE_HEND_score <= to_unsigned(470,16);--
        RECTANGLE_VSTART_score <= to_unsigned(444,16);--
        RECTANGLE_VEND_score <= to_unsigned(464,16);--
		  
		--  if life < "0000000000000100" then
		  RECTANGLE_HSTART_life <= to_unsigned(304-(5 - to_INTEGER(life))*30 - 3,16);
	   --  else
		--  RECTANGLE_HSTART_life <= to_unsigned(304-(5 - to_INTEGER(life))*30,16); 
		 -- end if;
		  
		end if;
    end if;
  end process forRam;
  ---------------------------random num generator!!-------------------------


  randomnum: process(clk)
  begin
  if rising_edge(clk) then     
    feedback <= lfsr_reg(127) xor lfsr_reg(0) ;

          if (reset_n = '0') then          --------neccessary????
             lfsr_reg <= brick_layout;

          else
            lfsr_reg <= lfsr_reg(lfsr_reg'high - 1 downto 0) & feedback ;

          end if;
  end if;

  end process randomnum;
  
  
  randomnum2: process(clk)
  begin
  if rising_edge(clk) then     
    feedback2 <= lfsr_reg2(127) xor lfsr_reg2(0) ;

          if (reset_n = '0') then          --------neccessary????
             lfsr_reg2 <= brick_layout + 1024 ;

          else
            lfsr_reg2 <= lfsr_reg2(lfsr_reg2'high - 1 downto 0) & feedback2 ;

          end if;
  end if;

  end process randomnum2;
  
  
  randomnum3: process(clk)
  begin
  if rising_edge(clk) then     
    feedback3 <= lfsr_reg3(127) xor lfsr_reg3(0) ;

          if (reset_n = '0') then          --------neccessary????
             lfsr_reg3 <= brick_layout - 655356 ;

          else
            lfsr_reg3 <= lfsr_reg3(lfsr_reg3'high - 1 downto 0) & feedback3 ;

          end if;
  end if;

  end process randomnum3;
  
    randomnum4: process(clk)                             --for item1 drop
  begin
  if rising_edge(clk) then     
    feedback4 <= lfsr_reg3(7) xor lfsr_reg3(0) ;

          if (reset_n = '0') then          --------neccessary????
             lfsr_reg4 <= ('0','1','0','1','0','1','0','1') ;

          else
            lfsr_reg4 <= lfsr_reg4(lfsr_reg4'high - 1 downto 0) & feedback4 ;

          end if;
  end if;

  end process randomnum4;
----------------use lfsr_reg(7) as output-----------------------------------

  
-----------------------brick layout-----------------------------------------
layoutbrick: process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then
        brick_line <= to_unsigned(0,4);
	     brick_layout	<=
		  (
			'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
			'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
			'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
			'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
			'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
			'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
			'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1',
			'1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1'
			);   
      else
		  brick_layout(to_INTEGER(brick_line)*16 to to_INTEGER(brick_line)*16+15)<=ram(to_INTEGER(brick_line) + 3);
		  brick_line <= brick_line + 1;
		      if brick_line > 7 then
					brick_line <= to_unsigned(0,4);
				end if;
      end if;      
    end if;
  end process layoutbrick;
  --------------------------for sram read in--------------------------------
  
  sramaddress: process (clk)
  begin
   if rising_edge(clk) then      
     if reset_n = '0' then
		 sram_label <= '0';
		else
		 sram_label <= not sram_label;
		end if;
   end if;

end process sramaddress;
  
  
  
-------------------------------------------------------------------------
--Bricklayout : process(clk)
--begin
--    if rising_edge(clk) then      
--      if reset_n = '0' then
--        brick_x <= to_unsigned(0,16);
--  brick_y <= to_unsigned(59,16)
--    elsif EndOfLine = '1' then
--      Hcount <= (others => '0');
--    else
--      Hcount <= Hcount + 1;
--    end if;      
--  end if;
--end process bricklayout;

--draw_over :process(clk)
--  begin
--    if rising_edge(clk) then      
--      if reset_n = '0' then
--        over_counter <= '0';
--      elsif EndOfLine = '1' and rectangle_h_over2='1' then
--       over_counter <= not over_counter;   
--      end if;      
--    end if;
--  end process draw_over;
		  
HCounter : process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then
        Hcount <= (others => '0');	  
      elsif EndOfLine = '1' then
        Hcount <= (others => '0');
	--	   if rectangle_v_over2='1' then
	--		       over_counter <= not over_counter; 
--			elsif rectangle_v_over2='0' then
	--			    over_counter <= '0';
	--		end if;
      else
        Hcount <= Hcount + 1;
      end if;      
    end if;
  end process HCounter;

  EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
  VCounter: process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then
        Vcount <= (others => '0');
		  bg_change <= (others => '0');       --------------------------------initial bg_change here!!!!!!!!
      elsif EndOfLine = '1' then
        if EndOfField = '1' then
          Vcount <= (others => '0');
			 bg_change <= (others => '0');
        else
          Vcount <= Vcount + 1;
			 bg_change <= bg_change + 1;
        end if;
      end if;
    end if;
  end process VCounter;

  EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK

  HSyncGen : process (clk)
  begin
    if rising_edge(clk) then     
      if reset_n = '0' or EndOfLine = '1' then
        vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
  
  HBlankGen : process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH then
        vga_hblank <= '0';
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then
        vga_hblank <= '1';
      end if;      
    end if;
  end process HBlankGen;

  VSyncGen : process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        vga_vsync <= '1';
      elsif EndOfLine ='1' then
        if EndOfField = '1' then
          vga_vsync <= '1';
        elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';
        end if;
      end if;      
    end if;
  end process VSyncGen;

  VBlankGen : process (clk)
  begin
    if rising_edge(clk) then    
      if reset_n = '0' then
        vga_vblank <= '1';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 then
          vga_vblank <= '0';
        elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
        end if;
      end if;
    end if;
  end process VBlankGen;
  
  
  
  ----random coordination and block generator--------------




  -- Rectangle generator

  RectangleHGen : process (clk)
  begin
    if rising_edge(clk) then     
      if reset_n = '0' then
        rectangle_h <= '0';
		elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND) + 1 then
		  if ball_flag = '0' then
				rectangle_h <= circle_pix(TO_INTEGER(Hcount - HSYNC - HBACK_PORCH - RECTANGLE_HSTART + TO_INTEGER(Vcount - VSYNC - VBACK_PORCH - RECTANGLE_VSTART) * 15));
        else
		  		rectangle_h <= circle_pix2(TO_INTEGER(Hcount - HSYNC - HBACK_PORCH - RECTANGLE_HSTART + TO_INTEGER(Vcount - VSYNC - VBACK_PORCH - RECTANGLE_VSTART) * 15));
        end if;
		else
        rectangle_h <= '0';
		end if;
    end if;
  end process RectangleHGen;

RectangleHGen_Board : process (clk)
  begin
    if rising_edge(clk) then  
		if reset_n = '0' then
        rectangle_h_board <= '0';
		elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_board) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_board) + 1 then
		  if flag_board='0' then
		  rectangle_h_board <= board_pix (TO_INTEGER(Hcount - HSYNC - HBACK_PORCH - RECTANGLE_HSTART_board + TO_INTEGER(Vcount - VSYNC - VBACK_PORCH - RECTANGLE_VSTART_board) * 41));       
        elsif flag_board='1' then
		  rectangle_h_board <= board2_pix (TO_INTEGER(Hcount - HSYNC - HBACK_PORCH - RECTANGLE_HSTART_board + TO_INTEGER(Vcount - VSYNC - VBACK_PORCH - RECTANGLE_VSTART_board) * 41));       
        end if;
		else
        rectangle_h_board <= '0';
		end if;     
	end if;
  end process RectangleHGen_Board;
  
  RectangleHGen_Brick1 : process (clk)
  begin
    if rising_edge(clk) then  
		if reset_n = '0' then
        rectangle_h_brick1 <= '0';
		elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_brick1) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_brick1) + 1 and random_temp2(to_INTEGER(count_H)+to_INTEGER(count_V)*16) = '0' then
		  rectangle_h_brick1 <= brick1_pix ((TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_brick1) - TO_INTEGER(count_H)*40 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_brick1) ) - TO_INTEGER(count_V)*20)*40));       
		elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_brick1) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_brick1) + 1 and random_temp2(to_INTEGER(count_H)+to_INTEGER(count_V)*16) = '1' then
		  rectangle_h_brick1 <= brick2_pix ((TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_brick1) - TO_INTEGER(count_H)*40 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_brick1) ) - TO_INTEGER(count_V)*20)*40));       
		else
        rectangle_h_brick1 <= '0';
		end if;     
	end if;
  end process RectangleHGen_Brick1;
  
  
  RectangleHGen_opening : process (clk)
  begin
    if rising_edge(clk) then  
		if reset_n = '0' then
        rectangle_h_opening <= '0';
	elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_opening) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_opening) + 1 then
		  rectangle_h_opening <= '1';       
      else
        rectangle_h_opening <= '0';
		end if;     
	end if;
  end process RectangleHGen_opening;
  
 RectangleHGen_over : process (clk)
  begin
    if rising_edge(clk) then  
		if reset_n = '0' then
        rectangle_h_over <= '0';
	elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_over) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_over) + 1 then
		  rectangle_h_over <= '1';       
      else
        rectangle_h_over <= '0';
		end if;     
	end if;
  end process RectangleHGen_over;
  
  RectangleHGen_life : process (clk)
  begin
    if rising_edge(clk) then  
		if reset_n = '0' then
        rectangle_h_life <= '0';
	elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_life) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_life) + 1 then
		  rectangle_h_life <= '1';       
      else
        rectangle_h_life <= '0';
		end if;     
	end if;
  end process RectangleHGen_life;
  
  RectangleHGen_score : process (clk)
  begin
    if rising_edge(clk) then  
		if reset_n = '0' then
        rectangle_h_score <= '0';
	elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_score) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_score) + 1 then
		  rectangle_h_score <= '1';       
      else
        rectangle_h_score <= '0';
		end if;     
	end if;
  end process RectangleHGen_score;
  
  
  RectangleHGen_over2 : process (clk)
  begin
    if rising_edge(clk) then  
		if reset_n = '0' then
        rectangle_h_over2 <= '0';
	elsif Hcount > HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HSTART_over2) - 1 and Hcount < HSYNC + HBACK_PORCH + TO_INTEGER(RECTANGLE_HEND_over2) + 1 then
		  rectangle_h_over2 <= '1';       
      else
        rectangle_h_over2 <= '0';
		end if;     
	end if;
  end process RectangleHGen_over2;
  
  RectangleVGen : process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then       
        rectangle_v <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND then
          rectangle_v <= '1';
        else
          rectangle_v <= '0';
        end if;
		end if;
		  
		if reset_n = '0' then       
        rectangle_v_board <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART_board and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND_board then
          rectangle_v_board <= '1';
        else
          rectangle_v_board <= '0';
        end if;
		end if;  
		  
		if reset_n = '0' then       
        rectangle_v_brick1 <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART_brick1 and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND_brick1 then
          rectangle_v_brick1 <= '1';
        else
          rectangle_v_brick1 <= '0';
        end if;
		end if;  
		
	   if reset_n = '0' then       
        rectangle_v_opening <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART_opening and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND_opening then
          rectangle_v_opening <= '1';
        else
          rectangle_v_opening <= '0';
        end if;
		end if;  
		
	   if reset_n = '0' then       
        rectangle_v_over <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART_over and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND_over then
          rectangle_v_over <= '1';
        else
          rectangle_v_over <= '0';
        end if;
		end if;  
		
	   if reset_n = '0' then       
        rectangle_v_life <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART_life and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND_life then
          rectangle_v_life <= '1';
        else
          rectangle_v_life <= '0';
        end if;
		end if;
		  
		if reset_n = '0' then       
        rectangle_v_over2 <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART_over2 and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND_over2 then
          rectangle_v_over2 <= '1';
        else
          rectangle_v_over2 <= '0';
        end if;
		end if;   
		  
		if reset_n = '0' then       
        rectangle_v_score <= '0';
      elsif EndOfLine = '1' then
        if Vcount > VSYNC + VBACK_PORCH - 2 + RECTANGLE_VSTART_score and Vcount < VSYNC + VBACK_PORCH + RECTANGLE_VEND_score then
          rectangle_v_score <= '1';
        else
          rectangle_v_score <= '0';
        end if;
		end if;   
		  
    end if;      

  end process RectangleVGen;
  
  

  circle <= rectangle_h and rectangle_v;

  board <= rectangle_h_board and rectangle_v_board;
  
  brick1 <= rectangle_h_brick1 and rectangle_v_brick1;
  
  rectangle_opening <= rectangle_h_opening and rectangle_v_opening;
  
  rectangle_over <= rectangle_h_over and rectangle_v_over;
  
  rectangle_life <= rectangle_h_life and rectangle_v_life;
  
  rectangle_over2 <= rectangle_h_over2 and rectangle_v_over2;
  
  rectangle_score <= rectangle_h_score and rectangle_v_score;
  
  brickchange: process(clk,reset_n) 
  begin
	  if(reset_n='0') then
		 random_temp <= brick_layout;
		 random_temp2 <= brick_layout;
		 timer <= "00000000000000000000000000000000";
		elsif clk'event and clk = '1' then
			random_temp <= lfsr_reg;
			random_temp3 <= lfsr_reg2;
		   random_temp4 <= lfsr_reg3;
			timer <= timer + 1;
			if timer = 50000000 then
				random_temp2 <= random_temp and random_temp3 and random_temp4;

				timer <= "00000000000000000000000000000000";
--			elsif timer =50000000 then
--				timer <= "00000000000000000000000000000000";
			end if;
		end if;
  end process brickchange;
				
				
  overchange: process(clk,reset_n) 
  begin
	  if(reset_n='0') then
		 crying <= "000000000000000000000000";
		elsif rising_edge(clk) then
		    crying <= crying + 1;
			if crying = 10000000 then
				crying <= "000000000000000000000000";
    			crying_flag <= not crying_flag;
			end if;
		end if;
end process overchange;		

--scorereveal: process(clk,reset_n) 
--  begin
--	  if(reset_n='0') then
--		 score <= "0000000000000000";
--		elsif rising_edge(clk) then
 --      score1 <= score(11 downto 8);
--		 score2 <= score(7 downto 4);
--	    score3 <= score(3 downto 0);
--		end if;
--end process scorereveal;		
					
				
drop: process(clk,reset_n)
  begin
    if(reset_n='0') then
		drop_enable<='0';
    elsif rising_edge(clk) then
      drop_enable <= drop_temp(0);
	   bricknumber_x <=drop_temp(11 downto 8);
     bricknumber_y <=drop_temp(15 downto 12);
		if drop_enable='1' then
		  if to_integer(unsigned(lfsr_reg4))<5 then
		    item_type<=unsigned(lfsr_reg4);
			 x_drop<=to_unsigned(40*(to_integer(unsigned(bricknumber_x)))+20,16);
			 y_drop<=to_unsigned(20*(to_integer(unsigned(bricknumber_y)))+10,16);
			 if item_type=0 then
			   reveal_en0<='1';
			 elsif item_type=1 then
			   reveal_en1<='1';
			 elsif item_type=2 then
			   reveal_en2<='1';
			 elsif item_type=3 then
			   reveal_en3<='1';
			 elsif item_type=4 then
			   reveal_en4<='1';
			 end if;
		  end if;
		end if;
   end if;
end process drop;

droptrack: process(clk,reset_n)
  begin
   if rising_edge(clk) then
	   y_drop_temp<=y_drop;
     if(reset_n='0') then
            count_drop<="0000000000000000";
		elsif y_drop<400 then
		      if count_drop="1111111111111111" then
		        y_drop_temp<= y_drop_temp+1;
			     count_drop<= "0000000000000000";
		      else
		        count_drop<= count_drop+1;
		      end if;
		elsif (x_drop>x_board-20) and (x_drop<x_board+20) then
		      if item_type=0 then
			     RAM_drop(11)<="0000000000000001";  --ram(11)
	      elsif item_type=1 then
			     RAM_drop(12)<="0000000000000001";
		      elsif item_type=2 then
			     RAM_drop(13)<="0000000000000001";
		      elsif item_type=3 then
			     RAM_drop(14)<="0000000000000001";
		      elsif item_type=4 then
			     RAM_drop(15)<="0000000000000001";
		      end if;		
		end if;	
	 end if;	
end process droptrack;
				
boardcount: process(clk)
  begin
    if rising_edge(clk) then
      if(reset_n='0') then
		  count_board<="000000000000000000000000"; 
		elsif y=396 then
		  count_board<="000000000000000000000001";
		else
		  if count_board="000000000000000000000000" or count_board="111111111111111111111111" then 
		    count_board<="000000000000000000000000"; 
		  else 
		    count_board<=count_board+1;
		  end if;
		end if;
	 end if;	
  end process boardcount;
  
  boardflag: process(clk)
  begin
    if rising_edge(clk) then
      if(reset_n='0') then
		  flag_board<='0'; 
		elsif y=396 then
		  flag_board<='1'; 
		else
		  if count_board>"000000000000000000000000" and count_board<"111111111111111111111111" then 
		    flag_board<='1';
		  else 
		    flag_board<='0';
		  end if;
		end if;
	 end if;	
  end process boardflag;			

  	
  -- Registered video signals going to the video DAC

  VideoOut: process (clk, reset_n)
  begin
    if reset_n = '0' then
      VGA_R <= "0000000000";
      VGA_G <= "0000000000";
      VGA_B <= "0000000000";
		count_H <= "0000000000000000";
		count_V <= "0000000000000000";
		
elsif rising_edge(clk) then
		if Hcount = 40 * (to_INTEGER(count_H)+1) + HSYNC + HBACK_PORCH  then  ----
		  count_H <= count_H + 1;  -------
--VGA_R <= "0000000000";
-- VGA_G <= "0000000000";
 --     VGA_B <= "0000000000";
	--	  elsif count_H = "0000000000001111"  then   --1111 BIN = 15 DEC
		  elsif endOfLine = '1'  then   --1111 BIN = 15 DEC
		  count_H <= "0000000000000000";
		  elsif Vcount = 20 *  (to_INTEGER(count_V)+1) + VSYNC + VBACK_PORCH -1 then
		  count_V <= count_V +1;
		  elsif count_V = "0000000000001001" then  --101 bin = 5 dec
		  count_V <= "0000000000000000" ; 
		  
		  elsif endOfField = '1' then
			count_H <= "0000000000000000";
			count_V <= "0000000000000000";
			end if;
			
    elsif clk'event and clk = '1' then
      --if circle = '1' then
		if state = "0000000000000000" then
		    if rectangle_opening = '1' then
			 --    if random_x - (TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH -1) > 64 and random_x - (TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH -1) < 94 and random_y - (TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH) < 10 - to_INTEGER(mode) * 30   and random_y - (TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH) > -20 - to_INTEGER(mode) * 30 then
				    if (TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH -1) > 226 and (TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH -1) < 256 and (TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH) > 260 - to_INTEGER(mode) * 30   and  (TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH) < 290 - to_INTEGER(mode) * 30 then			   
			         VGA_R <= "1111111111";
						VGA_G <= "1111111111";
						VGA_B <= "1111111111";
				  elsif TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH -1 > 336 and TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH -1 < 365 and TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH  > 262 + 27 - to_INTEGER(difficulty) * 27 and TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH  < 289 + 27 - to_INTEGER(difficulty) * 27 then
					   VGA_R <= "1111111111";
						VGA_G <= "1111111111";
						VGA_B <= "1111111111";
				  else
						if sram_label = '1' then
						  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_map_opening(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change
						  VGA_R(1 downto 0) <= "00";
						  --VGA_R(9 downto 0) <= "1111111111";
						  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_map_opening(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change`
						  VGA_G(1 downto 0) <= "00";
						  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_map_opening(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change
						  VGA_B(1 downto 0) <= "00";
						 else
						  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_map_opening(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
						  --VGA_R(9 downto 0) <= "1111111111";
						  VGA_R(1 downto 0) <= "00";
						  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_map_opening(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
						  VGA_G(1 downto 0) <= "00";
						  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_map_opening(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
						  VGA_B(1 downto 0) <= "00"; 
						end if;
				  end if;
		    elsif vga_hblank = '1' or vga_vblank ='1' then
			 			VGA_R <= "0000000000";
						VGA_G <= "0000000000";
						VGA_B <= "0000000000";
			else
			  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_map_opening(0),8));   ----+ bg_change
			  VGA_R(1 downto 0) <= "00";
			  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_map_opening(0),8));   ----+ bg_change
			  VGA_G(1 downto 0) <= "00"; 
			  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_map_opening(0),8));   ----+ bg_change
			  VGA_B(1 downto 0) <= "00"; 
			end if;
		elsif state = "1111111111111111"	 then
			 if rectangle_over = '1' then
						if sram_label = '0' then
						  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_map_over2(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change
						  VGA_R(1 downto 0) <= "00";
						  --VGA_R(9 downto 0) <= "1111111111";
						  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_map_over2(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change`
						  VGA_G(1 downto 0) <= "00";
						  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_map_over2(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change
						  VGA_B(1 downto 0) <= "00";
						 else
						  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_map_over2(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
						  --VGA_R(9 downto 0) <= "1111111111";
						  VGA_R(1 downto 0) <= "00";
						  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_map_over2(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
						  VGA_G(1 downto 0) <= "00";
						  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_map_over2(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
						  VGA_B(1 downto 0) <= "00"; 
						end if;
			  elsif  rectangle_over2 = '1' then
						if sram_label = '1' then
						  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_map_over1(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change
						  VGA_R(1 downto 0) <= "00";
						  --VGA_R(9 downto 0) <= "1111111111";
						  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_map_over1(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change`
						  VGA_G(1 downto 0) <= "00";
						  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_map_over1(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change
						  VGA_B(1 downto 0) <= "00";
						 else
						  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_map_over1(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
						  --VGA_R(9 downto 0) <= "1111111111";
						  VGA_R(1 downto 0) <= "00";
						  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_map_over1(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
						  VGA_G(1 downto 0) <= "00";
						  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_map_over1(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
						  VGA_B(1 downto 0) <= "00"; 
						end if;
			  else
				  VGA_R <= "0000000000";
				  VGA_G <= "0000000000";
				  VGA_B <= "0000000000";  
			  end if;

		else
			if circle = '1' then
				if ball_flag = '0' then
				  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART) ))*16),8));
				  VGA_R(1 downto 0) <= "00";
				  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART) ))*16),8));
				  VGA_G(1 downto 0) <= "00";
				  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART) ))*16),8));
				  VGA_B(1 downto 0) <= "00";
				else
				  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R2(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART) ))*16),8));
				  VGA_R(1 downto 0) <= "00";
				  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G2(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART) ))*16),8));
				  VGA_G(1 downto 0) <= "00";
				  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B2(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART) ))*16),8));
				  VGA_B(1 downto 0) <= "00";
				end if;
			elsif  board = '1'  then
			  if flag_board='0' then
			  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_board(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_board)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_board) ))*41),8));
			  VGA_R(1 downto 0) <= "00";
			  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_board(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_board)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_board) ))*41),8));
			  VGA_G(1 downto 0) <= "00";
			  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_board(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_board)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_board) ))*41),8));
			  VGA_B(1 downto 0) <= "00";
			  elsif flag_board='1' then
			  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_board2(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_board)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_board) ))*41),8));
			  VGA_R(1 downto 0) <= "00";
			  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_board2(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_board)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_board) ))*41),8));
			  VGA_G(1 downto 0) <= "00";
			  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_board2(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_board)- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_board) ))*41),8));
			  VGA_B(1 downto 0) <= "00";
           end if;
			  
			  elsif  (brick1 and (brick_layout(to_INTEGER(count_H)+to_INTEGER(count_V)*16))) = '1' and (random_temp2(to_INTEGER(count_H)+to_INTEGER(count_V)*16)) = '0' then
			  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_brick1(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
			  VGA_R(1 downto 0) <= "00";
			  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_brick1(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
			  --std_logic_vector(to_unsigned(G_brick1(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_brick1 - TO_INTEGER(count_H)*40 )- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_brick1 - TO_INTEGER(count_V)*20) ))*40),8));
			  VGA_G(1 downto 0) <= "00";
			  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_brick1(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
			  VGA_B(1 downto 0) <= "00";
			  
		
		  elsif  (brick1 and (brick_layout(to_INTEGER(count_H)+to_INTEGER(count_V)*16))) = '1' and (random_temp2(to_INTEGER(count_H)+to_INTEGER(count_V)*16)) = '1' then
			  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_brick2(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
			  VGA_R(1 downto 0) <= "00";
			  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_brick2(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
			  --std_logic_vector(to_unsigned(G_brick1(TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_brick1 - TO_INTEGER(count_H)*40 )- 1 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_brick1 - TO_INTEGER(count_V)*20) ))*40),8));
			  VGA_G(1 downto 0) <= "00";
			  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_brick2(TO_integer(Hcount)- To_integer(RECTANGLE_HSTART_brick1) - To_integer(count_H)*40  - HSYNC - HBACK_PORCH- 1 +(TO_integer(Vcount)- To_integer(RECTANGLE_VSTART_brick1) - To_integer(count_V)*20 - VSYNC - VBACK_PORCH ) *40),8));
			  VGA_B(1 downto 0) <= "00";
	--		elsif circle = '0' and rectangle = '1' then
	--		  VGA_R <= "1111111111";
	--       VGA_G <= "1111111111";
	--        VGA_B <= "1111111111";

	  --    elsif vga_hblank = '0' and vga_vblank ='0' then
	  --      VGA_R <= bg_change + "0011111100" ;   ----+ bg_change
	  --      VGA_G <= bg_change + "0011111100" ;
	  --      VGA_B <= "1111111111";
	  	elsif rectangle_score = '1' then  --((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_score) ))*60
		    if TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1 < 20 then
			     if score1= 0 then
				      if scorenum((TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1)+9*20+((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_score) ))*200)='1' then
							VGA_R <= "0000000000";
							VGA_G <= "0000000000";
							VGA_B <= "0000000000";
					   else 		
							VGA_R <= "1111111111";
							VGA_G <= "1111111111";
							VGA_B <= "1111111111";
					   end if;
					else
						if scorenum((TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1)+(TO_INTEGER(score1)-1)*20+((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_score) ))*200)='1' then
							VGA_R <= "0000000000";
							VGA_G <= "0000000000";
							VGA_B <= "0000000000";
					   else 		
							VGA_R <= "1111111111";
							VGA_G <= "1111111111";
							VGA_B <= "1111111111";
					   end if;
				    end if;
			 elsif TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1 >19 and TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1 < 40 then
			      if score2= 0 then
				      if scorenum((TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1)+ 9*20 - 20+((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_score) ))*200)='1' then
						   VGA_R <= "0000000000";
							VGA_G <= "0000000000";
							VGA_B <= "0000000000";
					   else 		
							VGA_R <= "1111111111";
							VGA_G <= "1111111111";
							VGA_B <= "1111111111";
					   end if;
					else
						if scorenum((TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1)+(TO_INTEGER(score2)-1)*20- 20 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_score) ))*200)='1' then
							VGA_R <= "0000000000";
							VGA_G <= "0000000000";
							VGA_B <= "0000000000";
					   else 		
							VGA_R <= "1111111111";
							VGA_G <= "1111111111";
							VGA_B <= "1111111111";
					   end if;
				    end if;
			 elsif TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1 >39 and TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1 < 60 then
				   if score3= 0 then
				      if scorenum((TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1)+ 9*20 - 40+((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_score) ))*200)='1' then
							VGA_R <= "0000000000";
							VGA_G <= "0000000000";
							VGA_B <= "0000000000";
					   else 		
							VGA_R <= "1111111111";
							VGA_G <= "1111111111";
							VGA_B <= "1111111111";
					   end if;
					else
						if scorenum((TO_INTEGER(Hcount) - HSYNC - HBACK_PORCH - TO_INTEGER(RECTANGLE_HSTART_score)- 1)+(TO_INTEGER(score3)-1)*20- 40 +((TO_INTEGER(Vcount) - VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_score) ))*200)='1' then
						   VGA_R <= "0000000000";
							VGA_G <= "0000000000";
							VGA_B <= "0000000000";
					   else 		
							VGA_R <= "1111111111";
							VGA_G <= "1111111111";
							VGA_B <= "1111111111";
					   end if;
				    end if;
			 end if;
	  

		 elsif vga_hblank = '0' and vga_vblank ='0' and rectangle_life = '0' then
	--	     if Vcount>430 +  VSYNC + VBACK_PORCH - 1 then
	--        VGA_R <= bg_change + "0011111100" ;   ----+ bg_change
	--        VGA_G <= bg_change + "0011111100" ;
	--        VGA_B <= "1111111111";
	--		  else
					if sram_label = '0' then
					  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_map(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change
					  VGA_R(1 downto 0) <= "00";
					  --VGA_R(9 downto 0) <= "1111111111";
					  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_map(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change
					  VGA_G(1 downto 0) <= "00";
					  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_map(to_INTEGER(unsigned(sram_datain(15 downto 8)))-1),8));   ----+ bg_change
					  VGA_B(1 downto 0) <= "00";
					 else
					  VGA_R(9 downto 2) <= std_logic_vector(to_unsigned(R_map(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
					  --VGA_R(9 downto 0) <= "1111111111";
					  VGA_R(1 downto 0) <= "00";
					  VGA_G(9 downto 2) <= std_logic_vector(to_unsigned(G_map(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
					  VGA_G(1 downto 0) <= "00";
					  VGA_B(9 downto 2) <= std_logic_vector(to_unsigned(B_map(to_INTEGER(unsigned(sram_datain(7 downto 0)))-1),8));   ----+ bg_change
					  VGA_B(1 downto 0) <= "00"; 
					end if;
		--		end if;
		elsif rectangle_life = '1' then
		     VGA_R <= "1111111111";
			  VGA_G <= "1111111111";
			  VGA_B <= "1111111111";  
	
       elsif vga_hblank = '0' and vga_vblank ='0' then --and rectangle_life = '1'
		 	  VGA_R <= "1111111111";
			  VGA_G <= "1111111111";
			  VGA_B <= "1111111111";   
			else
			  VGA_R <= "0000000000";
			  VGA_G <= "0000000000";
			  VGA_B <= "0000000000";    
			end if;
		end if;
    end if;
  end process VideoOut;

 -- sram_read <='1';
  VGA_CLK <= clk;
  VGA_HS <= not vga_hsync;
  VGA_VS <= not vga_vsync;
  VGA_SYNC <= '0';
  VGA_BLANK <= not (vga_hsync or vga_vsync);
  
adrrr: process(reset_n)
  begin
    if(reset_n='0') then
		sram_address (17 downto 0) <= "000000000000000000";
    else
		if state = "0000000000000000" then
		  sram_address(17 downto 0) <= std_logic_vector((to_unsigned(((TO_integer(Hcount)- HSYNC - HBACK_PORCH- TO_INTEGER(RECTANGLE_HSTART_opening)- 1)/2 + (TO_integer(Vcount)- VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_opening)) *174 + 153600),18))); --153600=640*480/2
		elsif state = "1111111111111111" and rectangle_over = '1' then
		  sram_address(17 downto 0) <= std_logic_vector((to_unsigned(((TO_integer(Hcount)- HSYNC - HBACK_PORCH- TO_INTEGER(RECTANGLE_HSTART_over)- 1)/2 + (TO_integer(Vcount)- VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_over)) *209 + 153600 + 62466 + 18020),18))); --153600=640*480/2
		elsif state = "1111111111111111" and rectangle_over2 = '1' and crying_flag = '0' then
		  sram_address(17 downto 0) <= std_logic_vector((to_unsigned(((TO_integer(Hcount)- HSYNC - HBACK_PORCH- TO_INTEGER(RECTANGLE_HSTART_over2)- 1)/2 + (TO_integer(Vcount)- VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_over2)) *85 + 153600 + 62466),18))); --153600=640*480/2
		elsif state = "1111111111111111" and rectangle_over2 = '1' and crying_flag = '1' then
		  sram_address(17 downto 0) <= std_logic_vector((to_unsigned(((TO_integer(Hcount)- HSYNC - HBACK_PORCH- TO_INTEGER(RECTANGLE_HSTART_over2)- 1)/2 + (TO_integer(Vcount)- VSYNC - VBACK_PORCH - TO_INTEGER(RECTANGLE_VSTART_over2)) *85 + 153600 + 62466 + 9010),18))); --153600=640*480/2
		else
		  sram_address(17 downto 0) <= std_logic_vector((to_unsigned(((TO_integer(Hcount)- HSYNC - HBACK_PORCH- 1)/2 + (TO_integer(Vcount)- VSYNC - VBACK_PORCH ) *320),18)));
		end if;
    end if;
end process adrrr;

end rtl;
