open Sdl
type action = Ast | Bytecode | Compile

let main() = 
    let leave () = 
        print_string ("Usage: " ^ Sys.argv.(0) ^ " <file.wav>");
        Sdl.quit ();
        ()
    in
    if Array.length Sys.argv < 2 then leave () else begin
      let lexbuf = Lexing.from_channel stdin in
      let program = Parser.program Scanner.token lexbuf in
      Execute.execute_prog (Compile.translate program) Sys.argv.(1)
      end
 
let _ = main ()



