/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class MessageInfo {
    public static String[] keyNames = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    public static String[] keySignatures = new String[]{"Cb", "Gb", "Db", "Ab", "Eb", "Bb", "F", "C", "G", "D", "A", "E", "B", "F#", "C#"};

    public static String toString(MidiMessage message) {
        if (message instanceof ShortMessage) {
            return MessageInfo.toString((ShortMessage)message);
        }
        if (message instanceof SysexMessage) {
            return MessageInfo.toString((SysexMessage)message);
        }
        if (message instanceof MetaMessage) {
            return MessageInfo.toString((MetaMessage)message);
        }
        return "unknown midi message " + message;
    }

    public static String toString(ShortMessage message) {
        String strMessage = null;
        switch (message.getCommand()) {
            case 128: {
                strMessage = "note off " + MessageInfo.getKeyName(message.getData1()) + ", velocity: " + message.getData2();
                break;
            }
            case 144: {
                strMessage = "note " + MessageInfo.getKeyName(message.getData1()) + " on velocity: " + message.getData2();
                break;
            }
            case 160: {
                strMessage = "polyphonic key pressure " + MessageInfo.getKeyName(message.getData1()) + " pressure: " + message.getData2();
                break;
            }
            case 176: {
                strMessage = "control change " + message.getData1() + " value: " + message.getData2();
                break;
            }
            case 192: {
                strMessage = "program change " + message.getData1();
                break;
            }
            case 208: {
                strMessage = "key pressure " + MessageInfo.getKeyName(message.getData1()) + " pressure: " + message.getData2();
                break;
            }
            case 224: {
                strMessage = "pitch bend " + MessageInfo.get14bitValue(message.getData1(), message.getData2());
                break;
            }
            case 240: {
                switch (message.getChannel()) {
                    case 0: {
                        strMessage = "System Exclusive (should not be in ShortMessage)";
                        break;
                    }
                    case 1: {
                        strMessage = "Undefined";
                        break;
                    }
                    case 2: {
                        strMessage = "Song Position: " + MessageInfo.get14bitValue(message.getData1(), message.getData2());
                        break;
                    }
                    case 3: {
                        strMessage = "Song Select: " + message.getData1();
                        break;
                    }
                    case 4: {
                        strMessage = "Undefined";
                        break;
                    }
                    case 5: {
                        strMessage = "Undefined";
                        break;
                    }
                    case 6: {
                        strMessage = "Tune Request";
                        break;
                    }
                    case 7: {
                        strMessage = "end of SysEx (should not be in ShortMessage)";
                        break;
                    }
                    case 8: {
                        strMessage = "Timing clock";
                        break;
                    }
                    case 9: {
                        strMessage = "Undefined";
                        break;
                    }
                    case 10: {
                        strMessage = "Start";
                        break;
                    }
                    case 11: {
                        strMessage = "Continue";
                        break;
                    }
                    case 12: {
                        strMessage = "Stop";
                        break;
                    }
                    case 13: {
                        strMessage = "Undefined";
                        break;
                    }
                    case 14: {
                        strMessage = "Active Sensing";
                        break;
                    }
                    case 15: {
                        strMessage = "System Reset";
                    }
                }
                break;
            }
            default: {
                strMessage = "unknown message: status = " + message.getStatus() + ", byte1 = " + message.getData1() + ", byte2 = " + message.getData2();
            }
        }
        if (message.getCommand() != 240) {
            int nChannel = message.getChannel() + 1;
            String strChannel = "channel " + nChannel + ": ";
            strMessage = String.valueOf(strChannel) + strMessage;
        }
        return strMessage;
    }

    public static String toString(SysexMessage message) {
        byte[] abData = message.getData();
        String strMessage = null;
        if (message.getStatus() == 240) {
            strMessage = "Sysex message: F0" + MessageInfo.getHexString(abData);
        } else if (message.getStatus() == 247) {
            strMessage = "Special Sysex message (F7):" + MessageInfo.getHexString(abData);
        }
        return strMessage;
    }

    public static String toString(MetaMessage message) {
        byte[] abData = message.getData();
        int nDataLength = message.getLength();
        String strMessage = null;
        switch (message.getType()) {
            case 0: {
                int nSequenceNumber = abData[0] * 256 + abData[1];
                strMessage = "Sequence Number: " + nSequenceNumber;
                break;
            }
            case 1: {
                String strText = new String(abData, 0, nDataLength);
                strMessage = "Text Event: " + strText;
                break;
            }
            case 2: {
                String strCopyrightText = new String(abData, 0, nDataLength);
                strMessage = "Copyright Notice: " + strCopyrightText;
                break;
            }
            case 3: {
                String strTrackName = new String(abData, 0, nDataLength);
                strMessage = "Sequence/Track Name: " + strTrackName;
                break;
            }
            case 4: {
                String strInstrumentName = new String(abData, 0, nDataLength);
                strMessage = "Instrument Name: " + strInstrumentName;
                break;
            }
            case 5: {
                String strLyrics = new String(abData, 0, nDataLength);
                strMessage = "Lyric: " + strLyrics;
                break;
            }
            case 6: {
                String strMarkerText = new String(abData, 0, nDataLength);
                strMessage = "Marker: " + strMarkerText;
                break;
            }
            case 7: {
                String strCuePointText = new String(abData, 0, nDataLength);
                strMessage = "Cue Point: " + strCuePointText;
                break;
            }
            case 32: {
                byte nChannelPrefix = abData[0];
                strMessage = "MIDI Channel Prefix: " + nChannelPrefix;
                break;
            }
            case 47: {
                strMessage = "end of track";
                break;
            }
            case 81: {
                int nTempo = MessageInfo.signedByteToUnsigned(abData[0]) * 65536 + MessageInfo.signedByteToUnsigned(abData[1]) * 256 + MessageInfo.signedByteToUnsigned(abData[2]);
                strMessage = "Set Tempo (us/quarter note): " + nTempo;
                break;
            }
            case 84: {
                strMessage = "SMTPE Offset: " + abData[0] + ":" + abData[1] + ":" + abData[2] + "." + abData[3] + "." + abData[4];
                break;
            }
            case 88: {
                strMessage = "Time Signature: " + abData[0] + "/" + (1 << abData[1]) + ", MIDI clocks per metronome tick: " + abData[2] + ", 1/32 per 24 MIDI clocks: " + abData[3];
                break;
            }
            case 89: {
                String strGender = abData[1] == 1 ? "minor" : "major";
                strMessage = "Key Signature: " + keySignatures[abData[0] + 7] + " " + strGender;
                break;
            }
            case 127: {
                String strDataDump = "";
                strMessage = "Sequencer-Specific Meta event: " + strDataDump;
                break;
            }
            default: {
                String strUnknownDump = "";
                strMessage = "unknown Meta event: " + strUnknownDump;
            }
        }
        return strMessage;
    }

    public static String getKeyName(int nKeyNumber) {
        if (nKeyNumber > 127) {
            return "illegal value";
        }
        int nNote = nKeyNumber % 12;
        int nOctave = nKeyNumber / 12;
        return String.valueOf(keyNames[nNote]) + (nOctave - 1);
    }

    public static int get14bitValue(int lowPart, int highPart) {
        return lowPart & 0x7F | (highPart & 0x7F) << 7;
    }

    public static int signedByteToUnsigned(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public static String getHexString(byte[] aByte) {
        StringBuffer buf = new StringBuffer(aByte.length * 3 + 2);
        int i = 0;
        while (i < aByte.length) {
            buf.append(' ');
            byte bhigh = (byte)((aByte[i] & 0xF0) >> 4);
            buf.append((char)(bhigh > 9 ? bhigh + 65 - 10 : bhigh + 48));
            byte blow = (byte)(aByte[i] & 0xF);
            buf.append((char)(blow > 9 ? blow + 65 - 10 : blow + 48));
            ++i;
        }
        return new String(buf);
    }
}

