/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class CSV2MIDI {
    public static final String INSTRUMENTFILE = "sorted_instruments.csv";
    public static final int MININST = 0;
    public static final int MAXINST = 127;

    public static final byte[] getIntBytes(int input) {
        byte[] retval = new byte[]{(byte)(input >> 16 & 0xFF), (byte)(input >> 8 & 0xFF), (byte)(input & 0xFF)};
        return retval;
    }

    public static void main(String[] args) throws InvalidMidiDataException {
        String str;
        int currentCSVPos;
        int duration;
        int tick;
        int note;
        int velocity;
        int channel;
        Track track;
        int instrument;
        CSV csvFile;
        Sequence sequence;
        File outputFile;
        block21: {
            if (args.length != 2) {
                CSV2MIDI.printUsageAndExit();
            }
            outputFile = new File(args[1]);
            sequence = null;
            csvFile = new CSV(args[0]);
            csvFile.fillVector();
            int timingRes = 4;
            instrument = 1;
            try {
                sequence = new Sequence(0.0f, timingRes);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
                System.exit(1);
            }
            track = sequence.createTrack();
            channel = 0;
            velocity = 90;
            note = 0;
            tick = 0;
            duration = 0;
            currentCSVPos = 0;
            str = csvFile.data.elementAt(currentCSVPos).toString();
            if (str.compareToIgnoreCase("Instrument") == 0) {
                String instrumentName = csvFile.data.elementAt(currentCSVPos += 2).toString();
                instrumentName = instrumentName.trim();
                try {
                    try {
                        instrument = Integer.parseInt(instrumentName);
                        if (instrument < 0 || instrument > 127) {
                            System.out.println("Instrument # " + instrument + " is not a valid instrument.\nReverting to Piano");
                            instrument = 1;
                        }
                    }
                    catch (NumberFormatException e) {
                        instrument = InstrumentCheck.checkInstrument(INSTRUMENTFILE, instrumentName, 0, 127);
                        if (instrument == -1) {
                            System.out.println("Instrument: " + instrumentName + " is not a valid instrument.\nReverting to Piano");
                            instrument = 1;
                        }
                        if (instrumentName.length() < 1) {
                            --currentCSVPos;
                        }
                        currentCSVPos += 2;
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    currentCSVPos += 2;
                    throw throwable;
                }
                currentCSVPos += 2;
            } else {
                currentCSVPos = 0;
            }
        }
        ShortMessage sm = new ShortMessage();
        sm.setMessage(192, instrument, 0);
        track.add(new MidiEvent(sm, 0L));
        int oldPos = currentCSVPos;
        str = csvFile.data.elementAt(currentCSVPos).toString();
        if (str.compareToIgnoreCase("Tempo") == 0) {
            int tempo = Integer.parseInt(csvFile.data.elementAt(currentCSVPos += 2).toString().trim());
            int MPQN = 60000000 / tempo;
            MetaMessage mm = new MetaMessage();
            mm.setMessage(81, CSV2MIDI.getIntBytes(MPQN), 3);
            track.add(new MidiEvent(mm, 0L));
            currentCSVPos += 2;
        } else {
            currentCSVPos = oldPos;
        }
        while (currentCSVPos < csvFile.data.size()) {
            try {
                tick = Integer.parseInt(csvFile.data.elementAt(currentCSVPos).toString());
                duration = Integer.parseInt(csvFile.data.elementAt(currentCSVPos += 2).toString());
                note = Integer.parseInt(csvFile.data.elementAt(currentCSVPos += 2).toString());
                currentCSVPos += 2;
                track.add(CSV2MIDI.createNoteOnEvent(note, tick, channel, velocity));
                track.add(CSV2MIDI.createNoteOffEvent(note, tick + duration, channel));
            }
            catch (NumberFormatException e) {
                ++currentCSVPos;
            }
        }
        System.out.println("\nTrack: ");
        int j = 0;
        while (j < track.size()) {
            MidiEvent event = track.get(j);
            System.out.println(" tick " + event.getTick() + ", " + MessageInfo.toString(event.getMessage()));
            ++j;
        }
        try {
            MidiSystem.write(sequence, 1, outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static MidiEvent createNoteOnEvent(int nKey, long lTick, int channel, int velocity) {
        return CSV2MIDI.createNoteEvent(144, nKey, velocity, lTick, channel);
    }

    private static MidiEvent createNoteOffEvent(int nKey, long lTick, int channel) {
        return CSV2MIDI.createNoteEvent(128, nKey, 0, lTick, channel);
    }

    private static MidiEvent createNoteEvent(int nCommand, int nKey, int nVelocity, long lTick, int channel) {
        ShortMessage message = new ShortMessage();
        try {
            message.setMessage(nCommand, channel, nKey, nVelocity);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            System.exit(1);
        }
        MidiEvent event = new MidiEvent(message, lTick);
        return event;
    }

    private static void printUsageAndExit() {
        CSV2MIDI.out("usage:");
        CSV2MIDI.out("java CSV2MIDI <infile.csv> <outfile.midi>");
        System.exit(1);
    }

    private static void out(String strMessage) {
        System.out.println(strMessage);
    }
}

