// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.brown;

import com.aliasi.hmm.HiddenMarkovModel;
import com.aliasi.hmm.HmmDecoder;
import com.aliasi.util.Streams;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.*;

/**
 * Performs the Part-of-Speech tagging using pre-built model file. The model is trained
 * using the Brown Corpus corpora. The project does not actually do the training; instead,
 * a pre-existing model file is used.
 * 
 * @author pnalyvayko
 *
 */
public final class HMMTagger {

	private HmmDecoder _decoder = null;
	private static Hashtable<String, HMMTagger> _taggers = null;
	
	protected HMMTagger() {
	}
	
	protected void loadModel(String modelFile) throws IOException, ClassNotFoundException {
		// Try loading the HMM model from a file on the disk
		boolean bLoadFromManifest = false;
		ObjectInputStream objIn = null;
		try
		{
	        FileInputStream fileIn = new FileInputStream(modelFile);
	        objIn = new ObjectInputStream(fileIn);
		}
		catch(Exception ex)
		{
			bLoadFromManifest = true;
		}
		if (bLoadFromManifest) {
			InputStream inputStream = this.getClass().getResourceAsStream("/" + modelFile);
			if (inputStream == null)
				throw new IOException(); 
	        objIn = new ObjectInputStream(inputStream);
		}
        HiddenMarkovModel hmm = (HiddenMarkovModel) objIn.readObject();
        Streams.closeInputStream(objIn);
        _decoder = new HmmDecoder(hmm);
	}
	
	public static HMMTagger getTagger(String modelFile) {
		if (_taggers == null) {
			_taggers = new Hashtable<String, HMMTagger>();
		}
		String filePath = modelFile.toUpperCase();
		HMMTagger instance = null;
		if (!_taggers.containsKey(filePath))
		{
			try
			{
				instance = new HMMTagger();
				instance.loadModel(modelFile);
				_taggers.put(filePath, instance);
			}
			catch(IOException ex) {
				System.out.println("IO Exception:" + ex.getMessage());
			}
			catch(ClassNotFoundException ex) {
				System.out.println("ClassLoader Exception:" + ex.getMessage());
			}
		} else {
			instance = _taggers.get(filePath);
		}
		return instance;
	}
	
	 public String[] firstBest(String[] tokens) {
        return _decoder.firstBest(tokens);
    }
	
}
