// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.Types;
import java.lang.reflect.Method;
//import java.lang.reflect.Type;
import java.lang.reflect.InvocationTargetException;;

/**
 * @author pnalyvayko
 *
 */
public class ReflectedFunction extends PostalFunction {

	private Object _instance;
	private Method _mi;
	
	public ReflectedFunction(String name, Object instance, Method mi) {
		super(name);
		_instance = instance;
		_mi = mi;
	}
	
	public PostalList arguments() {
		Class[] parameterTypes = _mi.getParameterTypes();
		PostalList paramList = (PostalList)PostalTypeFactory.createList("ARG_LIST");
		//UNDONE: fetch the parameter information and populate the argument list
		for (int i = 0; i < parameterTypes.length; i++)
			paramList.add(PostalTypeFactory.createString("ARGITEM", ""));
		return paramList;
	}
	
	public IPostalType invoke(PostalList argList) throws InvocationTargetException, IllegalAccessException {
		
		if (_mi.getReturnType() != IPostalType.class)
			return PostalTypeFactory.createError("Invalid return type.");
		
		Class[] parameterTypes = _mi.getParameterTypes();
		if (parameterTypes.length != argList.size())
			return PostalTypeFactory.createError("Specified number of parameters \"" + argList.size() + "\" does not match expected \"" + parameterTypes.length + "\"");
		
		// Validate the parameters and their types
		for(int i = 0; i < parameterTypes.length; i++) {
			Class t = parameterTypes[i]; 
			IPostalType arg = argList.get(i);
			if (!t.isInstance(arg)) {
				return PostalTypeFactory.createError("Expected \"" + t.getClass().getCanonicalName() + "\", but was given \"" + arg.getClass().getCanonicalName() + "\"");
			}
		}
		return (IPostalType)_mi.invoke(_instance, argList.toArray());
	}
	
	public String toString() {
		return "Reflected function \"" + this.getName() + "\"";
	}
}
