// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.Types;

/**
 * @author pnalyvayko
 *
 */
public class PostalVariable<T> implements IPostalType, IPostalVariable {

	private final String _name;
	private T _value;
	private Class<T> _class;
	
	public PostalVariable(Class<T> c, String n, T value) {
		_name = n;
		_value = value;
		_class = c;
	}
	
	public Class getVarClass() {
		return _class;
	}
	
	public boolean isValid() {
		return true;
	}
	
	public String getName() {
		return _name;
	}
	public T value() {
		return _value;
	}
	public void forceAssign(T value) {
		_value = value;
	}
	
	public PostalTypeKind getKind() {
		return PostalTypeKind.eKindValue;
	}
	
	public IPostalType assign(IPostalType rhs) {
		if (canAssign(rhs))
		{
			return PostalOperations.instance().assign(this, rhs);
		}
		return this;
	}
	
	public IPostalType convert(Class c) {
		return PostalOperations.instance().convert(this,  c);
	}
	
	public boolean canAssign(IPostalType rhs) {
		return PostalOperations.instance().canAssign(this, rhs);
	}
	
	public IPostalType clone() throws CloneNotSupportedException {
		PostalVariable cloned = (PostalVariable)super.clone();
		
		return cloned;
	}
	
	public String toString() {
		return _value.toString();
	}
	
	public boolean isNil() {
		return false;
	}
}
