// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.Types;
import java.lang.reflect.Method;
//import java.lang.reflect.Type;

/**
 * @author pnalyvayko
 *
 */
public final class PostalTypeFactory {

	public static IPostalType createInteger(String name, Integer val) {
		return new IntegerVariable(name, val);
	}
	public static IPostalType createDouble(String name, Double val) {
		return new DoubleVariable(name, val);
	}
	public static IPostalType createBoolean(String name, Boolean val) {
		return new BooleanVariable(name, val);
	}
	public static IPostalType createString(String name, String val) {
		return new StringVariable(name, val);
	}
	public static IPostalType createError(String errMsg) {
		return new PostalError(errMsg);
	}
	public static IPostalType createError(String errMsg, String errSource) {
		return new PostalError(errMsg, errSource);
	}
	public static IPostalType createObject(String name, Object val) {
		if (val instanceof Integer) {
			return createInteger(name, (Integer)val);
		}
		else if (val instanceof Double) {
			return createDouble(name, (Double)val);
		}
		else if (val instanceof Boolean) {
			return createBoolean(name, (Boolean)val);
		}
		else if (val instanceof String) {
			return createString(name, (String)val);
		}
		return new PostalVariable<Object>(Object.class, name, val);
	}
	public static IPostalType createScope(String scopeName) {
		return new PostalScope(scopeName);
	}
	
	public static IPostalType createNil() {
		return new PostalNilPtr();
	}
	
	public static IPostalType createList(String listName) {
		return new PostalList(listName, new PostalLinkedListStrategy());
	}
	
	public static IPostalType createFunctionInterpreter(String name, PostalList argList, Object implementation) {
		return new PostalFunctionInterpreter(name, argList, implementation);
	}
	
	public static IPostalType createVariable(String name) {
		return new PostalLink(name, new IntrinsicLinkValue(PostalTypeFactory.createNil()));
	}
	
	public static IPostalType createVariable(String name, IPostalType intrinsicValue) {
		if (intrinsicValue instanceof PostalLink)
			intrinsicValue = ((PostalLink)intrinsicValue).resolve();
		return new PostalLink(name, new IntrinsicLinkValue(intrinsicValue));
	}
	
	public static IPostalType createReflectedFunction(String name, Object instance, Method mi) {
		return new ReflectedFunction(name, instance, mi);
	}
	
	public static IPostalType createMap(String name) {
		return new PostalSet(name, new PostalHashtableStrategy());
	}
}
