/**
 * 
 */
package WS4115.Projects.Postal.Types;

/**
 * @author pnalyvayko
 *
 */
public class PostalSet implements IPostalType, IByRef {

	private IPostalSetStrategy _strat;
	private String _name;
	
	public PostalSet(String name, IPostalSetStrategy strat) {
		_name = name;
		_strat = strat;
	}
	
	public IPostalType clone() throws CloneNotSupportedException {
		PostalSet cloned = (PostalSet)super.clone();
		cloned._strat = _strat.clone(this);
		return cloned;
	}
	
	public IPostalType reconstruct(PostalSet rhs) {
		_strat = rhs._strat;
		return this;
	}
	
	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#assign(WS4115.Projects.Postal.Types.IPostalType)
	 */
	public IPostalType assign(IPostalType rhs) {
		if (canAssign(rhs)) {
			if (rhs instanceof PostalSet) {
				return _strat.assign(this, (PostalSet)rhs);
			}
		}
		return PostalTypeFactory.createError("The right-hand side is not a set.");
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#canAssign(WS4115.Projects.Postal.Types.IPostalType)
	 */
	public boolean canAssign(IPostalType rhs) {
		if (rhs instanceof PostalLink)
			rhs = ((PostalLink)rhs).resolve();
		if (rhs instanceof PostalSet)
			return true;
		return false;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#getKind()
	 */
	public PostalTypeKind getKind() {
		// TODO Auto-generated method stub
		return PostalTypeKind.eKindSet;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#getName()
	 */
	public String getName() {
		// TODO Auto-generated method stub
		return _name;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#isNil()
	 */
	public boolean isNil() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#isValid()
	 */
	public boolean isValid() {
		// TODO Auto-generated method stub
		return _strat != null ? true : false;
	}

	public int size() {
		return _strat.size(this);
	}
	public void put(String key, IPostalType elem) {
		_strat.put(this, key, elem);
	}
	public IPostalType get(String key) {
		return _strat.get(this, key);
	}
	public PostalList keys() {
		return _strat.keys(this);
	}
	public PostalList values() {
		return _strat.values(this);
	}
	public void remove(String key) {
		_strat.remove(this, key);
	}
	
	public boolean containsKey(String key) {
		return _strat.containsKey(this, key);
	}
	
	public String toString() {
		return _strat.toString(this);
	}
}
