// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.Types;

import java.util.*;
import java.lang.StringBuilder;

/**
 * Declares a scope which is a container of other objects. The scope can be a global scope, function scope
 * or a nested scope.
 *  
 * @author pnalyvayko
 *
 */
public class PostalScope implements IPostalType {

	private Hashtable<String, IPostalType> _scope;
	private String _name;
	private PostalScopeFlags _flags;
	
	public PostalScope(String name) {
		_name = name;
		_scope = new Hashtable<String, IPostalType>();
		_flags = PostalScopeFlags.eNone;
	}
	
	public PostalScopeFlags getFlags() {
		return _flags;
	}
	public void putFlags(PostalScopeFlags flags) {
		_flags = flags;
	}
	
	public String getName()	{ 
		return _name; 
	}
	
	public void put(IPostalType var) {
		_scope.put(var.getName(), var);
	}
	
	public boolean contains(String key) {
		return _scope.containsKey(key);
	}
	
	public void remove(String key) {
		_scope.remove(key);
	}
	
	public IPostalType get(String key) {
		return _scope.get(key);
	}
	
	public int size() {
		return _scope.size();
	}
	
	public Enumeration<String> keys() {
		return _scope.keys();
	}
	
	public PostalTypeKind getKind() {
		return PostalTypeKind.eKindScope;
	}
	
	public boolean isValid() {
		return true;
	}
	
	public IPostalType assign(IPostalType rhs) {
		if (rhs instanceof PostalScope) {
			PostalScope rhsScope = (PostalScope)rhs;
			Iterator<String> it = rhsScope._scope.keySet().iterator();
			while (it.hasNext()) {
				String k = it.next();
				if (_scope.containsKey(k)) {
					_scope.get(k).assign(rhsScope.get(k));
				}
			}
			return this;
		}
		return PostalTypeFactory.createError("Expected a scope on the right side.");
	}
	
	public boolean canAssign(IPostalType rhs) {
		if (rhs instanceof PostalScope)
			return true;
		return false;
	}
	
	public IPostalType clone() throws CloneNotSupportedException {
		
		PostalScope s = (PostalScope)super.clone();
		s._scope = new Hashtable<String, IPostalType>(); 

		Iterator<Map.Entry<String, IPostalType>> it = _scope.entrySet().iterator();
		
		while(it.hasNext()) {
			Map.Entry<String, IPostalType> entry = it.next();
			s._scope.put(entry.getKey(), entry.getValue().clone());
		}
		
		return s;
	}
	
	public boolean isNil() {
		return false;
	}
	
	public String toString() {
		Iterator<Map.Entry<String, IPostalType>> it = _scope.entrySet().iterator();

		StringBuilder sb = new StringBuilder();
		while(it.hasNext()) {
			Map.Entry<String, IPostalType> entry = it.next();
			sb.append(" (" + entry.getKey() + " . " + entry.getValue().toString() + ") ");
		}
		return sb.toString();
	}
}
