// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
package WS4115.Projects.Postal.Types;

public class PostalList implements IPostalType, IByRef {

	private String _name;
	private IPostalListStrategy _strat;

	public PostalList(String name, IPostalListStrategy strat) {
		_name = name;
		_strat = strat;
	}
	
	public int size() {
		return _strat.size(this);
	}
	
	public IPostalType get(int pos) {
		return _strat.get(this, pos);
	}
	
	public int add(IPostalType item) {
		return _strat.add(this, item);
	}
	
	public PostalList reconstruct(PostalList lhs) throws CloneNotSupportedException {
		_strat = lhs._strat;
		return this;
	}
	
	public void insert(int pos, IPostalType item) {
		_strat.insert(this, pos, item);
	}
	
	public void removeAt(int pos) {
		_strat.removeAt(this, pos);
	}
	
	public void clear() {
		_strat.clear(this);
	}
	
	public String getName() {
		return _name;
	}
	
	public IPostalType assign(IPostalType rhs) {
		return _strat.assign(this, rhs);
	}
	
	public boolean canAssign(IPostalType rhs) {
		return _strat.canAssign(this, rhs);
	}
	
	public PostalTypeKind getKind() {
		// TODO Auto-generated method stub
		return PostalTypeKind.eKindList;
	}
	
	public boolean isValid() {
		return _strat != null ? true : false;
	}

	public IPostalType clone() throws CloneNotSupportedException {
		Object cloned = super.clone();
		
		PostalList l = (PostalList)cloned;
		l._strat = _strat.clone(this);
		
		return l;
	}
	
	public boolean isNil() {
		return false;
	}
	
	public Object[] toArray() {
		return _strat.toArray(this);
	}
	
	public PostalList tail() {
		return new PostalList("Tail of " + this.getName(), _strat.tail(this));
	}
	
	public PostalList head() {
		return new PostalList("Head of " + this.getName(), _strat.head(this));
	}
	
	public String toString() {
		return _strat.toString(this);
	}
}
