// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.Types;

/**
 * @author pnalyvayko
 *
 */
public final class PostalLink implements IPostalType {

	private String _name;
	private IPostalLinkResolver _resolver;
	
	public PostalLink(String name, IPostalLinkResolver resolver) {
		_name = name;
		_resolver = resolver;
	}
	
	public IPostalType resolve() {
		if (_resolver != null) {
			return _resolver.resolve(this);
		}
		return null;
	}
	
	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#assign(WS4115.Projects.Postal.Types.IPostalType)
	 */
	public IPostalType assign(IPostalType rhs) {
		// TODO Auto-generated method stub
		//System.out.println("assignining  " + rhs.toString());
		if (!canAssign(rhs))
		{
			//System.out.println("Cannot assign...");
			return this;
		}
		if (_resolver != null) {
			IPostalType resolved = _resolver.resolve(this);
			if (resolved != null) {
				if (rhs instanceof PostalLink) {
					rhs = ((PostalLink)rhs).resolve();
					if (rhs == null) {
						//System.out.println("Invalid link...");
						return PostalTypeFactory.createError("Invalid link.");
					}
				}
				if (resolved instanceof PostalNilPtr) {
					try
					{
						IPostalType copy;
						if (!(rhs instanceof IByRef)) {
							copy = rhs.clone();
						}
						else {
							//System.out.println("Detected IByRef interface.");
							copy = rhs;
						}
						_resolver = new IntrinsicLinkValue(copy);
					}
					catch(CloneNotSupportedException ex)
					{
						_resolver = new IntrinsicLinkValue(PostalTypeFactory.createError("Cannot clone the right side."));
					}
					return rhs;
				} else {
					return resolved.assign(rhs);
				}
			}
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#canAssign(WS4115.Projects.Postal.Types.IPostalType)
	 */
	public boolean canAssign(IPostalType rhs) {
		IPostalType resolved = resolve();
		if (rhs instanceof PostalLink) {
			rhs = ((PostalLink)rhs).resolve();
			if (rhs == null)
				return false;
		}
		return resolved != null ? (resolved instanceof PostalNilPtr) || resolved.canAssign(rhs) : false;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#getKind()
	 */
	public PostalTypeKind getKind() {
		// TODO Auto-generated method stub
		return PostalTypeKind.eKindLink;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#getName()
	 */
	public String getName() {
		// TODO Auto-generated method stub
		return _name;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#isNil()
	 */
	public boolean isNil() {
		// TODO Auto-generated method stub
		if (_resolver != null) {
			IPostalType resolved = _resolver.resolve(this);
			return resolved != null ? resolved.isNil() : false;
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#isValid()
	 */
	public boolean isValid() {
		// TODO Auto-generated method stub
		if (_resolver != null) {
			IPostalType resolved = _resolver.resolve(this);
			return resolved != null ? resolved.isValid() : false;
		}
		return false;
	}

	public IPostalType clone() throws CloneNotSupportedException {
		PostalLink cloned = (PostalLink)this.clone();
		
		if (_resolver != null) {
			IPostalType innerValue = _resolver.resolve(this);
			_resolver = new IntrinsicLinkValue(innerValue.clone());
		}
		return cloned;
	}
	
	public String toString() {
		if (_resolver != null) {
			IPostalType resolved = _resolver.resolve(this);
			return resolved.toString();
		}
		return super.toString();
	}
}
