/**
 * 
 */
package WS4115.Projects.Postal.Types;

import java.util.Map;
import java.util.Hashtable;

/**
 * @author pnalyvayko
 *
 */
public class PostalHashtableStrategy implements IPostalSetStrategy {

	private Map<String, IPostalType> _map;
	
	public PostalHashtableStrategy() {
		_map = new Hashtable<String, IPostalType>();
	}
	
	public IPostalType assign(PostalSet lhs, PostalSet rhs) {
		return lhs.reconstruct(rhs);
	}
	
	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalSetStrategy#clone(WS4115.Projects.Postal.Types.PostalSet)
	 */
	public IPostalSetStrategy clone(PostalSet lhs)
			throws CloneNotSupportedException {
		// TODO Auto-generated method stub
		PostalHashtableStrategy cloned = (PostalHashtableStrategy)super.clone();
		cloned._map = new Hashtable<String, IPostalType>();
		
		for(String key : _map.keySet()) {
			cloned._map.put(key, _map.get(key));
		}
		
		return cloned;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalSetStrategy#get(WS4115.Projects.Postal.Types.PostalSet, java.lang.String)
	 */
	public IPostalType get(PostalSet lhs, String key) {
		// TODO Auto-generated method stub
		return _map.get(key);
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalSetStrategy#keys(WS4115.Projects.Postal.Types.PostalSet)
	 */
	public PostalList keys(PostalSet lhs) {
		// TODO Auto-generated method stub
		PostalList l = (PostalList)PostalTypeFactory.createList("KEYS_LIST");
		for(String key:_map.keySet())
			l.add(PostalTypeFactory.createString("KEY", key));
		return l;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalSetStrategy#put(WS4115.Projects.Postal.Types.PostalSet, java.lang.String, WS4115.Projects.Postal.Types.IPostalType)
	 */
	public void put(PostalSet lhs, String key, IPostalType elem) {
		// TODO Auto-generated method stub

		_map.put(key, elem);
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalSetStrategy#remove(WS4115.Projects.Postal.Types.PostalSet, java.lang.String)
	 */
	public void remove(PostalSet lhs, String key) {
		// TODO Auto-generated method stub
		_map.remove(key);
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalSetStrategy#size(WS4115.Projects.Postal.Types.PostalSet)
	 */
	public int size(PostalSet lhs) {
		// TODO Auto-generated method stub
		return _map.size();
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalSetStrategy#values(WS4115.Projects.Postal.Types.PostalSet)
	 */
	public PostalList values(PostalSet lhs) {
		PostalList l = (PostalList)PostalTypeFactory.createList("KEYS_LIST");
		for(IPostalType value:_map.values())
			l.add(value);
		return l;
	}
	
	public boolean containsKey(PostalSet lhs, String key) {
		return _map.containsKey(key);
	}

	public String toString(PostalSet lhs) {
		StringBuilder sb = new StringBuilder();
		for(Map.Entry<String, IPostalType> entry : _map.entrySet())
		{
			if (sb.length() != 0)
				sb.append(' ');
			sb.append('(');
			sb.append(entry.getKey());
			sb.append(' ');
			sb.append(entry.getValue());
			sb.append(')');
		}
		sb.insert(0, '(');
		sb.append(")");
		return sb.toString();
	}
	
}
