// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.Types;

/**
 * @author pnalyvayko
 *
 */
public final class PostalFunctionInterpreter extends PostalFunction {

	private PostalList _argList;
	private Object _implementation;
	
	public PostalFunctionInterpreter(String name, PostalList argList, Object impl) {
		super(name);
		_argList = argList;
		_implementation = impl;
	}
	
	public PostalList arguments() {
		return _argList;
	}
	
	public Object getImplementation() {
		return _implementation;
	}

	public String toString() {
		return "User-defined function: \"" + this.getName() + "\"";
	}
}
