// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
package WS4115.Projects.Postal.Types;

public abstract class PostalFunction implements IPostalType {
	
	private String _name;
	
	public PostalFunction(String name) {
		_name = name;
	}
	
	public String getName() {
		return _name;
	}
	/**
	 * Returns a list of arguments.
	 * @return
	 */
	public abstract PostalList arguments();
	
	public PostalTypeKind getKind() {
		// TODO Auto-generated method stub
		return PostalTypeKind.eKindFunction;
	}
	
	public IPostalType assign(IPostalType rhs) {
		// Assign simply returns the current instance
		return this;
	}
	
	public boolean canAssign(IPostalType rhs) {
		return false;
	}
	
	public boolean isValid() {
		return true;
	}

	public IPostalType clone() throws CloneNotSupportedException {
		
		Object cloned = super.clone();
		
		//PostalFunction f = (PostalFunction)cloned;
		
		return (IPostalType)cloned;
	}
	
	public boolean isNil() {
		return false;
	}
}
