// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.Types;

/**
 * @author pnalyvayko
 *
 */
public class PostalError implements IPostalType {

	private String _errMsg;
	private String _errSource;
	
	public PostalError(String errMsg) {
		_errMsg = errMsg;
		_errSource = "";
	}
	
	public String getName() {
		return "Error Object";
	}
	
	public PostalError(String errMsg, String errSource) {
		_errMsg = errMsg;
		_errSource = errSource;
	}
	public String getMessage() {
		return _errMsg;
	}
	public String getSource() {
		return _errSource;
	}
	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#assign(WS4115.Projects.Postal.Types.IPostalType)
	 */
	public IPostalType assign(IPostalType rhs) {
		if (rhs != null && rhs.getKind() == PostalTypeKind.eKindError) {
			PostalError rhsError = (PostalError)rhs;
			_errMsg = rhsError._errMsg;
			_errSource = rhsError._errSource;
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#canAssign(WS4115.Projects.Postal.Types.IPostalType)
	 */
	public boolean canAssign(IPostalType rhs) {
		if (rhs != null && rhs.getKind() == PostalTypeKind.eKindError) {
			return true;
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#getKind()
	 */
	public PostalTypeKind getKind() {
		return PostalTypeKind.eKindError;
	}

	/* (non-Javadoc)
	 * @see WS4115.Projects.Postal.Types.IPostalType#isValid()
	 */
	public boolean isValid() {
		return false;
	}

	public IPostalType clone() throws CloneNotSupportedException {
		
		Object cloned = super.clone();
		
		PostalError e = (PostalError)cloned;
		e._errMsg = _errMsg;
		e._errSource = _errSource;
		
		return (IPostalType)cloned;
	}
	
	public boolean isNil() {
		return false;
	}
	
	public String toString() {
		return _errMsg;
	}
}
