// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.Types;

/**
 * @author pnalyvayko
 *
 */
public final class OROperations {

	private static OROperations _instance;
	public static OROperations instance() {
		if (_instance == null) {
			_instance = new OROperations();
		}
		return _instance;
	}
	public class DoBoolean2Boolean extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			BooleanVariable i1 = (BooleanVariable)lhs;
			BooleanVariable i2 = (BooleanVariable)rhs;
			return PostalTypeFactory.createBoolean("", i1.value().booleanValue() || i2.value().booleanValue());
		}
	}
}
