// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
package WS4115.Projects.Postal.Types;

/**
 * IPostalType interface is a base interface for any class used by the POSTAL compiler.
 * The derived classes represent various aspects of the system, such as scopes,  functions,
 * lists and variables.
 * @author pnalyvayko
 *
 */
public interface IPostalType extends Cloneable {

	/**
	 * Returns a name of the instance.
	 * @return
	 */
	public String getName();
	/**
	 * Assigns the rhs object to the current instance. The object returned by the method is used to verify
	 * if the assignment has succeeded.    
	 * @param rhs
	 * @return if the return value's isValid method returns false, then the 
	 * assignment has failed. 
	 */
	public IPostalType assign(IPostalType rhs);
	/**
	 * Returns true if the rhs object can be assigned to the current instance.
	 * @param rhs
	 * @return
	 */
	public boolean canAssign(IPostalType rhs);
	/**
	 * Returns the instance's kind.
	 * @return
	 */
	public PostalTypeKind getKind();
	/**
	 * Returns whether the instance is valid. 
	 * @return
	 */
	public boolean isValid();
	/**
	 * Creates a deep copy of the object.
	 * @return
	 */
	public IPostalType clone() throws CloneNotSupportedException;
	/**
	 * Returns true if the instance is Nil.
	 * @return
	 */
	public boolean isNil();
}
