// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.Types;

/**
 * @author pnalyvayko
 *
 */
public interface IPostalListStrategy extends Cloneable {

	int size(PostalList lhs);
	IPostalType get(PostalList lhs, int pos);
	int add(PostalList lhs, IPostalType item);
	void insert(PostalList lhs, int pos, IPostalType item);
	void removeAt(PostalList lhs, int pos);
	void clear(PostalList lhs);
	IPostalType assign(PostalList lhs, IPostalType rhs);
	boolean canAssign(PostalList lhs, IPostalType rhs);
	IPostalListStrategy clone(PostalList lhs) throws CloneNotSupportedException;
	Object[] toArray(PostalList lhs);
	IPostalListStrategy tail(PostalList lhs);
	String toString(PostalList lhs);
	IPostalListStrategy head(PostalList lhs);
}
