// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
package WS4115.Projects.Postal.Types;

import WS4115.Projects.Postal.Grammar.*;
import antlr.*;
import antlr.collections.*;

public final class ExpressionResolver implements IPostalLinkResolver {

	private Object _expr;
	
	public ExpressionResolver(Object expr) {
		_expr = expr;
	}
	
	public IPostalType resolve(PostalLink lhs) {
		Object result = null;

		// No expression was specified
		if (_expr == null) {
			result = PostalTypeFactory.createNil();
		}
		else {
			POSTALWalker walker = (POSTALWalker)PostalEnv.instance().getInterpreter();
			try
			{
				result = walker.expression((AST)_expr);
			}
			catch(RecognitionException ex) {
				result = PostalTypeFactory.createError(ex.getLocalizedMessage(), ex.getFilename());
			}
		}
		return (IPostalType)result;
	}

}
