// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
/**
 * 
 */
package WS4115.Projects.Postal.Types;

/**
 * @author pnalyvayko
 *
 */
public final class DivideOperations {

	private static DivideOperations _instance;
	public static DivideOperations instance() {
		if (_instance == null) {
			_instance = new DivideOperations();
		}
		return _instance;
	}
	
	public class DoInt2Int extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			IntegerVariable i1 = (IntegerVariable)lhs;
			IntegerVariable i2 = (IntegerVariable)rhs;
			return PostalTypeFactory.createInteger("", i1.value() / i2.value());
		}
	}
	public class DoDouble2Int extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			IntegerVariable i1 = (IntegerVariable)lhs;
			DoubleVariable i2 = (DoubleVariable)rhs;
			return PostalTypeFactory.createInteger("", i1.value() / i2.value().intValue());
		}
	}
	public class DoBoolean2Int extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			IntegerVariable i1 = (IntegerVariable)lhs;
			BooleanVariable i2 = (BooleanVariable)rhs;
			return PostalTypeFactory.createInteger("", i1.value() / (i2.value()?1:-1));
		}
	}
	public class DoString2Int extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			IntegerVariable i1 = (IntegerVariable)lhs;
			StringVariable i2 = (StringVariable)rhs;
			return PostalTypeFactory.createInteger("", i1.value() / Integer.parseInt(i2.value()));
		}
	}

	public class DoDouble2Double extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			DoubleVariable i1 = (DoubleVariable)lhs;
			DoubleVariable i2 = (DoubleVariable)rhs;
			return PostalTypeFactory.createDouble("", i1.value() / i2.value());
		}
	}
	public class DoInt2Double extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			DoubleVariable i1 = (DoubleVariable)lhs;
			IntegerVariable i2 = (IntegerVariable)rhs;
			return PostalTypeFactory.createDouble("", i1.value() / i2.value().doubleValue());
		}
	}
	public class DoBoolean2Double extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			DoubleVariable i1 = (DoubleVariable)lhs;
			BooleanVariable i2 = (BooleanVariable)rhs;
			return PostalTypeFactory.createDouble("", i1.value() / (i2.value() ? 1.0 : -1.0));
		}
	}
	public class DoString2Double extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			DoubleVariable i1 = (DoubleVariable)lhs;
			StringVariable i2 = (StringVariable)rhs;
			return PostalTypeFactory.createDouble("", i1.value() / Double.parseDouble(i2.value()));
		}
	}
}
