// This is a part of the POSTAL language package.
// Copyright (C) Peter Nalyvayko (c) 2008
// All rights reserved.
//
// Programming Languages and Translators
// COMS WS4115
// Prof. Stephen Edwards
//
// This source code is only intended as a supplement to the
// POSTAL Language Reference and related
// electronic documentation provided with the language.
// See these sources for detailed information regarding the	
// POSTAL Language product.
//
package WS4115.Projects.Postal.Types;

public class AssignOperations {

	private static AssignOperations _instance;
	public static AssignOperations instance() {
		if (_instance == null) {
			_instance = new AssignOperations();
		}
		return _instance;
	}
	
	public class DoInt2Int extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			IntegerVariable i1 = (IntegerVariable)lhs;
			IntegerVariable i2 = (IntegerVariable)rhs;
			i1.forceAssign(i2.value());
			return i1;
		}
	}
	public class DoDouble2Int extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			IntegerVariable i1 = (IntegerVariable)lhs;
			DoubleVariable i2 = (DoubleVariable)rhs;
			i1.forceAssign(i2.value().intValue());
			return i1;
		}
	}
	public class DoBoolean2Int extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			IntegerVariable i1 = (IntegerVariable)lhs;
			BooleanVariable i2 = (BooleanVariable)rhs;
			i1.forceAssign(i2.value() ? 1 : 0);
			return i1;
		}
	}
	public class DoString2Int extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			IntegerVariable i1 = (IntegerVariable)lhs;
			StringVariable i2 = (StringVariable)rhs;
			i1.forceAssign(Integer.parseInt(i2.value()));
			return i1;
		}
	}

	public class DoDouble2Double extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			DoubleVariable i1 = (DoubleVariable)lhs;
			DoubleVariable i2 = (DoubleVariable)rhs;
			i1.forceAssign(i2.value());
			return i1;
		}
	}
	public class DoInt2Double extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			DoubleVariable i1 = (DoubleVariable)lhs;
			IntegerVariable i2 = (IntegerVariable)rhs;
			i1.forceAssign(i2.value().doubleValue());
			return i1;
		}
	}
	public class DoBoolean2Double extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			DoubleVariable i1 = (DoubleVariable)lhs;
			BooleanVariable i2 = (BooleanVariable)rhs;
			i1.forceAssign((i2.value() ? 1.0 : 0.0));
			return i1;
		}
	}
	public class DoString2Double extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			DoubleVariable i1 = (DoubleVariable)lhs;
			StringVariable i2 = (StringVariable)rhs;
			i1.forceAssign(Double.parseDouble(i2.value()));
			return i1;
		}
	}
	
	public class DoBoolean2Boolean extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			BooleanVariable i1 = (BooleanVariable)lhs;
			BooleanVariable i2 = (BooleanVariable)rhs;
			i1.forceAssign(i2.value());
			return i1;
		}
	}
	public class DoInteger2Boolean extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			BooleanVariable i1 = (BooleanVariable)lhs;
			IntegerVariable i2 = (IntegerVariable)rhs;
			i1.forceAssign(i2.value() == 0 ? false : true);
			return i1;
		}
	}
	public class DoDouble2Boolean extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			BooleanVariable i1 = (BooleanVariable)lhs;
			DoubleVariable i2 = (DoubleVariable)rhs;
			i1.forceAssign(i2.value().intValue() == 0 ? false : true);
			return i1;
		}
	}
	public class DoString2Boolean extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			BooleanVariable i1 = (BooleanVariable)lhs;
			DoubleVariable i2 = (DoubleVariable)rhs;
			i1.forceAssign(i2.value().intValue() == 0 ? false : true);
			return i1;
		}
	}
	
	public class DoString2String extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			StringVariable i1 = (StringVariable)lhs;
			StringVariable i2 = (StringVariable)rhs;
			i1.forceAssign(i2.value());
			return i1;
		}
	}
	public class DoInteger2String extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			StringVariable i1 = (StringVariable)lhs;
			IntegerVariable i2 = (IntegerVariable)rhs;
			i1.forceAssign(i2.value().toString());
			return i1;
		}
	}
	public class DoDouble2String extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			StringVariable i1 = (StringVariable)lhs;
			DoubleVariable i2 = (DoubleVariable)rhs;
			i1.forceAssign(i2.value().toString());
			return i1;
		}
	}
	public class DoBoolean2String extends OpClass implements IBinaryOp {
		public IPostalType invoke(PostalVariable lhs, PostalVariable rhs) {
			StringVariable i1 = (StringVariable)lhs;
			BooleanVariable i2 = (BooleanVariable)rhs;
			i1.forceAssign(i2.value().toString());
			return i1;
		}
	}
	
	
}
