header {
package WS4115.Projects.Postal.Grammar;
}

options
{
	language = "Java";
}

class POSTALParser extends Parser;

options
{
	k=2;
	importVocab=POSTAL;
	buildAST=true;
}

tokens { 
	ELIST; METHOD_CALL; DECL_SCOPE; DECL_VAR; DECL_METHOD; EXPLIST; VAR_INITIALIZER;
}


{
	private boolean _errorOccured = false;
	
	public void reportError(RecognitionException ex) {
		_errorOccured = true;
		super.reportError(ex);
	}
	
	public boolean hasErrorOccured () {
		return _errorOccured;
	}
	
	public void reportError(String error) {
		_errorOccured = true;
		super.reportError(error);
	}
}

// The root element represents the entire .postal program
program
	: (declaration)* EOF!
	;
	
declaration
	: (variableDeclaration) => variableDeclaration
	| functionDeclaration
	;

variableDeclaration
	: LITERAL_var! ID variableInitializer SEMI!
		{#variableDeclaration = #(#[DECL_VAR, "DECL_VAR"], #variableDeclaration); }
	;
	
inlineVariableDeclaration
	: LITERAL_var! variableInitializer 
		{#inlineVariableDeclaration = #(#[DECL_VAR, "DECL_VAR"], #inlineVariableDeclaration); }
	;

functionDeclaration
	: LITERAL_function! ID LPAREN! argList RPAREN! functionBody
	{ #functionDeclaration = #(#[DECL_METHOD, "DECL_METHOD"], #functionDeclaration); }
	;

private
variableInitializer
	: (ASSIGN! expression)?
		{ #variableInitializer = #(#[VAR_INITIALIZER, "VAR_INITIALIZER"], #variableInitializer); }
	;
	
functionBody
	: scopeStatement
	;
	
lambdaExpressionBody
	: functionBody
	;
	
lambdaActionBody
	: scopeStatement
	;
	
lambdaExpression
	: LITERAL_lambda^ LPAREN! argList RPAREN! lambdaExpressionBody
	;	
	
statement
	: variableDeclaration
	| expression SEMI!
	| scopeStatement
	| if_statement
	| while_statement
	| dolist_statement
	| returnStatement 
	| SEMI!
	;

returnStatement
	: LITERAL_return^ (expression)? SEMI!
	;	
	
if_statement
	: LITERAL_if^ LPAREN! expr COMMA! expression (COMMA! expression)? RPAREN!
	// statement (options {greedy=true;}: LITERAL_else statement)? 
	;
	
while_statement
	: LITERAL_while^ LPAREN! expr COMMA! expression RPAREN!
	;
	
dolist_statement
	: LITERAL_dolist^ LPAREN! sequenceExpression COMMA! 
		(lambdaExpression|identifier)
		RPAREN!
	;

scopeStatement
	: LCURLY! (statement)* RCURLY!
		{#scopeStatement = #(#[DECL_SCOPE, "DECL_SCOPE"], #scopeStatement); }
	;

argList
	:	(identifier (COMMA! identifier)*
	| /* nothing */
	)
		{#argList = #(#[ELIST,"ELIST"], #argList);}
	;
	
// A list of expressions.
expressionList
	:	(expression (COMMA! expression)*
	| /* nothing */
	)
		{#expressionList = #(#[EXPLIST,"EXPLIST"], #expressionList);}
	;
	
expression	
	: assignmentExpression
	;
	
assignmentExpression
	: conditionalExpression (
		options { greedy=true; }: 
			ASSIGN^ assignmentExpression
		)*
	;

expr
	: conditionalExpression
	;
	
conditionalExpression
	: additionExpression (
		(EQ^|NEQ^|LT^|GT^|GTE^|LTE^|AND^|OR^) additionExpression
		)?
	;
	
additionExpression
	: multiplicationExpression (
		(PLUS^|MINUS^) multiplicationExpression
		)*
	;

multiplicationExpression
	: primaryExpression (
		(STAR^|DIV^) primaryExpression
		)*
	;
	
primaryExpression
	: primaryIdentExpression
	| NUM_CONST
	| CHAR_LITERAL
	| STRING_LITERAL
	| MINUS^ primaryExpression
	| LITERAL_true
	| LITERAL_nil
	| numericExpression	
	| (LPAREN! expression RPAREN!)
	| lambdaExpression
	| evaluationExpression
	;
	
evaluationExpression
	: LITERAL_apply^ LPAREN! (identifier | lambdaExpression) (COMMA! expressionList)? RPAREN!
	; 
	
identifier
	: ID
    ;
    
primaryIdentExpression
	: ID^
		(lp:LPAREN^ {#lp.setType(METHOD_CALL); #lp.setText("METHOD_CALL");} expressionList RPAREN! )?
	;
	
numericExpression
	: LITERAL_numeric^ LPAREN! expr RPAREN!
	;	
	
sequenceExpression
	: primarySequenceExpession
	;	
	
primarySequenceExpession
	: primaryIdentExpression
	| STRING_LITERAL
	;
