header 
{ 
package WS4115.Projects.Postal.Grammar; 
}

options
{
	language = "Java";
}

class POSTALLexer extends Lexer;

options {
	k=6; // increased the number of lookahead symbols to prevent ANTLR warnings for ML_COMMENT token
	exportVocab=POSTAL;
	testLiterals=false;
}

tokens {
	"function"; "var"; "if"; "nil"; "true"; "return"; 
	"while"; "dolist"; "lambda"; "numeric"; "apply";
}

SL_COMMENT: "//"
	(~'\n')* '\n'
	{ _ttype = Token.SKIP; newline(); }
	;

ML_COMMENT 
	:	"/*" 
		(	
			/* the rules '\r\n' and '\r' cause the ambiquity therefore turning the warnings off.
			*/
			options {
				generateAmbigWarnings=false;
			}
		: { LA(2)!='/' }? '*'
		|	'\r' '\n'		{newline();}
		|	'\r'			{newline();}
		|	'\n'			{newline();}
		|	~('*'|'\n'|'\r')
		)*
		"*/"
			{ $setType(Token.SKIP); }
	;
	
LPAREN
options {
	paraphrase="'('";
}
	:	'('
	;

RPAREN
options {
	paraphrase="')'";
}
	:	')'
	;

LCURLY
options {
	paraphrase="'{'";
}
	:	'{'
	;

RCURLY
options {
	paraphrase="'}'";
}
	:	'}'
	;

STAR
options {
	paraphrase="'*'";
}
	:	'*'
	;
	
MINUS
options {
	paraphrase="'-'";
}
	:	'-'
	;

PLUS
options {
	paraphrase="'+'";
}
	:	'+'
	;

DIV
options {
	paraphrase="'/'";
}
	:	'/'
	;
	
ASSIGN
options {
	paraphrase="'='";
}
	:	'='
	;

SEMI
options {
	paraphrase="';'";
}
	:	';'
	;

COMMA
options {
	paraphrase="','";
}
	:	','
	;
	
EQ
	: "=="
	;

NEQ
	: "!="
	;
GT
	: '>'
	;

LT
	: '<'
	;
GTE
	: ">="
	;
LTE
	: "<="
	;
AND
	: "&&"
	;
	
OR
	: "||"
	;
	
CHAR_LITERAL
options {
	paraphrase="a char";
}
	:	'\'' (ESC|~'\'') '\''
	;

STRING_LITERAL
options {
	paraphrase="a string";
}
	:	'"' (ESC|~'"')* '"'
	;

protected
ESC	:	'\\'
		(	'n'
		|	'r'
		|	't'
		|	'b'
		|	'f'
		|	'"'
		|	'\''
		|	'\\'
		|	'0'..'3'
			(
				options {
					warnWhenFollowAmbig = false;
				}
			:	DIGIT
				(
					options {
						warnWhenFollowAmbig = false;
					}
				:	DIGIT
				)?
			)?
		|	'4'..'7'
			(
				options {
					warnWhenFollowAmbig = false;
				}
			:	DIGIT
			)?
		)
	;

protected
DIGIT
	:	'0'..'9'
	;

protected
DOT: '.'  
	;	

protected 
NUM_INT            
	: (DIGIT)+    
	;
	
protected 
NUM_FLOAT
	: '.' (DIGIT)+ 
	;

NUM_CONST   
	: NUM_INT (NUM_FLOAT) ? (EXPONENT)?
	;
	
protected
EXPONENT
	: ('e'|'E') ('-'|'+')? (DIGIT)+
	;

ID
options {
	testLiterals = true;
	paraphrase="an identifier";
}
	:	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
	;
	
WS!	:	(' '
	|	'\t'
	|	'\n'	{newline();}
	|	'\r')
		{ _ttype = Token.SKIP; }
	;	