/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.xml;

import com.aliasi.xml.ElementStackFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WellFormedFilter
extends ElementStackFilter {
    private boolean mBegun;
    private boolean mEnded;
    private boolean mFoundTopLevel;

    public WellFormedFilter(DefaultHandler handler) {
        super(handler);
        this.reset();
    }

    public WellFormedFilter() {
        this.reset();
    }

    public final void reset() {
        this.mBegun = false;
        this.mEnded = false;
        this.mFoundTopLevel = false;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.testCharacters(target);
        this.testCharacters(data);
        super.processingInstruction(target, data);
    }

    public void startDocument() throws SAXException {
        if (this.mBegun) {
            String msg = "Document may only begin once.";
            throw new SAXException(msg);
        }
        this.mBegun = true;
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.testOpen("end document");
        if (!this.noElement()) {
            String msg = "Attempt to end document without closing element=" + this.currentElement();
            throw new SAXException(msg);
        }
        if (!this.mFoundTopLevel) {
            String msg = "Attempt to end document with no top-level element.";
            throw new SAXException(msg);
        }
        this.mEnded = true;
        super.endDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.testOpen("start element");
        if (this.noElement()) {
            if (this.mFoundTopLevel) {
                String msg = "Attempt to start second top-level element=" + qName;
                throw new SAXException(msg);
            }
            this.mFoundTopLevel = true;
        }
        this.testCharacters(qName);
        int i = atts.getLength();
        while (--i >= 0) {
            this.testCharacters(atts.getQName(i));
            this.testCharacters(atts.getValue(i));
        }
        super.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.testOpen("end element");
        if (this.noElement()) {
            String msg = "Attempt to close element with no open; element=" + qName;
            throw new SAXException(msg);
        }
        if (!qName.equals(this.currentElement())) {
            String msg = " Attempt to close element=" + qName + " does not match open element=" + this.currentElement();
            throw new SAXException(msg);
        }
        super.endElement(namespaceURI, localName, qName);
    }

    public void characters(char[] cs, int start, int length) throws SAXException {
        this.testOpen("characters");
        if (this.noElement()) {
            String msg = "Characters without containing element.";
            throw new SAXException(msg);
        }
        this.testCharacters(cs, start, length);
        super.characters(cs, start, length);
    }

    private void testCharacters(String s) throws SAXException {
        this.testCharacters(s.toCharArray(), 0, s.length());
    }

    private void testCharacters(char[] cs, int start, int length) throws SAXException {
        for (int i = 0; i < length; ++i) {
            char c = cs[start + i];
            if (c == '\ufffe') {
                String msg = "Illegal byte-order character=U+FFFE";
                throw new SAXException(msg);
            }
            if (c == '\uffff') {
                String msg = "Illegal sentinel character=U+FFFF";
                throw new SAXException(msg);
            }
            if (this.isLowSurrogate(c)) {
                if (++i == length) {
                    String msg = "Characters ended on low surrogate=U+" + Integer.toHexString(c);
                    throw new SAXException(msg);
                }
                char c2 = cs[start + i];
                if (!this.isHighSurrogate(c2)) {
                    String msg = "Low surrogate character=U+" + Integer.toHexString(c) + " not matched by high surrogate; following character=U+" + Integer.toHexString(c2);
                    throw new SAXException(msg);
                }
            }
            if (!this.isHighSurrogate(c)) continue;
            String msg = i == 0 ? "Illegal high surrogate at start of string, found character=U+" + Integer.toHexString(c) : "Illegal high surrogate character=U+" + Integer.toHexString(c) + " following non low surrogate character=U+" + Integer.toHexString(cs[start + i - 1]);
            throw new SAXException(msg);
        }
    }

    private boolean isLowSurrogate(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    private boolean isHighSurrogate(char c) {
        return c >= '\udc00' && c <= '\u0dff';
    }

    private void testOpen(String contextMsg) throws SAXException {
        if (!this.mBegun) {
            String msg = "Attempt to " + contextMsg + " before starting document.";
            throw new SAXException(msg);
        }
        if (this.mEnded) {
            String msg = "Attempt to " + contextMsg + " after document ended.";
            throw new SAXException(msg);
        }
    }
}

